/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.javadoc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.scijava.app.StatusService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.search.javadoc.JavadocService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.thread.ThreadService;

@Plugin(type=Service.class)
public class DefaultJavadocService
extends AbstractService
implements JavadocService {
    @Parameter
    private ThreadService threadService;
    @Parameter
    private StatusService statusService;
    @Parameter
    private LogService log;
    private Map<String, String> classURLs;

    @Override
    public String url(String className) {
        return this.classURLs().get(className);
    }

    private Map<String, String> classURLs() {
        if (this.classURLs == null) {
            this.initClassURLs();
        }
        return this.classURLs;
    }

    private synchronized void initClassURLs() {
        if (this.classURLs != null) {
            return;
        }
        this.classURLs = this.discoverJavadoc();
    }

    private Map<String, String> discoverJavadoc() {
        HashMap<String, String> classLinks = new HashMap<String, String>();
        String prefix = "https://javadoc.scijava.org/";
        Pattern iPattern = Pattern.compile(".*<a href=\"([A-Za-z0-9_-]+)/\">.*");
        Pattern pPattern = Pattern.compile(".*<[Aa] [Hh][Rr][Ee][Ff]=\"([^\"]+)\" [Tt][Ii][Tt][Ll][Ee]=\"[^\"]* ([^\"]*)\">(<[^>]+>)*([^<>]+)(<[^>]+>)*</[Aa]>.*");
        LinkedHashMap<String, Future> futures = new LinkedHashMap<String, Future>();
        this.statusService.showStatus(0, 1, "Querying javadoc");
        for (String line : this.lines("https://javadoc.scijava.org/index.html")) {
            String project;
            Matcher iMatcher = iPattern.matcher(line);
            if (!iMatcher.matches() || (project = iMatcher.replaceAll("$1")).equals("Java6") || project.equals("Java7")) continue;
            futures.put(project, this.threadService.run(() -> this.lines("https://javadoc.scijava.org/" + project + "/allclasses-noframe.html")));
        }
        int i = 0;
        int max = futures.size() + 1;
        this.statusService.showProgress(++i, max);
        for (String project : futures.keySet()) {
            try {
                this.statusService.showStatus(++i, max, "Processing javadoc: " + project);
                for (String line : (List)((Future)futures.get(project)).get()) {
                    Matcher pMatcher = pPattern.matcher(line);
                    if (!pMatcher.matches()) continue;
                    String link = pMatcher.group(1);
                    String pkg = pMatcher.group(2);
                    String clazz = pMatcher.group(4).replace('.', '$');
                    String fqcn = "&lt;Unnamed&gt;".equals(pkg) ? clazz : pkg + "." + clazz;
                    classLinks.putIfAbsent(fqcn, "https://javadoc.scijava.org/" + project + "/?" + link);
                }
            }
            catch (InterruptedException | ExecutionException exc) {
                if (!this.log.isDebug()) continue;
                this.log.debug((Object)("Error processing javadoc for " + project), (Throwable)exc);
            }
        }
        this.statusService.clearStatus();
        this.log.debug((Object)("Discovered " + classLinks.size() + " javadoc class links"));
        return classLinks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> lines(String url) {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(new URL(url).openStream(), StandardCharsets.UTF_8));){
            List<String> lines = r.lines().collect(Collectors.toList());
            if (this.log.isDebug()) {
                this.log.debug((Object)("Read " + lines.size() + " lines from URL: " + url));
            }
            List<String> list = lines;
            return list;
        }
        catch (IOException exc) {
            if (!this.log.isDebug()) return Collections.emptyList();
            this.log.debug((Object)("Error reading from URL: " + url), (Throwable)exc);
            return Collections.emptyList();
        }
    }
}

