/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.panorama;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.process.ImageProcessor;
import mpicbg.ij.InverseTransformMapping;
import mpicbg.ij.Mapping;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.panorama.AbstractPanorama_View;
import mpicbg.panorama.EquirectangularProjection;
import mpicbg.panorama.Util;

public class EquirectangularPanorama_View
extends AbstractPanorama_View {
    private final Mapping<EquirectangularProjection> mapping;
    private MappingThread painter;

    public EquirectangularPanorama_View() {
        this.mapping = new InverseTransformMapping((InverseCoordinateTransform)this.p.clone());
    }

    @Override
    protected boolean setup(ImagePlus imp) {
        GenericDialog gd = new GenericDialog("Panorama Viewer");
        gd.addMessage("Panorama");
        gd.addNumericField("min lambda : ", minLambda / Math.PI * 180.0, 2);
        gd.addNumericField("min phi : ", minPhi / Math.PI * 180.0, 2);
        gd.addNumericField("hfov : ", hfov / Math.PI * 180.0, 2);
        gd.addNumericField("vfov : ", vfov / Math.PI * 180.0, 2);
        gd.addMessage("Viewer Window");
        gd.addNumericField("width : ", (double)width, 0);
        gd.addNumericField("height : ", (double)height, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        minLambda = Util.mod(gd.getNextNumber(), 360.0) / 180.0 * Math.PI;
        minPhi = Util.mod(gd.getNextNumber(), 180.0) / 180.0 * Math.PI;
        hfov = Math.min(Math.PI * 2 - minLambda, Util.mod(gd.getNextNumber(), 360.0) / 180.0 * Math.PI);
        vfov = Math.min(Math.PI - minPhi, Util.mod(gd.getNextNumber(), 180.0) / 180.0 * Math.PI);
        if (hfov == 0.0) {
            hfov = Math.PI * 2;
        }
        if (vfov == 0.0) {
            vfov = Math.PI;
        }
        System.out.println(minLambda + " " + minPhi + " " + hfov + " " + vfov);
        width = (int)gd.getNextNumber();
        height = (int)gd.getNextNumber();
        return true;
    }

    @Override
    protected AbstractPanorama_View.AbstractMappingThread createPainter(ImagePlus impViewer) {
        this.ipSource = this.ip.createProcessor(hfov == Math.PI * 2 ? this.imp.getWidth() + 1 : this.imp.getWidth(), vfov == Math.PI ? this.imp.getHeight() + 1 : this.imp.getHeight());
        EquirectangularPanorama_View.prepareExtendedImage(this.imp.getProcessor(), this.ipSource);
        return new MappingThread(this.imp, impViewer, this.ipSource, this.ip, this.mapping, this.p);
    }

    private final class MappingThread
    extends AbstractPanorama_View.AbstractMappingThread {
        protected final ImageProcessor source;
        protected final Mapping<EquirectangularProjection> eqiMapping;
        protected final EquirectangularProjection projection;
        private boolean interpolate;

        public MappingThread(ImagePlus impSource, ImagePlus impTarget, ImageProcessor source, ImageProcessor target, Mapping<EquirectangularProjection> mapping, EquirectangularProjection p) {
            super(EquirectangularPanorama_View.this, impSource, impTarget, target);
            this.interpolate = true;
            this.source = source;
            this.eqiMapping = mapping;
            this.projection = p;
            this.setName("MappingThread");
        }

        @Override
        public final void map() {
            EquirectangularPanorama_View.this.lambda += this.dt * EquirectangularPanorama_View.this.dLambda;
            EquirectangularPanorama_View.this.phi += this.dt * EquirectangularPanorama_View.this.dPhi;
            this.projection.setOrientation(EquirectangularPanorama_View.this.lambda, EquirectangularPanorama_View.this.phi, EquirectangularPanorama_View.this.rho);
            ((EquirectangularProjection)this.eqiMapping.getTransform()).set(this.projection);
            this.temp.reset();
            if (this.interpolate) {
                this.eqiMapping.mapInterpolated(this.source, this.temp);
            } else {
                this.eqiMapping.map(this.source, this.temp);
            }
        }

        @Override
        public final void toggleInterpolation() {
            this.interpolate = !this.interpolate;
        }
    }
}

