/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.sequence;

import java.util.Arrays;
import mpicbg.spim.data.generic.sequence.BasicMultiResolutionSetupImgLoader;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.generic.sequence.ImgLoaderHints;
import mpicbg.spim.data.sequence.ConvertFloatUtils;
import mpicbg.spim.data.sequence.SetupImgLoader;
import net.imglib2.Dimensions;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.RealTypeConverters;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;

public interface MultiResolutionSetupImgLoader<T>
extends BasicMultiResolutionSetupImgLoader<T>,
SetupImgLoader<T> {
    @Override
    default public RandomAccessibleInterval<FloatType> getFloatImage(int timepointId, boolean normalize, ImgLoaderHint ... hints) {
        return this.getFloatImage(timepointId, 0, normalize, hints);
    }

    default public RandomAccessibleInterval<FloatType> getFloatImage(int timepointId, int level, boolean normalize, ImgLoaderHint ... hints) {
        Object type = this.getImageType();
        if (!(type instanceof RealType)) {
            throw new IllegalArgumentException("Don't know how to converter image of type " + type.getClass().getSimpleName() + " to FloatType");
        }
        RandomAccessibleInterval img = this.getImage(timepointId, level, hints);
        if (Arrays.asList(hints).contains(ImgLoaderHints.LOAD_COMPLETELY)) {
            ImgFactory factory;
            try {
                factory = Util.getSuitableImgFactory(img, (Object)new FloatType());
            }
            catch (UnsupportedOperationException e) {
                factory = new CellImgFactory((NativeType)new FloatType());
            }
            Img floatImg = factory.create(img);
            ConvertFloatUtils.copyFromToMultithreaded(img, floatImg);
            if (normalize) {
                ConvertFloatUtils.normalize((IterableInterval<FloatType>)floatImg);
            }
            return floatImg;
        }
        RandomAccessibleInterval<FloatType> floatImg = RealTypeConverters.convert(img, (RealType)new FloatType());
        return normalize ? ConvertFloatUtils.convertNormalize(floatImg) : floatImg;
    }

    @Override
    default public Dimensions getImageSize(int timepointId) {
        return this.getImageSize(timepointId, 0);
    }

    public Dimensions getImageSize(int var1, int var2);
}

