/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.measure.Calibration;
import ij.plugin.Filters3D;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.dog.DifferenceOfGaussian;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImagePlusAdapter;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import trainableSegmentation.FeatureStack;
import trainableSegmentation.FeatureStackArray;
import trainableSegmentation.ImageScience;

public class FeatureStack3D {
    private ImagePlus originalImage = null;
    private ArrayList<ImagePlus> wholeStack = null;
    private boolean colorFeatures = false;
    private int width = 0;
    private int height = 0;
    private float minimumSigma = 1.0f;
    private float maximumSigma = 8.0f;
    public static final int GAUSSIAN = 0;
    public static final int HESSIAN = 1;
    public static final int DERIVATIVES = 2;
    public static final int LAPLACIAN = 3;
    public static final int STRUCTURE = 4;
    public static final int EDGES = 5;
    public static final int DOG = 6;
    public static final int MINIMUM = 7;
    public static final int MAXIMUM = 8;
    public static final int MEAN = 9;
    public static final int MEDIAN = 10;
    public static final int VARIANCE = 11;
    public static final String[] availableFeatures = new String[]{"Gaussian_blur", "Hessian", "Derivatives", "Laplacian", "Structure", "Edges", "Difference_of_Gaussian", "Minimum", "Maximum", "Mean", "Median", "Variance"};
    public static final boolean[] IMAGESCIENCE_FEATURES = new boolean[]{false, true, true, true, true, true, false, false, false, false, false, false};
    private boolean[] enableFeatures = new boolean[]{false, false, false, false, false, false, false, false, false, true, false, true};
    private int minDerivativeOrder = 1;
    private int maxDerivativeOrder = 5;
    private double[] scaleFactor = null;
    private ExecutorService exe;

    public FeatureStack3D(ImagePlus image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.originalImage = image;
        this.wholeStack = new ArrayList();
        ImageStack is = new ImageStack(this.width, this.height);
        if (image.getType() == 4) {
            this.colorFeatures = true;
            for (int i = 1; i <= image.getImageStackSize(); ++i) {
                is.addSlice("original-slice-" + i, image.getImageStack().getProcessor(i));
            }
        } else {
            this.colorFeatures = false;
            for (int i = 1; i <= image.getImageStackSize(); ++i) {
                is.addSlice("original-slice-" + i, image.getImageStack().getProcessor(i).convertToFloat());
            }
        }
        this.scaleFactor = new double[3];
        this.scaleFactor[0] = 1.0;
        this.scaleFactor[1] = Double.compare(this.originalImage.getCalibration().pixelWidth, this.originalImage.getCalibration().pixelHeight) == 0 ? 1.0 : this.originalImage.getCalibration().pixelWidth / this.originalImage.getCalibration().pixelHeight;
        this.scaleFactor[2] = Double.compare(this.originalImage.getCalibration().pixelWidth, this.originalImage.getCalibration().pixelDepth) == 0 ? 1.0 : this.originalImage.getCalibration().pixelWidth / this.originalImage.getCalibration().pixelDepth;
    }

    public static boolean[] getDefaultEnabledFeatures() {
        return new boolean[]{false, false, false, false, false, false, false, false, false, true, false, true};
    }

    public Callable<ArrayList<ImagePlus>> getDerivatives(final ImagePlus originalImage, final double sigma, final int xOrder, final int yOrder, final int zOrder) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ArrayList<ImagePlus>>(){

            @Override
            public ArrayList<ImagePlus> call() {
                ImagePlus[] channels = FeatureStack3D.this.extractChannels(originalImage);
                ArrayList[] results = new ArrayList[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    results[ch] = new ArrayList();
                    ImagePlus channel = channels[ch].duplicate();
                    channel.getImageStack().addSlice("pad-back", channels[ch].getImageStack().getProcessor(channels[ch].getImageStackSize()));
                    channel.getImageStack().addSlice("pad-front", channels[ch].getImageStack().getProcessor(1), 1);
                    Calibration c = channel.getCalibration();
                    c.pixelWidth = 1.0 / FeatureStack3D.this.scaleFactor[0];
                    c.pixelHeight = 1.0 / FeatureStack3D.this.scaleFactor[1];
                    c.pixelDepth = 1.0 / FeatureStack3D.this.scaleFactor[2];
                    ImagePlus ip = ImageScience.computeDifferentialImage(sigma, xOrder, yOrder, zOrder, channel);
                    if (xOrder + yOrder + zOrder == 0) {
                        ip.setTitle(availableFeatures[0] + "_" + sigma);
                    } else {
                        ip.setTitle(availableFeatures[2] + "_" + xOrder + "_" + yOrder + "_" + zOrder + "_" + sigma);
                    }
                    ip.getImageStack().deleteLastSlice();
                    ip.getImageStack().deleteSlice(1);
                    results[ch].add(ip);
                }
                return FeatureStack3D.this.mergeResultChannels(results);
            }
        };
    }

    public Callable<ArrayList<ImagePlus>> getDoG(final ImagePlus originalImage, final double sigma1, final double sigma2) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ArrayList<ImagePlus>>(){

            @Override
            public ArrayList<ImagePlus> call() {
                ImagePlus[] channels = FeatureStack3D.this.extractChannels(originalImage);
                ArrayList[] results = new ArrayList[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    results[ch] = new ArrayList();
                    ImagePlus channel = channels[ch].duplicate();
                    ImagePlusImg image2 = ImagePlusAdapter.wrap((ImagePlus)channel);
                    ExtendedRandomAccessibleInterval mirrorImg = Views.extendMirrorSingle((RandomAccessibleInterval)image2);
                    double[] isoSigma1 = new double[mirrorImg.numDimensions()];
                    for (int d = 0; d < isoSigma1.length; ++d) {
                        isoSigma1[d] = sigma1 * FeatureStack3D.this.scaleFactor[d];
                    }
                    double[] isoSigma2 = new double[mirrorImg.numDimensions()];
                    for (int d = 0; d < isoSigma2.length; ++d) {
                        isoSigma2[d] = sigma2 * FeatureStack3D.this.scaleFactor[d];
                    }
                    DifferenceOfGaussian.DoG((double[])isoSigma1, (double[])isoSigma2, (RandomAccessible)mirrorImg, (RandomAccessibleInterval)image2, (ExecutorService)FeatureStack3D.this.exe);
                    ImagePlus ip = ImageJFunctions.wrapFloat((RandomAccessibleInterval)image2, (String)(availableFeatures[6] + "_" + sigma1 + "_" + sigma2));
                    results[ch].add(ip);
                }
                return FeatureStack3D.this.mergeResultChannels(results);
            }
        };
    }

    public Callable<ArrayList<ImagePlus>> getHessian(final ImagePlus originalImage, final double sigma, final boolean absolute) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ArrayList<ImagePlus>>(){

            @Override
            public ArrayList<ImagePlus> call() {
                ImagePlus[] channels = FeatureStack3D.this.extractChannels(originalImage);
                ArrayList[] results = new ArrayList[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    results[ch] = new ArrayList();
                    ImagePlus channel = channels[ch].duplicate();
                    channel.getImageStack().addSlice("pad-back", channels[ch].getImageStack().getProcessor(channels[ch].getImageStackSize()));
                    channel.getImageStack().addSlice("pad-front", channels[ch].getImageStack().getProcessor(1), 1);
                    Calibration c = channel.getCalibration();
                    c.pixelWidth = 1.0 / FeatureStack3D.this.scaleFactor[0];
                    c.pixelHeight = 1.0 / FeatureStack3D.this.scaleFactor[1];
                    c.pixelDepth = 1.0 / FeatureStack3D.this.scaleFactor[2];
                    ArrayList<ImagePlus> result = ImageScience.computeHessianImages(sigma, absolute, channel);
                    ImageStack smallest = result.get(0).getImageStack();
                    ImageStack middle = result.get(1).getImageStack();
                    ImageStack largest = result.get(2).getImageStack();
                    smallest.deleteLastSlice();
                    smallest.deleteSlice(1);
                    middle.deleteLastSlice();
                    middle.deleteSlice(1);
                    largest.deleteLastSlice();
                    largest.deleteSlice(1);
                    results[ch].add(new ImagePlus(availableFeatures[1] + "_largest_" + sigma + "_" + absolute, smallest));
                    results[ch].add(new ImagePlus(availableFeatures[1] + "_middle_" + sigma + "_" + absolute, middle));
                    results[ch].add(new ImagePlus(availableFeatures[1] + "_smallest_" + sigma + "_" + absolute, largest));
                }
                return FeatureStack3D.this.mergeResultChannels(results);
            }
        };
    }

    public Callable<ArrayList<ImagePlus>> getLaplacian(final ImagePlus originalImage, final double sigma) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ArrayList<ImagePlus>>(){

            @Override
            public ArrayList<ImagePlus> call() {
                ImagePlus[] channels = FeatureStack3D.this.extractChannels(originalImage);
                ArrayList[] results = new ArrayList[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    results[ch] = new ArrayList();
                    ImagePlus channel = channels[ch].duplicate();
                    channel.getImageStack().addSlice("pad-back", channels[ch].getImageStack().getProcessor(channels[ch].getImageStackSize()));
                    channel.getImageStack().addSlice("pad-front", channels[ch].getImageStack().getProcessor(1), 1);
                    Calibration c = channel.getCalibration();
                    c.pixelWidth = 1.0 / FeatureStack3D.this.scaleFactor[0];
                    c.pixelHeight = 1.0 / FeatureStack3D.this.scaleFactor[1];
                    c.pixelDepth = 1.0 / FeatureStack3D.this.scaleFactor[2];
                    ImagePlus ip = ImageScience.computeLaplacianImage(sigma, channel);
                    ip.setTitle(availableFeatures[3] + "_" + sigma);
                    ip.getImageStack().deleteLastSlice();
                    ip.getImageStack().deleteSlice(1);
                    results[ch].add(ip);
                }
                return FeatureStack3D.this.mergeResultChannels(results);
            }
        };
    }

    public Callable<ArrayList<ImagePlus>> getEdges(final ImagePlus originalImage, final double sigma) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ArrayList<ImagePlus>>(){

            @Override
            public ArrayList<ImagePlus> call() {
                ImagePlus[] channels = FeatureStack3D.this.extractChannels(originalImage);
                ArrayList[] results = new ArrayList[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    results[ch] = new ArrayList();
                    ImagePlus channel = channels[ch].duplicate();
                    channel.getImageStack().addSlice("pad-back", channels[ch].getImageStack().getProcessor(channels[ch].getImageStackSize()));
                    channel.getImageStack().addSlice("pad-front", channels[ch].getImageStack().getProcessor(1), 1);
                    Calibration c = channel.getCalibration();
                    c.pixelWidth = 1.0 / FeatureStack3D.this.scaleFactor[0];
                    c.pixelHeight = 1.0 / FeatureStack3D.this.scaleFactor[1];
                    c.pixelDepth = 1.0 / FeatureStack3D.this.scaleFactor[2];
                    ImagePlus ip = ImageScience.computeEdgesImage(sigma, channel);
                    ip.setTitle(availableFeatures[5] + "_" + sigma);
                    ip.getImageStack().deleteLastSlice();
                    ip.getImageStack().deleteSlice(1);
                    results[ch].add(ip);
                }
                return FeatureStack3D.this.mergeResultChannels(results);
            }
        };
    }

    public Callable<ArrayList<ImagePlus>> getMinimum(final ImagePlus originalImage, final double sigma) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ArrayList<ImagePlus>>(){

            @Override
            public ArrayList<ImagePlus> call() {
                ImagePlus im = originalImage.duplicate();
                if (originalImage.getType() != 4) {
                    ImageConverter ic = new ImageConverter(im);
                    ic.convertToGray32();
                }
                ArrayList<ImagePlus> result = new ArrayList<ImagePlus>();
                ImageStack is = Filters3D.filter((ImageStack)im.getImageStack(), (int)12, (float)((float)(sigma * FeatureStack3D.this.scaleFactor[0])), (float)((float)(sigma * FeatureStack3D.this.scaleFactor[1])), (float)((float)(sigma * FeatureStack3D.this.scaleFactor[2])));
                ImagePlus ip = new ImagePlus(availableFeatures[7] + "_" + sigma, is);
                result.add(ip);
                return result;
            }
        };
    }

    public Callable<ArrayList<ImagePlus>> getGaussian(final ImagePlus originalImage, final double sigma) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ArrayList<ImagePlus>>(){

            @Override
            public ArrayList<ImagePlus> call() {
                ImagePlus[] channels = FeatureStack3D.this.extractChannels(originalImage);
                ArrayList[] results = new ArrayList[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    results[ch] = new ArrayList();
                    ImagePlus im = channels[ch].duplicate();
                    ImagePlusImg image2 = ImagePlusAdapter.wrap((ImagePlus)im);
                    ExtendedRandomAccessibleInterval mirrorImg = Views.extendMirrorSingle((RandomAccessibleInterval)image2);
                    double[] isoSigma = new double[mirrorImg.numDimensions()];
                    for (int d = 0; d < isoSigma.length; ++d) {
                        isoSigma[d] = sigma * FeatureStack3D.this.scaleFactor[d];
                    }
                    try {
                        Gauss3.gauss((double[])isoSigma, (RandomAccessible)mirrorImg, (RandomAccessibleInterval)image2);
                    }
                    catch (IncompatibleTypeException e) {
                        IJ.log((String)"Error when calculating Gaussian feature.");
                        e.printStackTrace();
                        return null;
                    }
                    ImagePlus ip = ImageJFunctions.wrapFloat((RandomAccessibleInterval)image2, (String)(availableFeatures[0] + "_" + sigma));
                    results[ch].add(ip);
                }
                return FeatureStack3D.this.mergeResultChannels(results);
            }
        };
    }

    public Callable<ArrayList<ImagePlus>> getMaximum(final ImagePlus originalImage, final double sigma) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ArrayList<ImagePlus>>(){

            @Override
            public ArrayList<ImagePlus> call() {
                ImagePlus im = originalImage.duplicate();
                if (originalImage.getType() != 4) {
                    ImageConverter ic = new ImageConverter(im);
                    ic.convertToGray32();
                }
                ArrayList<ImagePlus> result = new ArrayList<ImagePlus>();
                ImageStack is = Filters3D.filter((ImageStack)im.getImageStack(), (int)13, (float)((float)(sigma * FeatureStack3D.this.scaleFactor[0])), (float)((float)(sigma * FeatureStack3D.this.scaleFactor[1])), (float)((float)(sigma * FeatureStack3D.this.scaleFactor[2])));
                ImagePlus ip = new ImagePlus(availableFeatures[8] + "_" + sigma, is);
                result.add(ip);
                return result;
            }
        };
    }

    public Callable<ArrayList<ImagePlus>> getMean(final ImagePlus originalImage, final double sigma) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ArrayList<ImagePlus>>(){

            @Override
            public ArrayList<ImagePlus> call() {
                ImagePlus im = originalImage.duplicate();
                if (originalImage.getType() != 4) {
                    ImageConverter ic = new ImageConverter(im);
                    ic.convertToGray32();
                }
                ArrayList<ImagePlus> result = new ArrayList<ImagePlus>();
                ImageStack is = Filters3D.filter((ImageStack)im.getImageStack(), (int)10, (float)((float)(sigma * FeatureStack3D.this.scaleFactor[0])), (float)((float)(sigma * FeatureStack3D.this.scaleFactor[1])), (float)((float)(sigma * FeatureStack3D.this.scaleFactor[2])));
                ImagePlus ip = new ImagePlus(availableFeatures[9] + "_" + sigma, is);
                result.add(ip);
                return result;
            }
        };
    }

    public Callable<ArrayList<ImagePlus>> getMedian(final ImagePlus originalImage, final double sigma) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ArrayList<ImagePlus>>(){

            @Override
            public ArrayList<ImagePlus> call() {
                ImagePlus im = originalImage.duplicate();
                if (originalImage.getType() != 4) {
                    ImageConverter ic = new ImageConverter(im);
                    ic.convertToGray32();
                }
                ArrayList<ImagePlus> result = new ArrayList<ImagePlus>();
                ImageStack is = Filters3D.filter((ImageStack)im.getImageStack(), (int)11, (float)((float)(sigma * FeatureStack3D.this.scaleFactor[0])), (float)((float)(sigma * FeatureStack3D.this.scaleFactor[1])), (float)((float)(sigma * FeatureStack3D.this.scaleFactor[2])));
                ImagePlus ip = new ImagePlus(availableFeatures[10] + "_" + sigma, is);
                result.add(ip);
                return result;
            }
        };
    }

    public Callable<ArrayList<ImagePlus>> getVariance(final ImagePlus originalImage, final double sigma) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ArrayList<ImagePlus>>(){

            @Override
            public ArrayList<ImagePlus> call() {
                ImagePlus im = originalImage.duplicate();
                if (originalImage.getType() != 4) {
                    ImageConverter ic = new ImageConverter(im);
                    ic.convertToGray32();
                }
                ArrayList<ImagePlus> result = new ArrayList<ImagePlus>();
                ImageStack is = Filters3D.filter((ImageStack)im.getImageStack(), (int)14, (float)((float)(sigma * FeatureStack3D.this.scaleFactor[0])), (float)((float)(sigma * FeatureStack3D.this.scaleFactor[1])), (float)((float)(sigma * FeatureStack3D.this.scaleFactor[2])));
                ImagePlus ip = new ImagePlus(availableFeatures[11] + "_" + sigma, is);
                result.add(ip);
                return result;
            }
        };
    }

    public Callable<ArrayList<ImagePlus>> getStructure(final ImagePlus originalImage, final double sigma, final double integrationScale) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ArrayList<ImagePlus>>(){

            @Override
            public ArrayList<ImagePlus> call() {
                ImagePlus[] channels = FeatureStack3D.this.extractChannels(originalImage);
                ArrayList[] results = new ArrayList[channels.length];
                for (int ch = 0; ch < channels.length; ++ch) {
                    results[ch] = new ArrayList();
                    ImagePlus channel = channels[ch].duplicate();
                    channel.getImageStack().addSlice("pad-back", channels[ch].getImageStack().getProcessor(channels[ch].getImageStackSize()));
                    channel.getImageStack().addSlice("pad-front", channels[ch].getImageStack().getProcessor(1), 1);
                    Calibration c = channel.getCalibration();
                    c.pixelWidth = 1.0 / FeatureStack3D.this.scaleFactor[0];
                    c.pixelHeight = 1.0 / FeatureStack3D.this.scaleFactor[1];
                    c.pixelDepth = 1.0 / FeatureStack3D.this.scaleFactor[2];
                    ArrayList<ImagePlus> result = ImageScience.computeEigenimages(sigma, integrationScale, channel);
                    ImageStack largest = result.get(0).getImageStack();
                    ImageStack middle = result.get(1).getImageStack();
                    ImageStack smallest = result.get(2).getImageStack();
                    smallest.deleteLastSlice();
                    smallest.deleteSlice(1);
                    middle.deleteLastSlice();
                    middle.deleteSlice(1);
                    largest.deleteLastSlice();
                    largest.deleteSlice(1);
                    results[ch].add(new ImagePlus(availableFeatures[4] + "_largest_" + sigma + "_" + integrationScale, largest));
                    results[ch].add(new ImagePlus(availableFeatures[4] + "_middle_" + sigma + "_" + integrationScale, middle));
                    results[ch].add(new ImagePlus(availableFeatures[4] + "_smallest_" + sigma + "_" + integrationScale, smallest));
                }
                return FeatureStack3D.this.mergeResultChannels(results);
            }
        };
    }

    ArrayList<ImagePlus> mergeResultChannels(ArrayList<ImagePlus>[] channels) {
        if (channels.length > 1) {
            ArrayList<ImagePlus> mergedList = new ArrayList<ImagePlus>();
            for (int i = 0; i < channels[0].size(); ++i) {
                ImageStack mergedColorStack = this.mergeStacks(channels[0].get(i).getImageStack(), channels[1].get(i).getImageStack(), channels[2].get(i).getImageStack());
                ImagePlus merged = new ImagePlus(channels[0].get(i).getTitle(), mergedColorStack);
                for (int n = 1; n <= merged.getImageStackSize(); ++n) {
                    merged.getImageStack().setSliceLabel(channels[0].get(i).getImageStack().getSliceLabel(n), n);
                }
                mergedList.add(merged);
            }
            return mergedList;
        }
        return channels[0];
    }

    ImageStack mergeStacks(ImageStack redChannel, ImageStack greenChannel, ImageStack blueChannel) {
        ImageStack colorStack = new ImageStack(redChannel.getWidth(), redChannel.getHeight());
        for (int n = 1; n <= redChannel.getSize(); ++n) {
            ByteProcessor red = (ByteProcessor)redChannel.getProcessor(n).convertToByte(false);
            ByteProcessor green = (ByteProcessor)greenChannel.getProcessor(n).convertToByte(false);
            ByteProcessor blue = (ByteProcessor)blueChannel.getProcessor(n).convertToByte(false);
            ColorProcessor cp = new ColorProcessor(redChannel.getWidth(), redChannel.getHeight());
            cp.setRGB((byte[])red.getPixels(), (byte[])green.getPixels(), (byte[])blue.getPixels());
            colorStack.addSlice(redChannel.getSliceLabel(n), (ImageProcessor)cp);
        }
        return colorStack;
    }

    ImagePlus[] extractChannels(ImagePlus originalImage) {
        ImagePlus[] channels;
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        if (originalImage.getType() == 4) {
            ImageStack isRed = new ImageStack(width, height);
            ImageStack isGreen = new ImageStack(width, height);
            ImageStack isBlue = new ImageStack(width, height);
            for (int n = 1; n <= originalImage.getImageStackSize(); ++n) {
                ByteProcessor redBp = new ByteProcessor(width, height);
                ByteProcessor greenBp = new ByteProcessor(width, height);
                ByteProcessor blueBp = new ByteProcessor(width, height);
                byte[] redPixels = (byte[])redBp.getPixels();
                byte[] greenPixels = (byte[])greenBp.getPixels();
                byte[] bluePixels = (byte[])blueBp.getPixels();
                ((ColorProcessor)originalImage.getImageStack().getProcessor(n).duplicate()).getRGB(redPixels, greenPixels, bluePixels);
                isRed.addSlice(null, redBp.convertToFloat());
                isGreen.addSlice(null, greenBp.convertToFloat());
                isBlue.addSlice(null, blueBp.convertToFloat());
            }
            channels = new ImagePlus[]{new ImagePlus("red", isRed), new ImagePlus("green", isGreen), new ImagePlus("blue", isBlue)};
        } else {
            channels = new ImagePlus[1];
            ImageStack is = new ImageStack(width, height);
            for (int i = 1; i <= originalImage.getImageStackSize(); ++i) {
                is.addSlice("original-slice-" + i, originalImage.getImageStack().getProcessor(i).convertToFloat());
            }
            channels[0] = new ImagePlus(originalImage.getTitle(), is);
        }
        for (int i = 0; i < channels.length; ++i) {
            channels[i].setCalibration(originalImage.getCalibration());
        }
        return channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean updateFeaturesMT() {
        int i;
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        this.exe = Executors.newFixedThreadPool(Prefs.getThreads());
        this.wholeStack = new ArrayList();
        ImageStack is = new ImageStack(this.width, this.height);
        if (this.colorFeatures) {
            for (i = 1; i <= this.originalImage.getImageStackSize(); ++i) {
                is.addSlice("original-slice-" + i, this.originalImage.getImageStack().getProcessor(i));
            }
        } else {
            for (i = 1; i <= this.originalImage.getImageStackSize(); ++i) {
                is.addSlice("original-slice-" + i, this.originalImage.getImageStack().getProcessor(i).convertToFloat());
            }
        }
        this.wholeStack.add(new ImagePlus("original", is));
        int finalIndex = 0;
        for (int i2 = 0; i2 < this.enableFeatures.length; ++i2) {
            if (!this.enableFeatures[i2]) continue;
            ++finalIndex;
        }
        ArrayList<Future<ArrayList<ImagePlus>>> futures = new ArrayList<Future<ArrayList<ImagePlus>>>();
        int currentIndex = 0;
        IJ.showStatus((String)"Updating features...");
        try {
            for (float i3 = this.minimumSigma; i3 <= this.maximumSigma; i3 *= 2.0f) {
                if (Thread.currentThread().isInterrupted()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.enableFeatures[0]) {
                    futures.add(this.exe.submit(this.getGaussian(this.originalImage, i3)));
                }
                if (this.enableFeatures[6]) {
                    for (float f = this.minimumSigma; f < i3; f *= 2.0f) {
                        futures.add(this.exe.submit(this.getDoG(this.originalImage, f, i3)));
                    }
                }
                if (this.enableFeatures[1]) {
                    futures.add(this.exe.submit(this.getHessian(this.originalImage, i3, true)));
                }
                if (this.enableFeatures[2]) {
                    void var6_13;
                    int n = this.minDerivativeOrder;
                    while (var6_13 <= this.maxDerivativeOrder) {
                        futures.add(this.exe.submit(this.getDerivatives(this.originalImage, i3, (int)var6_13, (int)var6_13, (int)var6_13)));
                        ++var6_13;
                    }
                }
                if (this.enableFeatures[3]) {
                    futures.add(this.exe.submit(this.getLaplacian(this.originalImage, i3)));
                }
                if (this.enableFeatures[5]) {
                    futures.add(this.exe.submit(this.getEdges(this.originalImage, i3)));
                }
                if (this.enableFeatures[4]) {
                    void bl;
                    boolean bl2 = true;
                    while (bl <= 3) {
                        futures.add(this.exe.submit(this.getStructure(this.originalImage, i3, (double)bl)));
                        bl += 2;
                    }
                }
                if (this.enableFeatures[7]) {
                    futures.add(this.exe.submit(this.getMinimum(this.originalImage, i3)));
                }
                if (this.enableFeatures[8]) {
                    futures.add(this.exe.submit(this.getMaximum(this.originalImage, i3)));
                }
                if (this.enableFeatures[9]) {
                    futures.add(this.exe.submit(this.getMean(this.originalImage, i3)));
                }
                if (this.enableFeatures[10]) {
                    futures.add(this.exe.submit(this.getMedian(this.originalImage, i3)));
                }
                if (!this.enableFeatures[11]) continue;
                futures.add(this.exe.submit(this.getVariance(this.originalImage, i3)));
            }
            for (Future bl : futures) {
                ArrayList res = (ArrayList)bl.get();
                IJ.showStatus((String)"Updating features...");
                IJ.showProgress((int)(++currentIndex), (int)finalIndex);
                for (ImagePlus ip : res) {
                    this.wholeStack.add(ip);
                }
            }
        }
        catch (InterruptedException ie) {
            IJ.log((String)"The features udpate was interrupted by the user.");
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            IJ.log((String)"Error when updating feature stack.");
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.exe.shutdownNow();
        }
        IJ.showProgress((double)1.0);
        IJ.showStatus((String)"Features stack is updated now!");
        return true;
    }

    public FeatureStackArray getFeatureStackArray() {
        FeatureStackArray fsa = new FeatureStackArray(this.originalImage.getImageStackSize(), this.minimumSigma, this.maximumSigma, false, 0, 0, this.enableFeatures);
        for (int i = 0; i < this.originalImage.getImageStackSize(); ++i) {
            FeatureStack fs = new FeatureStack(this.width, this.height, this.colorFeatures);
            fsa.set(fs, i);
        }
        for (ImagePlus ip : this.wholeStack) {
            for (int n = 1; n <= ip.getImageStackSize(); ++n) {
                ImageProcessor slice = ip.getImageStack().getProcessor(n).duplicate();
                fsa.get(n - 1).getStack().addSlice(ip.getTitle(), slice);
            }
        }
        return fsa;
    }

    public void setMinimumSigma(float minimumSigma) {
        this.minimumSigma = minimumSigma;
    }

    public void setMaximumSigma(float maximumSigma) {
        this.maximumSigma = maximumSigma;
    }

    public void setEnableFeatures(boolean[] enableFeatures) {
        this.enableFeatures = enableFeatures;
    }

    public boolean[] getEnabledFeatures() {
        return this.enableFeatures;
    }
}

