/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.detection;

import ij.ImagePlus;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.imagej.Dataset;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.display.ImageDisplayService;
import net.imagej.ops.OpService;
import net.imagej.ops.Ops;
import net.imglib2.RealPoint;
import net.imglib2.roi.geom.real.Polyline;
import net.imglib2.type.numeric.RealType;
import org.scijava.convert.ConvertService;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;
import sc.fiji.filamentdetector.ImageUtilService;
import sc.fiji.filamentdetector.detection.AbstractFilamentDetector;
import sc.fiji.filamentdetector.detection.FilamentDetector;
import sc.fiji.filamentdetector.event.ImageNotFoundEvent;
import sc.fiji.filamentdetector.model.Filament;
import sc.fiji.filamentdetector.model.FilamentFactory;
import sc.fiji.filamentdetector.model.Filaments;
import sc.fiji.filamentdetector.overlay.ColorService;

@Plugin(type=FilamentDetector.class, priority=100.0)
public class IJ2RidgeDetectionFilamentDetector
extends AbstractFilamentDetector {
    private static String NAME = "IJ2 Ridge Detection";
    @Parameter
    private ConvertService convertService;
    @Parameter
    private LogService log;
    @Parameter
    private OpService op;
    @Parameter
    private ColorService colorService;
    @Parameter
    private EventService eventService;
    @Parameter
    private UIService ui;
    @Parameter
    private ImageDisplayService imds;
    @Parameter
    private ImageUtilService ijUtil;
    private double lineWidth = 3.5;
    private double higherThreshold = 20.0;
    private double lowerThreshold = 7.0;
    private boolean detectJunctions = false;

    public IJ2RidgeDetectionFilamentDetector() {
        this.setName(NAME);
    }

    private void initDetection() {
        this.colorService.initialize();
        this.setFilaments(new Filaments());
    }

    @Override
    public void detect() {
        this.detect(0);
    }

    @Override
    public void detect(int channelIndex) {
        this.initDetection();
        long numT = this.getDataset().dimension(Axes.TIME);
        int t = 0;
        while ((long)t < numT) {
            this.detectFrame(t, channelIndex);
            ++t;
        }
        this.simplifyFilaments();
    }

    @Override
    public void detectCurrentFrame() {
        this.detectCurrentFrame(0);
    }

    @Override
    public void detectCurrentFrame(int channelIndex) {
        this.initDetection();
        ImagePlus imp = null;
        try {
            imp = (ImagePlus)this.convertService.convert((Object)this.getImageDisplay(), ImagePlus.class);
            int currentFrame = imp.getFrame() - 1;
            this.detectFrame(currentFrame, channelIndex);
            this.simplifyFilaments();
        }
        catch (NullPointerException e) {
            this.eventService.publish((SciJavaEvent)new ImageNotFoundEvent());
        }
    }

    @Override
    public void detectFrame(int frame) {
        this.detectFrame(frame, 0);
    }

    @Override
    public void detectFrame(int frame, int channel) {
        Filaments filaments = this.getFilaments();
        if (filaments == null) {
            filaments = new Filaments();
        }
        Dataset dataset = this.getDataset();
        ImgPlus img = dataset.getImgPlus();
        ImgPlus<? extends RealType<?>> slice = this.ijUtil.cropAlongAxis(img, Axes.TIME, frame);
        slice = this.ijUtil.cropAlongAxis(slice, Axes.CHANNEL, channel);
        List lines = new ArrayList();
        lines = (List)this.op.run(Ops.Segment.DetectRidges.class, new Object[]{slice.getImg(), this.lineWidth, this.lowerThreshold, this.higherThreshold, (int)this.lineWidth});
        if (this.detectJunctions) {
            List junctions = (List)this.op.run(Ops.Segment.DetectJunctions.class, new Object[]{lines});
            for (RealPoint p : junctions) {
                this.log.info((Object)p);
            }
        }
        for (Polyline line : lines) {
            Filament filament = FilamentFactory.fromPolyline(line, frame);
            Color color = this.colorService.getColor(filaments.size() + 1);
            filament.setColor(color);
            filaments.add(filament);
        }
        this.setFilaments(filaments);
    }

    public double getUpperThreshold() {
        return this.higherThreshold;
    }

    public void setUpperThreshold(double upperThresh) {
        this.higherThreshold = upperThresh;
    }

    public double getLowerThreshold() {
        return this.lowerThreshold;
    }

    public void setLowerThreshold(double lowerThresh) {
        this.lowerThreshold = lowerThresh;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public boolean isDetectJunctions() {
        return this.detectJunctions;
    }

    public void setDetectJunctions(boolean detectJunctions) {
        this.detectJunctions = detectJunctions;
    }

    @Override
    public String toString() {
        String out = "";
        out = out + "Detector : " + this.getName() + "\n";
        out = out + "Line Width = " + this.lineWidth + "\n";
        out = out + "Lower Threshold = " + this.lowerThreshold + "\n";
        out = out + "Upper Threshold = " + this.higherThreshold + "\n";
        out = out + "Detect Only Current Frame = " + this.isDetectOnlyCurrentFrame() + "\n";
        out = out + "Simplify Filaments = " + this.isSimplifyFilaments() + "\n";
        out = out + "Simplify Tolerance Distance = " + this.getSimplifyToleranceDistance();
        return out;
    }
}

