/*
 * Decompiled with CFR 0.152.
 */
package customnode.u3d;

import customnode.u3d.Constants;
import customnode.u3d.ContextManager;
import customnode.u3d.DataBlock;

public class BitStreamRead {
    private final ContextManager contextManager = new ContextManager();
    private long high = 65535L;
    private long low;
    private long underflow;
    private long code;
    private long[] data;
    private long dataPosition;
    private long dataLocal;
    private long dataLocalNext;
    private int dataBitOffset;
    private static final long[] FastNotMask = new long[]{65535L, 32767L, 16383L, 8191L, 4095L};
    private static final long[] ReadCount = new long[]{4L, 3L, 2L, 2L, 1L, 1L, 1L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};

    public short ReadU8() {
        long uValue = this.ReadSymbol(0L);
        --uValue;
        uValue = this.SwapBits8(uValue);
        short rValue = (short)uValue;
        return rValue;
    }

    public int ReadU16() {
        short low = this.ReadU8();
        short high = this.ReadU8();
        return low | high << 8;
    }

    public long ReadU32() {
        int low = this.ReadU16();
        int high = this.ReadU16();
        long rValue = (long)low | (long)(high << 16);
        return rValue;
    }

    public int ReadI32() {
        long uValue = this.ReadU32();
        return (int)uValue;
    }

    public float ReadF32() {
        long uValue = this.ReadU32();
        return Float.intBitsToFloat((int)uValue);
    }

    public long ReadCompressedU32(long context) {
        long rValue;
        long symbol = 0L;
        if (context != 0L && context < 17407L) {
            symbol = this.ReadSymbol(context);
            if (symbol != 0L) {
                rValue = symbol - 1L;
            } else {
                rValue = this.ReadU32();
                this.contextManager.AddSymbol(context, rValue + 1L);
            }
        } else {
            rValue = this.ReadU32();
        }
        return rValue;
    }

    public int ReadCompressedU16(long context) {
        int rValue;
        long symbol = 0L;
        if (context != 0L && context < 17407L) {
            symbol = this.ReadSymbol(context);
            if (symbol != 0L) {
                rValue = (int)(symbol - 1L);
            } else {
                rValue = this.ReadU16();
                this.contextManager.AddSymbol(context, rValue + 1);
            }
        } else {
            rValue = this.ReadU16();
        }
        return rValue;
    }

    public short ReadCompressedU8(long context) {
        short rValue;
        long symbol = 0L;
        if (context != 0L && context < 17407L) {
            symbol = this.ReadSymbol(context);
            if (symbol != 0L) {
                rValue = (short)(symbol - 1L);
            } else {
                rValue = this.ReadU8();
                this.contextManager.AddSymbol(context, (long)rValue + 1L);
            }
        } else {
            rValue = this.ReadU8();
        }
        return rValue;
    }

    public void SetDataBlock(DataBlock dataBlock) {
        long[] tempData = dataBlock.getData();
        this.data = new long[tempData.length];
        System.arraycopy(tempData, 0, this.data, 0, tempData.length);
        this.dataPosition = 0L;
        this.dataBitOffset = 0;
        this.GetLocal();
    }

    private long SwapBits8(long rValue) {
        return Constants.Swap8[(int)(rValue & 0xFL)] << 4 | Constants.Swap8[(int)(rValue >> 4)];
    }

    private long ReadSymbol(long context) {
        long uValue = 0L;
        long position = this.GetBitCount();
        this.code = this.ReadBit();
        this.dataBitOffset += (int)this.underflow;
        while (this.dataBitOffset >= 32) {
            this.dataBitOffset -= 32;
            this.IncrementPosition();
        }
        long temp = this.Read15Bits();
        this.code <<= 15;
        this.code |= temp;
        this.SeekToBit(position);
        long totalCumFreq = this.contextManager.GetTotalSymbolFrequency(context);
        long range = this.high + 1L - this.low;
        long codeCumFreq = (totalCumFreq * (1L + this.code - this.low) - 1L) / range;
        uValue = this.contextManager.GetSymbolFromFrequency(context, codeCumFreq);
        long valueCumFreq = this.contextManager.GetCumulativeSymbolFrequency(context, uValue);
        long valueFreq = this.contextManager.GetSymbolFrequency(context, uValue);
        long low = this.low;
        long high = this.high;
        high = low - 1L + range * (valueCumFreq + valueFreq) / totalCumFreq;
        this.contextManager.AddSymbol(context, uValue);
        int bitCount = (int)ReadCount[(int)(((low += range * valueCumFreq / totalCumFreq) >> 12 ^ high >> 12) & 0xFL)];
        low &= FastNotMask[bitCount];
        high &= FastNotMask[bitCount];
        high <<= bitCount;
        long maskedLow = 0x8000L & (low <<= bitCount);
        long maskedHigh = 0x8000L & (high |= (long)((1 << bitCount) - 1));
        while ((maskedLow | maskedHigh) == 0L || maskedLow == 32768L && maskedHigh == 32768L) {
            low = (0x7FFFL & low) << 1;
            high = (0x7FFFL & high) << 1 | 1L;
            maskedLow = 0x8000L & low;
            maskedHigh = 0x8000L & high;
            ++bitCount;
        }
        long savedBitsLow = maskedLow;
        long savedBitsHigh = maskedHigh;
        if (bitCount > 0) {
            bitCount += (int)this.underflow;
            this.underflow = 0L;
        }
        maskedLow = 0x4000L & low;
        maskedHigh = 0x4000L & high;
        long underflow = 0L;
        while (maskedLow == 16384L && maskedHigh == 0L) {
            low &= 0x3FFFL;
            high &= 0x3FFFL;
            low += low;
            high += high;
            maskedLow = 0x4000L & low;
            maskedHigh = 0x4000L & (high |= 1L);
            ++underflow;
        }
        this.underflow += underflow;
        this.low = low |= savedBitsLow;
        this.high = high |= savedBitsHigh;
        this.dataBitOffset += bitCount;
        while (this.dataBitOffset >= 32) {
            this.dataBitOffset -= 32;
            this.IncrementPosition();
        }
        long rSymbol = uValue;
        return rSymbol;
    }

    private long GetBitCount() {
        return (this.dataPosition << 5) + (long)this.dataBitOffset;
    }

    private long ReadBit() {
        long uValue = 0L;
        uValue = this.dataLocal >> this.dataBitOffset;
        uValue &= 1L;
        ++this.dataBitOffset;
        if (this.dataBitOffset >= 32) {
            this.dataBitOffset -= 32;
            this.IncrementPosition();
        }
        long rValue = uValue;
        return rValue;
    }

    private long Read15Bits() {
        long uValue = this.dataLocal >> this.dataBitOffset;
        if (this.dataBitOffset > 17) {
            uValue |= this.dataLocalNext << 32 - this.dataBitOffset;
        }
        uValue += uValue;
        long rValue = uValue = Constants.Swap8[(int)(uValue >> 12 & 0xFL)] | Constants.Swap8[(int)(uValue >> 8 & 0xFL)] << 4 | Constants.Swap8[(int)(uValue >> 4 & 0xFL)] << 8 | Constants.Swap8[(int)(uValue & 0xFL)] << 12;
        this.dataBitOffset += 15;
        if (this.dataBitOffset >= 32) {
            this.dataBitOffset -= 32;
            this.IncrementPosition();
        }
        return rValue;
    }

    private void IncrementPosition() {
        ++this.dataPosition;
        this.dataLocal = this.data[(int)this.dataPosition];
        this.dataLocalNext = (long)this.data.length > this.dataPosition + 1L ? this.data[(int)this.dataPosition + 1] : 0L;
    }

    private void SeekToBit(long position) {
        this.dataPosition = position >> 5;
        this.dataBitOffset = (int)(position & 0x1FL);
        this.GetLocal();
    }

    private void GetLocal() {
        this.dataLocal = this.data[(int)this.dataPosition];
        if ((long)this.data.length > this.dataPosition + 1L) {
            this.dataLocalNext = this.data[(int)this.dataPosition + 1];
        }
    }
}

