/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.imglib2.KDTree;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPointSampleList;
import net.imglib2.roi.geom.real.ClosedWritableBox;
import net.imglib2.roi.geom.real.ClosedWritableEllipsoid;
import net.imglib2.roi.geom.real.ClosedWritablePolygon2D;
import net.imglib2.roi.geom.real.ClosedWritableSphere;
import net.imglib2.roi.geom.real.ClosedWritableSuperEllipsoid;
import net.imglib2.roi.geom.real.DefaultWritableLine;
import net.imglib2.roi.geom.real.DefaultWritablePointMask;
import net.imglib2.roi.geom.real.DefaultWritablePolygon2D;
import net.imglib2.roi.geom.real.DefaultWritablePolyline;
import net.imglib2.roi.geom.real.DefaultWritableRealPointCollection;
import net.imglib2.roi.geom.real.KDTreeRealPointCollection;
import net.imglib2.roi.geom.real.OpenWritableBox;
import net.imglib2.roi.geom.real.OpenWritableEllipsoid;
import net.imglib2.roi.geom.real.OpenWritablePolygon2D;
import net.imglib2.roi.geom.real.OpenWritableSphere;
import net.imglib2.roi.geom.real.OpenWritableSuperEllipsoid;
import net.imglib2.roi.geom.real.RealPointCollection;
import net.imglib2.roi.geom.real.RealPointSampleListWritableRealPointCollection;
import net.imglib2.roi.geom.real.WritableBox;
import net.imglib2.roi.geom.real.WritableEllipsoid;
import net.imglib2.roi.geom.real.WritableLine;
import net.imglib2.roi.geom.real.WritablePointMask;
import net.imglib2.roi.geom.real.WritablePolygon2D;
import net.imglib2.roi.geom.real.WritablePolyline;
import net.imglib2.roi.geom.real.WritableRealPointCollection;
import net.imglib2.roi.geom.real.WritableSphere;
import net.imglib2.roi.geom.real.WritableSuperEllipsoid;

public class GeomMasks {
    private GeomMasks() {
    }

    public static WritableBox closedBox(double[] min, double[] max) {
        return new ClosedWritableBox(min, max);
    }

    public static WritableBox openBox(double[] min, double[] max) {
        return new OpenWritableBox(min, max);
    }

    public static WritableEllipsoid closedEllipsoid(double[] center, double[] semiAxisLengths) {
        return new ClosedWritableEllipsoid(center, semiAxisLengths);
    }

    public static WritableEllipsoid openEllipsoid(double[] center, double[] semiAxisLengths) {
        return new OpenWritableEllipsoid(center, semiAxisLengths);
    }

    public static WritableLine line(RealLocalizable pointOne, RealLocalizable pointTwo) {
        return new DefaultWritableLine(pointOne, pointTwo);
    }

    public static WritableLine line(double[] pointOne, double[] pointTwo, boolean copy) {
        return new DefaultWritableLine(pointOne, pointTwo, copy);
    }

    public static WritablePointMask pointMask(double[] point) {
        return new DefaultWritablePointMask(point);
    }

    public static WritablePointMask pointMask(RealLocalizable point) {
        return new DefaultWritablePointMask(point);
    }

    public static WritablePolygon2D polygon2D(List<? extends RealLocalizable> vertices) {
        return new DefaultWritablePolygon2D(vertices);
    }

    public static WritablePolygon2D polygon2D(double[] x, double[] y) {
        return new DefaultWritablePolygon2D(x, y);
    }

    public static WritablePolygon2D closedPolygon2D(List<? extends RealLocalizable> vertices) {
        return new ClosedWritablePolygon2D(vertices);
    }

    public static WritablePolygon2D closedPolygon2D(double[] x, double[] y) {
        return new ClosedWritablePolygon2D(x, y);
    }

    public static WritablePolygon2D openPolygon2D(List<? extends RealLocalizable> vertices) {
        return new OpenWritablePolygon2D(vertices);
    }

    public static WritablePolygon2D openPolygon2D(double[] x, double[] y) {
        return new OpenWritablePolygon2D(x, y);
    }

    public static WritablePolyline polyline(List<? extends RealLocalizable> vertices) {
        return new DefaultWritablePolyline(vertices);
    }

    public static <L extends RealLocalizable> WritableRealPointCollection<L> realPointCollection(HashMap<TDoubleArrayList, L> points) {
        return new DefaultWritableRealPointCollection<L>(points);
    }

    public static <L extends RealLocalizable> WritableRealPointCollection<L> realPointCollection(Collection<L> points) {
        return new DefaultWritableRealPointCollection<L>(points);
    }

    public static <L extends RealLocalizable> RealPointCollection<L> kDTreeRealPointCollection(KDTree<L> tree) {
        return new KDTreeRealPointCollection<L>(tree);
    }

    public static <L extends RealLocalizable> KDTreeRealPointCollection<L> kDTreeRealPointCollection(Collection<L> points) {
        return new KDTreeRealPointCollection<L>(points);
    }

    public static <L extends RealLocalizable> WritableRealPointCollection<L> realPointSampleListRealPointCollection(RealPointSampleList<L> points) {
        return new RealPointSampleListWritableRealPointCollection<L>(points);
    }

    public static <L extends RealLocalizable> RealPointSampleListWritableRealPointCollection<L> realPointSampleListRealPointCollection(Collection<L> points) {
        return new RealPointSampleListWritableRealPointCollection<L>(points);
    }

    public static WritableSphere closedSphere(double[] center, double radius) {
        return new ClosedWritableSphere(center, radius);
    }

    public static WritableSphere openSphere(double[] center, double radius) {
        return new OpenWritableSphere(center, radius);
    }

    public static WritableSuperEllipsoid closedSuperEllipsoid(double[] center, double[] semiAxisLengths, double exponent) {
        if (exponent == 2.0) {
            return new ClosedWritableEllipsoid(center, semiAxisLengths);
        }
        return new ClosedWritableSuperEllipsoid(center, semiAxisLengths, exponent);
    }

    public static WritableSuperEllipsoid openSuperEllipsoid(double[] center, double[] semiAxisLengths, double exponent) {
        if (exponent == 2.0) {
            return new OpenWritableEllipsoid(center, semiAxisLengths);
        }
        return new OpenWritableSuperEllipsoid(center, semiAxisLengths, exponent);
    }
}

