/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jcodings.Encoding;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Numeric;
import org.jruby.util.StringSupport;
import org.jruby.util.io.EncodingUtils;

@JRubyClass(name={"Integer"}, parent="Numeric", include={"Precision"})
public abstract class RubyInteger
extends RubyNumeric {
    static final ByteList[] SINGLE_CHAR_BYTELISTS = new ByteList[256];
    @Deprecated
    public static final ByteList[] SINGLE_CHAR_BYTELISTS19;

    public static RubyClass createIntegerClass(Ruby runtime) {
        RubyClass integer = runtime.defineClass("Integer", runtime.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setInteger(integer);
        integer.setClassIndex(ClassIndex.INTEGER);
        integer.setReifiedClass(RubyInteger.class);
        integer.kindOf = new RubyModule.JavaClassKindOf(RubyInteger.class);
        integer.getSingletonClass().undefineMethod("new");
        integer.defineAnnotatedMethods(RubyInteger.class);
        return integer;
    }

    public RubyInteger(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public RubyInteger(RubyClass rubyClass) {
        super(rubyClass);
    }

    public RubyInteger(Ruby runtime, RubyClass rubyClass, boolean useObjectSpace) {
        super(runtime, rubyClass, useObjectSpace);
    }

    @Deprecated
    public RubyInteger(Ruby runtime, RubyClass rubyClass, boolean useObjectSpace, boolean canBeTainted) {
        super(runtime, rubyClass, useObjectSpace, canBeTainted);
    }

    @Override
    public RubyInteger convertToInteger() {
        return this;
    }

    protected RubyFloat toFloat() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    @Override
    @JRubyMethod(name={"integer?"})
    public IRubyObject integer_p() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod
    public IRubyObject upto(ThreadContext context, IRubyObject to, Block block) {
        if (block.isGiven()) {
            if (this instanceof RubyFixnum && to instanceof RubyFixnum) {
                RubyInteger.fixnumUpto(context, ((RubyFixnum)this).getLongValue(), ((RubyFixnum)to).getLongValue(), block);
            } else {
                RubyInteger.duckUpto(context, this, to, block);
            }
            return this;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, (IRubyObject)this, "upto", new IRubyObject[]{to}, RubyInteger.uptoSize(context, this, to));
    }

    private static void fixnumUpto(ThreadContext context, long from, long to, Block block) {
        Ruby runtime = context.runtime;
        if (block.getSignature() == Signature.NO_ARGUMENTS) {
            long i2;
            IRubyObject nil = runtime.getNil();
            for (i2 = from; i2 < to; ++i2) {
                block.yield(context, nil);
            }
            if (i2 <= to) {
                block.yield(context, nil);
            }
        } else {
            long i3;
            for (i3 = from; i3 < to; ++i3) {
                block.yield(context, RubyFixnum.newFixnum(runtime, i3));
            }
            if (i3 <= to) {
                block.yield(context, RubyFixnum.newFixnum(runtime, i3));
            }
        }
    }

    private static void duckUpto(ThreadContext context, IRubyObject from, IRubyObject to, Block block) {
        Ruby runtime = context.runtime;
        IRubyObject i2 = from;
        RubyFixnum one = RubyFixnum.one(runtime);
        while (!RubyInteger.sites((ThreadContext)context).op_gt.call(context, i2, i2, to).isTrue()) {
            block.yield(context, i2);
            i2 = RubyInteger.sites((ThreadContext)context).op_plus.call(context, i2, i2, (IRubyObject)one);
        }
    }

    private static RubyEnumerator.SizeFn uptoSize(final ThreadContext context, final IRubyObject from, final IRubyObject to) {
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                return RubyNumeric.intervalStepSize(context, from, to, RubyFixnum.one(context.runtime), false);
            }
        };
    }

    @JRubyMethod
    public IRubyObject downto(ThreadContext context, IRubyObject to, Block block) {
        if (block.isGiven()) {
            if (this instanceof RubyFixnum && to instanceof RubyFixnum) {
                RubyInteger.fixnumDownto(context, ((RubyFixnum)this).getLongValue(), ((RubyFixnum)to).getLongValue(), block);
            } else {
                RubyInteger.duckDownto(context, this, to, block);
            }
            return this;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, (IRubyObject)this, "downto", new IRubyObject[]{to}, RubyInteger.downToSize(context, this, to));
    }

    private static void fixnumDownto(ThreadContext context, long from, long to, Block block) {
        Ruby runtime = context.runtime;
        if (block.getSignature() == Signature.NO_ARGUMENTS) {
            long i2;
            IRubyObject nil = runtime.getNil();
            for (i2 = from; i2 > to; --i2) {
                block.yield(context, nil);
            }
            if (i2 >= to) {
                block.yield(context, nil);
            }
        } else {
            long i3;
            for (i3 = from; i3 > to; --i3) {
                block.yield(context, RubyFixnum.newFixnum(runtime, i3));
            }
            if (i3 >= to) {
                block.yield(context, RubyFixnum.newFixnum(runtime, i3));
            }
        }
    }

    private static void duckDownto(ThreadContext context, IRubyObject from, IRubyObject to, Block block) {
        Ruby runtime = context.runtime;
        IRubyObject i2 = from;
        RubyFixnum one = RubyFixnum.one(runtime);
        while (!RubyInteger.sites((ThreadContext)context).op_lt.call(context, i2, i2, to).isTrue()) {
            block.yield(context, i2);
            i2 = RubyInteger.sites((ThreadContext)context).op_minus.call(context, i2, i2, (IRubyObject)one);
        }
    }

    private static RubyEnumerator.SizeFn downToSize(final ThreadContext context, final IRubyObject from, final IRubyObject to) {
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                return RubyNumeric.intervalStepSize(context, from, to, RubyFixnum.newFixnum(context.runtime, -1L), false);
            }
        };
    }

    @JRubyMethod
    public IRubyObject times(ThreadContext context, Block block) {
        if (block.isGiven()) {
            Ruby runtime = context.runtime;
            IRubyObject i2 = RubyFixnum.zero(runtime);
            RubyFixnum one = RubyFixnum.one(runtime);
            while (RubyInteger.sites((ThreadContext)context).op_lt.call(context, i2, i2, (IRubyObject)this).isTrue()) {
                block.yield(context, i2);
                i2 = RubyInteger.sites((ThreadContext)context).op_plus.call(context, i2, i2, (IRubyObject)one);
            }
            return this;
        }
        return RubyEnumerator.enumeratorizeWithSize(context, this, "times", this.timesSizeFn(context.runtime));
    }

    protected RubyEnumerator.SizeFn timesSizeFn(final Ruby runtime) {
        final RubyInteger self2 = this;
        return new RubyEnumerator.SizeFn(){

            @Override
            public IRubyObject size(IRubyObject[] args2) {
                RubyFixnum zero = RubyFixnum.zero(runtime);
                ThreadContext context = runtime.getCurrentContext();
                if (self2 instanceof RubyFixnum && RubyInteger.this.getLongValue() < 0L || RubyInteger.sites((ThreadContext)context).op_lt.call(context, (IRubyObject)self2, (IRubyObject)self2, (IRubyObject)zero).isTrue()) {
                    return zero;
                }
                return self2;
            }
        };
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ(ThreadContext context) {
        if (this instanceof RubyFixnum) {
            return ((RubyFixnum)this).op_plus_one(context);
        }
        return RubyInteger.sites((ThreadContext)context).op_plus.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)RubyFixnum.one(context.runtime));
    }

    static ByteList singleCharByteList(byte index2) {
        return SINGLE_CHAR_BYTELISTS[index2 & 0xFF];
    }

    @JRubyMethod(name={"chr"})
    public RubyString chr(ThreadContext context) {
        Ruby runtime = context.runtime;
        long i2 = this.getLongValue() & 0xFFFFFFFFL;
        int c = (int)i2;
        if (i2 > 255L) {
            Encoding enc = runtime.getDefaultInternalEncoding();
            if (enc == null) {
                throw runtime.newRangeError(this.toString() + " out of char range");
            }
            return this.chrCommon(context, c, enc);
        }
        return RubyString.newStringShared(runtime, SINGLE_CHAR_BYTELISTS[c]);
    }

    @Deprecated
    public RubyString chr19(ThreadContext context) {
        return this.chr(context);
    }

    @JRubyMethod(name={"chr"})
    public RubyString chr(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        long i2 = this.getLongValue() & 0xFFFFFFFFL;
        Encoding enc = arg2 instanceof RubyEncoding ? ((RubyEncoding)arg2).getEncoding() : arg2.convertToString().toEncoding(runtime);
        return this.chrCommon(context, i2, enc);
    }

    @Deprecated
    public RubyString chr19(ThreadContext context, IRubyObject arg2) {
        return this.chr(context, arg2);
    }

    private RubyString chrCommon(ThreadContext context, long value2, Encoding enc) {
        if (value2 > 0xFFFFFFFFL) {
            throw context.runtime.newRangeError(this + " out of char range");
        }
        int c = (int)value2;
        if (enc == null) {
            enc = ASCIIEncoding.INSTANCE;
        }
        return EncodingUtils.encUintChr(context, c, enc);
    }

    private ByteList fromEncodedBytes(Ruby runtime, Encoding enc, long value2) {
        int n;
        try {
            n = value2 < 0L ? 0 : enc.codeToMbcLength((int)value2);
        }
        catch (EncodingException ee) {
            n = 0;
        }
        if (n <= 0) {
            throw runtime.newRangeError(this.toString() + " out of char range");
        }
        ByteList bytes2 = new ByteList(n);
        boolean ok = false;
        try {
            enc.codeToMbc((int)value2, bytes2.getUnsafeBytes(), 0);
            ok = StringSupport.preciseLength(enc, bytes2.unsafeBytes(), 0, n) == n;
        }
        catch (EncodingException encodingException) {
            // empty catch block
        }
        if (!ok) {
            throw runtime.newRangeError("invalid codepoint " + String.format("0x%x in ", value2) + enc.getCharsetName());
        }
        bytes2.setRealSize(n);
        return bytes2;
    }

    @JRubyMethod(name={"ord"})
    public IRubyObject ord(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"to_i", "to_int", "floor", "ceil", "truncate"})
    public IRubyObject to_i() {
        return this;
    }

    @Override
    public IRubyObject round() {
        return this;
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round19() {
        return this;
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round19(ThreadContext context, IRubyObject arg2) {
        CallSite op;
        long bytes2;
        int ndigits = RubyNumeric.num2int(arg2);
        if (ndigits > 0) {
            return RubyKernel.new_float(this, this);
        }
        if (ndigits == 0) {
            return this;
        }
        Ruby runtime = context.runtime;
        long l = bytes2 = this instanceof RubyFixnum ? 8L : RubyFixnum.fix2long(this.callMethod("size"));
        if (-0.415241 * (double)ndigits - 0.125 > (double)bytes2) {
            return RubyFixnum.zero(runtime);
        }
        IRubyObject f = Numeric.int_pow(context, 10L, -ndigits);
        if (this instanceof RubyFixnum && f instanceof RubyFixnum) {
            boolean neg;
            long x = ((RubyFixnum)this).getLongValue();
            long y = ((RubyFixnum)f).getLongValue();
            boolean bl = neg = x < 0L;
            if (neg) {
                x = -x;
            }
            x = (x + y / 2L) / y * y;
            if (neg) {
                x = -x;
            }
            return RubyFixnum.newFixnum(runtime, x);
        }
        if (f instanceof RubyFloat) {
            return RubyFixnum.zero(runtime);
        }
        IRubyObject h = RubyInteger.sites((ThreadContext)context).op_quo.call(context, f, f, (IRubyObject)RubyFixnum.two(runtime));
        IRubyObject r = RubyInteger.sites((ThreadContext)context).op_mod.call(context, (IRubyObject)this, (IRubyObject)this, f);
        IRubyObject n = RubyInteger.sites((ThreadContext)context).op_minus.call(context, (IRubyObject)this, (IRubyObject)this, r);
        CallSite callSite = op = RubyInteger.sites((ThreadContext)context).op_lt.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)RubyFixnum.zero(runtime)).isTrue() ? RubyInteger.sites((ThreadContext)context).op_le : RubyInteger.sites((ThreadContext)context).op_lt;
        if (!op.call(context, r, r, h).isTrue()) {
            n = RubyInteger.sites((ThreadContext)context).op_plus.call(context, n, n, f);
        }
        return n;
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        return RubyRational.newRationalCanonicalize(context, this);
    }

    @JRubyMethod(name={"rationalize"}, optional=1)
    public IRubyObject rationalize(ThreadContext context, IRubyObject[] args2) {
        return this.to_r(context);
    }

    @JRubyMethod(name={"odd?"})
    public RubyBoolean odd_p(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (RubyInteger.sites((ThreadContext)context).op_mod.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)RubyFixnum.two(runtime)) != RubyFixnum.zero(runtime)) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    @JRubyMethod(name={"even?"})
    public RubyBoolean even_p(ThreadContext context) {
        Ruby runtime = context.runtime;
        if (RubyInteger.sites((ThreadContext)context).op_mod.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)RubyFixnum.two(runtime)) == RubyFixnum.zero(runtime)) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    @JRubyMethod(name={"pred"})
    public IRubyObject pred(ThreadContext context) {
        return RubyInteger.sites((ThreadContext)context).op_minus.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)RubyFixnum.one(context.runtime));
    }

    @JRubyMethod(name={"gcd"})
    public IRubyObject gcd(ThreadContext context, IRubyObject other) {
        Numeric.checkInteger(context, other);
        return Numeric.f_gcd(context, this, RubyRational.intValue(context, other));
    }

    @JRubyMethod(name={"lcm"})
    public IRubyObject lcm(ThreadContext context, IRubyObject other) {
        Numeric.checkInteger(context, other);
        return Numeric.f_lcm(context, this, RubyRational.intValue(context, other));
    }

    @JRubyMethod(name={"gcdlcm"})
    public IRubyObject gcdlcm(ThreadContext context, IRubyObject other) {
        Numeric.checkInteger(context, other);
        other = RubyRational.intValue(context, other);
        return context.runtime.newArray(Numeric.f_gcd(context, this, other), Numeric.f_lcm(context, this, other));
    }

    @Override
    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext context) {
        return this;
    }

    @Override
    @JRubyMethod(name={"denominator"})
    public IRubyObject denominator(ThreadContext context) {
        return RubyFixnum.one(context.runtime);
    }

    private static JavaSites.IntegerSites sites(ThreadContext context) {
        return context.sites.Integer;
    }

    @Deprecated
    public static IRubyObject induced_from(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            return other;
        }
        if (other instanceof RubyFloat || other instanceof RubyRational) {
            return other.callMethod(context, "to_i");
        }
        throw recv2.getRuntime().newTypeError("failed to convert " + other.getMetaClass().getName() + " into Integer");
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            ByteList bytes2;
            RubyInteger.SINGLE_CHAR_BYTELISTS[i2] = bytes2 = new ByteList(new byte[]{(byte)i2}, false);
            bytes2.setEncoding((Encoding)(i2 < 128 ? USASCIIEncoding.INSTANCE : ASCIIEncoding.INSTANCE));
        }
        SINGLE_CHAR_BYTELISTS19 = SINGLE_CHAR_BYTELISTS;
    }
}

