/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.VirtualStack;
import ij.gui.Plot;
import ij.process.ImageProcessor;
import java.io.ByteArrayInputStream;
import java.util.Vector;

public class PlotVirtualStack
extends VirtualStack {
    private Vector plots = new Vector(50);
    private int bitDepth = 8;

    public PlotVirtualStack(int width, int height) {
        super(width, height);
    }

    public void addPlot(Plot plot) {
        this.plots.add(plot.toByteArray());
        if (plot.isColored()) {
            this.bitDepth = 24;
        }
    }

    @Override
    public Object getPixels(int n) {
        ImageProcessor ip = this.getProcessor(n);
        if (ip != null) {
            return ip.getPixels();
        }
        return null;
    }

    @Override
    public ImageProcessor getProcessor(int n) {
        byte[] bytes = (byte[])this.plots.get(n - 1);
        if (bytes != null) {
            try {
                Plot plot = new Plot(null, new ByteArrayInputStream(bytes));
                ImageProcessor ip = plot.getProcessor();
                if (this.bitDepth == 24) {
                    ip = ip.convertToRGB();
                } else if (this.bitDepth == 8) {
                    ip = ip.convertToByte(false);
                }
                ip.setSliceNumber(n);
                return ip;
            }
            catch (Exception e) {
                IJ.handleException(e);
            }
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.plots.size();
    }

    @Override
    public int getBitDepth() {
        return this.bitDepth;
    }

    @Override
    public void setBitDepth(int bitDepth) {
        this.bitDepth = bitDepth;
    }

    @Override
    public String getSliceLabel(int n) {
        return null;
    }

    @Override
    public void setPixels(Object pixels, int n) {
    }

    @Override
    public void deleteSlice(int n) {
        if (n < 1 || n > this.plots.size()) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.plots.size() < 1) {
            return;
        }
        this.plots.remove(n - 1);
    }
}

