/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImageJ;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class ProgressBar
extends Canvas {
    public static final int WIDTH = 120;
    public static final int HEIGHT = 20;
    private int canvasWidth;
    private int canvasHeight;
    private int x;
    private int y;
    private int width;
    private int height;
    private long lastTime = 0L;
    private boolean showBar;
    private boolean batchMode;
    private Color barColor = Color.gray;
    private Color fillColor = new Color(204, 204, 255);
    private Color backgroundColor = ImageJ.backgroundColor;
    private Color frameBrighter = this.backgroundColor.brighter();
    private Color frameDarker = this.backgroundColor.darker();
    private boolean dualDisplay = false;
    private double slowX = 0.0;
    private double fastX = 0.0;

    public ProgressBar(int canvasWidth, int canvasHeight) {
        this.init(canvasWidth, canvasHeight);
    }

    public void init(int canvasWidth, int canvasHeight) {
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.x = 3;
        this.y = 5;
        this.width = canvasWidth - 8;
        this.height = canvasHeight - 7;
    }

    void fill3DRect(Graphics g, int x, int y, int width, int height) {
        g.setColor(this.fillColor);
        g.fillRect(x + 1, y + 1, width - 2, height - 2);
        g.setColor(this.frameDarker);
        g.drawLine(x, y, x, y + height);
        g.drawLine(x + 1, y, x + width - 1, y);
        g.setColor(this.frameBrighter);
        g.drawLine(x + 1, y + height, x + width, y + height);
        g.drawLine(x + width, y, x + width, y + height - 1);
    }

    public void show(double progress) {
        this.show(progress, false);
    }

    public void show(double progress, boolean showInBatchMode) {
        boolean finished = false;
        if (progress <= -1.0) {
            finished = true;
        }
        if (!this.dualDisplay && progress >= 1.0) {
            finished = true;
        }
        if (!finished) {
            if (progress < 0.0) {
                this.slowX = -progress;
                this.fastX = 0.0;
                this.dualDisplay = true;
            } else if (this.dualDisplay) {
                this.fastX = progress;
            }
            if (!this.dualDisplay) {
                this.slowX = progress;
            }
        }
        if (!showInBatchMode && (this.batchMode || Interpreter.isBatchMode())) {
            return;
        }
        if (finished) {
            this.slowX = 0.0;
            this.fastX = 0.0;
            this.showBar = false;
            this.dualDisplay = false;
            this.repaint();
            return;
        }
        long time = System.currentTimeMillis();
        if (time - this.lastTime < 90L && progress != 1.0) {
            return;
        }
        this.lastTime = time;
        this.showBar = true;
        this.repaint();
    }

    public void show(int currentIndex, int finalIndex) {
        boolean wasNegative = currentIndex < 0;
        double progress = ((double)Math.abs(currentIndex) + 1.0) / (double)Math.abs(finalIndex);
        if (wasNegative) {
            progress = -progress;
        }
        if (finalIndex == 0) {
            progress = -1.0;
        }
        this.show(progress);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.showBar) {
            this.fill3DRect(g, this.x - 1, this.y - 1, this.width + 1, this.height + 1);
            this.drawBar(g);
        } else {
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        }
    }

    void drawBar(Graphics g) {
        int barEnd = (int)((double)this.width * this.slowX);
        if (Toolbar.getToolId() == 14) {
            g.setColor(Color.getHSBColor((float)(System.currentTimeMillis() % 1000L) / 1000.0f, 0.5f, 1.0f));
        } else {
            g.setColor(this.barColor);
        }
        g.fillRect(this.x, this.y, barEnd, this.height);
        if (this.dualDisplay && this.fastX > 0.0) {
            int dotPos = (int)((double)this.width * this.fastX);
            g.setColor(Color.BLACK);
            if (dotPos > 1 && dotPos < this.width - 7) {
                g.fillOval(dotPos, this.y + 3, 7, 7);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.canvasWidth, this.canvasHeight);
    }

    public void setBatchMode(boolean batchMode) {
        this.batchMode = batchMode;
    }
}

