/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.fft;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.fft.FourierTransform;
import mpicbg.imglib.algorithm.fft.InverseFourierTransform;
import mpicbg.imglib.algorithm.gauss.GaussianConvolution;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.complex.ComplexFloatType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;

public class FourierConvolution<T extends RealType<T>, S extends RealType<S>>
implements MultiThreaded,
OutputAlgorithm<T>,
Benchmark {
    final int numDimensions;
    Image<T> image;
    Image<T> convolved;
    Image<S> kernel;
    Image<ComplexFloatType> kernelFFT;
    Image<ComplexFloatType> imgFFT;
    FourierTransform<T, ComplexFloatType> fftImage;
    boolean keepImgFFT = true;
    boolean extendImgByKernelSize = true;
    OutOfBoundsStrategyFactory<T> strategy = new OutOfBoundsStrategyMirrorFactory();
    final int[] kernelDim;
    String errorMessage = "";
    int numThreads;
    long processingTime;

    public FourierConvolution(Image<T> image, Image<S> kernel) {
        this.numDimensions = image.getNumDimensions();
        this.image = image;
        this.kernel = kernel;
        this.kernelDim = kernel.getDimensions();
        this.kernelFFT = null;
        this.imgFFT = null;
        this.setNumThreads();
    }

    public Image<T> getImage() {
        return this.image;
    }

    public Image<S> getKernel() {
        return this.kernel;
    }

    public void setImageOutOfBoundsStrategy(OutOfBoundsStrategyFactory<T> strategy) {
        this.strategy = strategy;
    }

    public OutOfBoundsStrategyFactory<T> getImageOutOfBoundsStrategy() {
        return this.strategy;
    }

    public boolean replaceImage(Image<T> img) {
        if (!img.getContainer().compareStorageContainerCompatibility(this.image.getContainer())) {
            this.errorMessage = "Image containers are not comparable, cannot exchange image";
            return false;
        }
        this.image = img;
        this.imgFFT = null;
        return true;
    }

    public void setExtendImageByKernelSize(boolean extend) {
        this.extendImgByKernelSize = extend;
    }

    public boolean getExtendImageByKernelSize() {
        return this.extendImgByKernelSize;
    }

    public void setKeepImgFFT(boolean keepImgFFT) {
        this.keepImgFFT = keepImgFFT;
    }

    public boolean getKeepImgFFT() {
        return this.keepImgFFT;
    }

    public boolean replaceKernel(Image<S> knl) {
        if (!knl.getContainer().compareStorageContainerCompatibility(this.kernel.getContainer())) {
            this.errorMessage = "Kernel containers are not comparable, cannot exchange image";
            return false;
        }
        this.kernel = knl;
        this.kernelFFT = null;
        return true;
    }

    public static final Image<FloatType> createGaussianKernel(ContainerFactory factory, double sigma, int numDimensions) {
        double[] sigmas = new double[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            sigmas[d] = sigma;
        }
        return FourierConvolution.createGaussianKernel(factory, sigmas);
    }

    public static final Image<FloatType> createGaussianKernel(ContainerFactory factory, double[] sigmas) {
        int numDimensions = sigmas.length;
        int[] imageSize = new int[numDimensions];
        double[][] kernel = new double[numDimensions][];
        for (int d = 0; d < numDimensions; ++d) {
            kernel[d] = Util.createGaussianKernel1DDouble(sigmas[d], true);
            imageSize[d] = kernel[d].length;
        }
        Image<FloatType> kernelImg = new ImageFactory<FloatType>(new FloatType(), factory).createImage(imageSize);
        LocalizableByDimCursor<FloatType> cursor = kernelImg.createLocalizableByDimCursor();
        int[] position = new int[numDimensions];
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.getPosition(position);
            double value = 1.0;
            for (int d = 0; d < numDimensions; ++d) {
                value *= kernel[d][position[d]];
            }
            ((FloatType)cursor.getType()).set((float)value);
        }
        cursor.close();
        return kernelImg;
    }

    public static final Image<FloatType> createGaussianKernel(ContainerFactory factory, double[] sigmas, int precision) {
        int numDimensions = sigmas.length;
        int[] imageSize = new int[numDimensions];
        double[][] kernel = new double[numDimensions][];
        for (int d = 0; d < numDimensions; ++d) {
            kernel[d] = Util.createGaussianKernel1DDouble(sigmas[d], true, precision);
            imageSize[d] = kernel[d].length;
        }
        Image<FloatType> kernelImg = new ImageFactory<FloatType>(new FloatType(), factory).createImage(imageSize);
        LocalizableByDimCursor<FloatType> cursor = kernelImg.createLocalizableByDimCursor();
        int[] position = new int[numDimensions];
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.getPosition(position);
            double value = 1.0;
            for (int d = 0; d < numDimensions; ++d) {
                value *= kernel[d][position[d]];
            }
            ((FloatType)cursor.getType()).set((float)value);
        }
        cursor.close();
        return kernelImg;
    }

    public static final <T extends RealType<T>> Image<T> getGaussianKernel(ImageFactory<T> imgFactory, double sigma, int numDimensions) {
        double[] sigmas = new double[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            sigmas[d] = sigma;
        }
        return FourierConvolution.getGaussianKernel(imgFactory, sigmas);
    }

    public static final <T extends RealType<T>> Image<T> getGaussianKernel(ImageFactory<T> imgFactory, double[] sigma) {
        int numDimensions = sigma.length;
        int[] imgSize = new int[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            imgSize[d] = Util.getSuggestedKernelDiameter(sigma[d]);
        }
        Image<T> kernel = imgFactory.createImage(imgSize);
        int[] center = new int[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            center[d] = kernel.getDimension(d) / 2;
        }
        LocalizableByDimCursor<T> c = kernel.createLocalizableByDimCursor();
        c.setPosition(center);
        ((RealType)c.getType()).setOne();
        c.close();
        GaussianConvolution<T> gauss = new GaussianConvolution<T>(kernel, new OutOfBoundsStrategyValueFactory(), sigma);
        if (!gauss.checkInput() || !gauss.process()) {
            System.out.println("Gaussian Convolution failed: " + gauss.getErrorMessage());
            return null;
        }
        kernel.close();
        return gauss.getResult();
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        if (this.imgFFT == null) {
            this.fftImage = new FourierTransform<T, ComplexFloatType>(this.image, new ComplexFloatType());
            this.fftImage.setNumThreads(this.getNumThreads());
            this.fftImage.setRearrangement(FourierTransform.Rearrangement.UNCHANGED);
            if (this.extendImgByKernelSize) {
                this.fftImage.setPreProcessing(FourierTransform.PreProcessing.USE_GIVEN_OUTOFBOUNDSSTRATEGY);
                this.fftImage.setCustomOutOfBoundsStrategy(this.strategy);
                int[] imageExtension = (int[])this.kernelDim.clone();
                int d = 0;
                while (d < this.numDimensions) {
                    int n = d++;
                    imageExtension[n] = imageExtension[n] - 1;
                }
                this.fftImage.setImageExtension(imageExtension);
            }
            if (!this.fftImage.checkInput() || !this.fftImage.process()) {
                this.errorMessage = "FFT of image failed: " + this.fftImage.getErrorMessage();
                return false;
            }
            this.imgFFT = this.fftImage.getResult();
        }
        if (this.kernelFFT == null) {
            int[] kernelTemplateDim = this.imgFFT.getDimensions();
            kernelTemplateDim[0] = (this.imgFFT.getDimension(0) - 1) * 2;
            ImageFactory<S> kernelTemplateFactory = new ImageFactory<S>(this.kernel.createType(), this.image.getContainer().getFactory());
            Image<S> kernelTemplate = kernelTemplateFactory.createImage(kernelTemplateDim);
            LocalizableCursor<S> kernelCursor = this.kernel.createLocalizableCursor();
            LocalizableByDimCursor<S> kernelTemplateCursor = kernelTemplate.createLocalizableByDimCursor();
            int[] position = new int[this.numDimensions];
            while (kernelCursor.hasNext()) {
                kernelCursor.next();
                kernelCursor.getPosition(position);
                for (int d = 0; d < this.numDimensions; ++d) {
                    position[d] = (position[d] - this.kernelDim[d] / 2 + kernelTemplateDim[d]) % kernelTemplateDim[d];
                }
                kernelTemplateCursor.setPosition(position);
                ((RealType)kernelTemplateCursor.getType()).set(kernelCursor.getType());
            }
            FourierTransform<S, ComplexFloatType> fftKernel = new FourierTransform<S, ComplexFloatType>(kernelTemplate, new ComplexFloatType());
            fftKernel.setNumThreads(this.getNumThreads());
            fftKernel.setPreProcessing(FourierTransform.PreProcessing.NONE);
            fftKernel.setRearrangement(this.fftImage.getRearrangement());
            if (!fftKernel.checkInput() || !fftKernel.process()) {
                this.errorMessage = "FFT of kernel failed: " + fftKernel.getErrorMessage();
                return false;
            }
            kernelTemplate.close();
            this.kernelFFT = fftKernel.getResult();
        }
        Object copy = this.keepImgFFT ? this.imgFFT.clone() : this.imgFFT;
        long numPixels = ((Image)copy).getDimension(0);
        for (int d = 1; d < ((Image)copy).getNumDimensions(); ++d) {
            numPixels *= (long)((Image)copy).getDimension(d);
        }
        final Vector<Chunk> threadChunks = SimpleMultiThreading.divideIntoChunks(numPixels, this.getNumThreads());
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(this.numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable((Image)copy){
                final /* synthetic */ Image val$copy;
                {
                    this.val$copy = image;
                }

                @Override
                public void run() {
                    Chunk myChunk = (Chunk)threadChunks.get(ai.getAndIncrement());
                    FourierConvolution.multiply(myChunk.getStartPosition(), myChunk.getLoopSize(), this.val$copy, FourierConvolution.this.kernelFFT);
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        InverseFourierTransform invFFT = new InverseFourierTransform(copy, this.fftImage);
        invFFT.setInPlaceTransform(true);
        invFFT.setNumThreads(this.getNumThreads());
        if (!invFFT.checkInput() || !invFFT.process()) {
            this.errorMessage = "InverseFFT of image failed: " + invFFT.getErrorMessage();
            return false;
        }
        if (!this.keepImgFFT) {
            this.imgFFT.close();
            this.imgFFT = null;
        }
        this.convolved = invFFT.getResult();
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    protected void multiply(Image<ComplexFloatType> a, Image<ComplexFloatType> b) {
        Cursor<ComplexFloatType> cursorA = a.createCursor();
        Cursor<ComplexFloatType> cursorB = b.createCursor();
        while (cursorA.hasNext()) {
            cursorA.fwd();
            cursorB.fwd();
            cursorA.getType().mul(cursorB.getType());
        }
        cursorA.close();
        cursorB.close();
    }

    private static final void multiply(long start, long loopSize, Image<ComplexFloatType> a, Image<ComplexFloatType> b) {
        Cursor<ComplexFloatType> cursorA = a.createCursor();
        Cursor<ComplexFloatType> cursorB = b.createCursor();
        cursorA.fwd(start);
        cursorB.fwd(start);
        for (long l = 0L; l < loopSize; ++l) {
            cursorA.fwd();
            cursorB.fwd();
            cursorA.getType().mul(cursorB.getType());
        }
        cursorA.close();
        cursorB.close();
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public Image<T> getResult() {
        return this.convolved;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "Input image is null";
            return false;
        }
        if (this.kernel == null) {
            this.errorMessage = "Kernel image is null";
            return false;
        }
        for (int d = 0; d < this.numDimensions; ++d) {
            if (this.kernel.getDimension(d) % 2 == 1) continue;
            this.errorMessage = "Kernel image has NO odd dimensionality in dim " + d + " (" + this.kernel.getDimension(d) + ")";
            return false;
        }
        return true;
    }

    public void close() {
        this.kernelFFT.close();
        this.image = null;
        this.convolved = null;
        this.kernel = null;
        this.kernelFFT = null;
        if (this.imgFFT != null) {
            this.imgFFT.close();
        }
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

