/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.labeling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.fft.FourierConvolution;
import mpicbg.imglib.algorithm.labeling.AllConnectedComponents;
import mpicbg.imglib.algorithm.labeling.Watershed;
import mpicbg.imglib.algorithm.math.ComputeMinMax;
import mpicbg.imglib.algorithm.math.ImageConverter;
import mpicbg.imglib.algorithm.math.PickImagePeaks;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.function.RealTypeConverter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.labeling.Labeling;
import mpicbg.imglib.labeling.LabelingType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;

public class GradientWatershed<T extends RealType<T>, L extends Comparable<L>>
implements OutputAlgorithm<LabelingType<L>> {
    protected Image<T> input;
    protected Labeling<L> output;
    protected double[] scale;
    protected double[] sigma1;
    protected double[] sigma2;
    protected Iterator<L> names;
    protected double minBackgroundPeakHeight = 0.0;
    protected double minForegroundPeakHeight = 0.0;
    protected boolean wantsToQuantize = true;
    protected int numQuanta = 100;
    protected int[][] structuringElement;
    protected String error_message;
    protected ImageFactory<LabelingType<L>> labelingFactory;
    protected Image<FloatType> floatImage;
    protected ImageFactory<FloatType> floatFactory;

    public GradientWatershed(Image<T> input, double[] scale, double[] sigma1, double[] sigma2, Iterator<L> names) {
        this.input = input;
        this.scale = scale;
        this.sigma1 = sigma1;
        this.sigma2 = sigma2;
        this.structuringElement = AllConnectedComponents.getStructuringElement(input.getNumDimensions());
        this.names = names;
        this.labelingFactory = new ImageFactory(new LabelingType(), input.getContainerFactory());
    }

    public int[][] getStructuringElement() {
        return GradientWatershed.cloneStructuringElement(this.structuringElement);
    }

    protected static int[][] cloneStructuringElement(int[][] structuringElement) {
        int[][] result = (int[][])structuringElement.clone();
        for (int i = 0; i < result.length; ++i) {
            result[i] = (int[])result[i].clone();
        }
        return result;
    }

    public void setStructuringElement(int[][] structuringElement) {
        this.structuringElement = GradientWatershed.cloneStructuringElement(structuringElement);
    }

    public double[] getScale() {
        return (double[])this.scale.clone();
    }

    public void setScale(double[] scale) {
        this.scale = (double[])scale.clone();
    }

    public void setMinBackgroundPeakHeight(double height) {
        this.minBackgroundPeakHeight = height;
    }

    public double getMinBackgroundPeakHeight() {
        return this.minBackgroundPeakHeight;
    }

    public void setMinForegroundPeakHeight(double height) {
        this.minForegroundPeakHeight = height;
    }

    public double getMinForegroundPeakHeight() {
        return this.minForegroundPeakHeight;
    }

    public void enableQuantization(boolean enable) {
        this.wantsToQuantize = enable;
    }

    public boolean isQuantized() {
        return this.wantsToQuantize;
    }

    public void setNumQuanta(int numQuanta) {
        this.numQuanta = numQuanta;
    }

    public void setOutputImageFactory(ImageFactory<LabelingType<L>> factory) {
        this.labelingFactory = factory;
    }

    public ImageFactory<LabelingType<L>> getOutputImageFactory() {
        return this.labelingFactory;
    }

    public void setOutputLabeling(Labeling<L> labeling) {
        this.output = labeling;
    }

    public int getNumQuanta() {
        return this.numQuanta;
    }

    @Override
    public boolean checkInput() {
        if (this.error_message.length() > 0) {
            return false;
        }
        if (this.input == null) {
            this.error_message = "The input image is null.";
            return false;
        }
        if (this.scale == null) {
            this.error_message = "The scale is null.";
            return false;
        }
        if (this.sigma1 == null) {
            this.error_message = "The first smoothing standard deviation (sigma1) is null.";
            return false;
        }
        if (this.sigma2 == null) {
            this.error_message = "The second smoothing standard deviation (sigma2) is null.";
            return false;
        }
        if (this.structuringElement == null) {
            this.error_message = "The structuring element is null.";
            return false;
        }
        if (this.names == null) {
            this.error_message = "The names iterator is null.";
        }
        if (!this.checkDimensions(this.scale)) {
            this.error_message = "The dimensions of the scale do not match those of the image";
            return false;
        }
        if (!this.checkDimensions(this.sigma1)) {
            this.error_message = "The dimensions of sigma1 do not match those of the image";
            return false;
        }
        if (!this.checkDimensions(this.sigma2)) {
            this.error_message = "The dimensions of sigma2 do not match those of the image";
            return false;
        }
        for (int[] coord : this.structuringElement) {
            if (coord == null) {
                this.error_message = "One of the coordinates of the structuring element is null.";
                return false;
            }
            if (this.checkDimensions(coord)) continue;
            this.error_message = "The dimensions of one of the coordinates of the structuring element does not match those of the image.";
            return false;
        }
        if (this.wantsToQuantize && this.numQuanta < 2) {
            this.error_message = String.format("The number of quanta is %d, but must be at least 2 (and ideally > 20).", this.numQuanta);
            return false;
        }
        for (int i = 0; i < this.sigma1.length; ++i) {
            if (!(this.sigma1[i] <= this.sigma2[i])) continue;
            this.error_message = String.format("All values of sigma1 should be greater than sigma2. For dimension %d, sigma1=%f, sigma2=%f", i, this.sigma1[i], this.sigma2[i]);
            return false;
        }
        if (this.output != null) {
            int[] dimensions = this.output.getDimensions();
            if (!this.checkDimensions(dimensions)) {
                this.error_message = "The labeling container does not have the correct number of dimensions";
                return false;
            }
            for (int i = 0; i < dimensions.length; ++i) {
                if (dimensions[i] == this.input.getDimension(i)) continue;
                this.error_message = String.format("The labeling container is not the same size as the image: dimension %d, labeling = %d, image = %d", i, dimensions[i], this.input.getDimension(i));
                return false;
            }
        }
        return true;
    }

    protected boolean checkDimensions(int[] array) {
        return array.length == this.input.getNumDimensions();
    }

    protected boolean checkDimensions(double[] array) {
        return array.length == this.input.getNumDimensions();
    }

    @Override
    public boolean process() {
        this.floatImage = null;
        if (this.output == null) {
            this.output = new Labeling(this.labelingFactory, this.input.getDimensions(), null);
        } else {
            LocalizableCursor c = this.output.createLocalizableCursor();
            List background = ((LabelingType)c.getType()).intern(new ArrayList());
            for (LabelingType t : c) {
                t.setLabeling(background);
            }
            c.close();
        }
        Image<FloatType> kernel = FourierConvolution.createGaussianKernel(this.input.getContainerFactory(), this.scale);
        FourierConvolution<FloatType, FloatType> convolution = new FourierConvolution<FloatType, FloatType>(this.getFloatImage(), kernel);
        if (!convolution.process()) {
            return false;
        }
        Image<FloatType> smoothed = convolution.getResult();
        PickImagePeaks<FloatType> peakPicker = new PickImagePeaks<FloatType>(smoothed);
        peakPicker.setSuppression(this.scale);
        peakPicker.process();
        Labeling<L> seeds = this.output.createNewLabeling();
        LocalizableByDimCursor lc = seeds.createLocalizableByDimCursor();
        LocalizableByDimCursor<FloatType> imageCursor = smoothed.createLocalizableByDimCursor();
        int[] dimensions = this.input.getDimensions();
        for (int[] peak : peakPicker.getPeakList()) {
            if (!this.filterPeak(imageCursor, peak, dimensions, false)) continue;
            lc.setPosition(peak);
            ((LabelingType)lc.getType()).setLabel((Comparable)this.names.next());
        }
        imageCursor.close();
        List<Comparable> background = ((LabelingType)lc.getType()).intern((Comparable)this.names.next());
        Converter<FloatType, FloatType> invert = new Converter<FloatType, FloatType>(){

            @Override
            public void convert(FloatType input, FloatType output) {
                output.setReal(-input.getRealFloat());
            }
        };
        ImageConverter<FloatType, FloatType> invSmoothed = new ImageConverter<FloatType, FloatType>(smoothed, smoothed, invert);
        invSmoothed.process();
        peakPicker = new PickImagePeaks<FloatType>(smoothed);
        peakPicker.setSuppression(this.scale);
        peakPicker.process();
        imageCursor = smoothed.createLocalizableByDimCursor();
        for (int[] peak : peakPicker.getPeakList()) {
            if (!this.filterPeak(imageCursor, peak, dimensions, true)) continue;
            lc.setPosition(peak);
            ((LabelingType)lc.getType()).setLabeling(background);
        }
        lc.close();
        imageCursor.close();
        smoothed = null;
        invSmoothed = null;
        Image<FloatType> gradientImage = this.getGradientImage();
        if (gradientImage == null) {
            return false;
        }
        Watershed.seededWatershed(gradientImage, seeds, this.structuringElement, this.output);
        return true;
    }

    protected ImageFactory<FloatType> getFloatFactory() {
        if (this.floatFactory == null) {
            this.floatFactory = new ImageFactory<FloatType>(new FloatType(), this.input.getContainerFactory());
        }
        return this.floatFactory;
    }

    protected Image<FloatType> getFloatImage() {
        if (this.floatImage == null) {
            ImageConverter<FloatType, FloatType> convertToFloat = new ImageConverter<FloatType, FloatType>(this.input, this.getFloatFactory(), new RealTypeConverter());
            if (!convertToFloat.process()) {
                return null;
            }
            this.floatImage = convertToFloat.getResult();
        }
        return this.floatImage;
    }

    @Override
    public String getErrorMessage() {
        return this.error_message;
    }

    @Override
    public Image<LabelingType<L>> getResult() {
        return this.output;
    }

    protected boolean filterPeak(LocalizableByDimCursor<FloatType> imageCursor, int[] peak, int[] dimensions, boolean find_minimum) {
        double limit = this.minForegroundPeakHeight;
        if (find_minimum) {
            limit = this.minBackgroundPeakHeight;
        }
        int[] offset = new int[peak.length];
        int[] size = new int[peak.length];
        int[] position = new int[peak.length];
        for (int i = 0; i < this.scale.length; ++i) {
            int iscale = (int)(this.scale[i] / 2.0) * 2 + 1;
            offset[i] = peak[i] - iscale / 2;
            size[i] = iscale;
            if (offset[i] < 0) {
                int n = i;
                size[n] = size[n] + offset[i];
                offset[i] = 0;
            }
            if (offset[i] + size[i] < dimensions[i]) continue;
            size[i] = dimensions[i] - offset[i] - 1;
        }
        imageCursor.setPosition(peak);
        float valueAtPeak = ((FloatType)imageCursor.getType()).get();
        RegionOfInterestCursor<FloatType> rc = new RegionOfInterestCursor<FloatType>(imageCursor, offset, size);
        for (FloatType t : rc) {
            double distanceSquared = 0.0;
            rc.getPosition(position);
            for (int i = 0; i < position.length; ++i) {
                double dPosition = (double)(position[i] + offset[i] - peak[i]) / this.scale[i];
                distanceSquared += dPosition * dPosition;
            }
            if (!(distanceSquared <= 1.0) || !(find_minimum ? (double)rc.getType().get() > (double)valueAtPeak + limit : (double)rc.getType().get() < (double)valueAtPeak - limit)) continue;
            return true;
        }
        System.err.format("Filtered at %d, %d\n", peak[0], peak[1]);
        rc.close();
        return false;
    }

    public Image<FloatType> getGradientImage() {
        double[][] kernels1d1 = new double[this.input.getNumDimensions()][];
        double[][] kernels1d2 = new double[this.input.getNumDimensions()][];
        int[] kernelDimensions = this.input.createPositionArray();
        int[] offset = this.input.createPositionArray();
        for (int i = 0; i < kernels1d1.length; ++i) {
            kernels1d1[i] = Util.createGaussianKernel1DDouble(this.sigma1[i], true);
            kernels1d2[i] = Util.createGaussianKernel1DDouble(this.sigma2[i], true);
            kernelDimensions[i] = kernels1d1[i].length;
            offset[i] = (kernels1d1[i].length - kernels1d2[i].length) / 2;
        }
        Image<FloatType> kernel = this.getFloatFactory().createImage(kernelDimensions);
        LocalizableCursor<FloatType> kc = kernel.createLocalizableCursor();
        int[] position = this.input.createPositionArray();
        for (FloatType t : kc) {
            kc.getPosition(position);
            double value1 = 1.0;
            double value2 = 1.0;
            for (int i = 0; i < kernels1d1.length; ++i) {
                value1 *= kernels1d1[i][position[i]];
                int position2 = position[i] - offset[i];
                if (position2 >= 0 && position2 < kernels1d2[i].length) {
                    value2 *= kernels1d2[i][position2];
                    continue;
                }
                value2 = 0.0;
            }
            t.setReal(value1 - value2);
        }
        kc.close();
        FourierConvolution<FloatType, FloatType> convolution = new FourierConvolution<FloatType, FloatType>(this.getFloatImage(), kernel);
        if (!convolution.process()) {
            return null;
        }
        Image<FloatType> result = convolution.getResult();
        ComputeMinMax<FloatType> computeMinMax = new ComputeMinMax<FloatType>(result);
        computeMinMax.process();
        final float min = computeMinMax.getMin().get();
        final float max = computeMinMax.getMax().get();
        if (max == min) {
            return result;
        }
        ImageConverter<FloatType, FloatType> quantizer = new ImageConverter<FloatType, FloatType>(result, result.getImageFactory(), new Converter<FloatType, FloatType>(){

            @Override
            public void convert(FloatType input, FloatType output) {
                float value = (input.get() - min) / (max - min);
                value = Math.round(value * 100.0f);
                output.set(value);
            }
        });
        quantizer.process();
        return quantizer.getResult();
    }
}

