/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.outofbounds;

import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategy;
import mpicbg.imglib.type.Type;

public class OutOfBoundsStrategyMirror<T extends Type<T>>
extends OutOfBoundsStrategy<T> {
    final LocalizableCursor<T> parentCursor;
    final LocalizableByDimCursor<T> mirrorCursor;
    final T type;
    final T mirrorType;
    final int numDimensions;
    final int[] dimension;
    final int[] position;
    final int[] mirroredPosition;
    final int[] currentDirection;
    final int[] tmp;

    public OutOfBoundsStrategyMirror(LocalizableCursor<T> parentCursor) {
        super(parentCursor);
        this.parentCursor = parentCursor;
        this.mirrorCursor = parentCursor.getImage().createLocalizableByDimCursor();
        this.mirrorType = this.mirrorCursor.getType();
        this.type = this.mirrorType.createVariable();
        this.numDimensions = parentCursor.getImage().getNumDimensions();
        this.dimension = parentCursor.getImage().getDimensions();
        this.position = new int[this.numDimensions];
        this.mirroredPosition = new int[this.numDimensions];
        this.currentDirection = new int[this.numDimensions];
        this.tmp = new int[this.numDimensions];
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public final void notifyOutOfBOunds() {
        int d;
        this.parentCursor.getPosition(this.position);
        this.getMirrorCoordinate(this.position, this.mirroredPosition);
        this.mirrorCursor.setPosition(this.mirroredPosition);
        this.type.set(this.mirrorType);
        for (d = 0; d < this.numDimensions; ++d) {
            this.tmp[d] = this.position[d] + 1;
        }
        this.getMirrorCoordinate(this.tmp, this.currentDirection);
        for (d = 0; d < this.numDimensions; ++d) {
            this.currentDirection[d] = this.currentDirection[d] - this.mirroredPosition[d];
        }
    }

    @Override
    public void notifyOutOfBOunds(int steps, int dim) {
        if (Math.abs(steps) > 10) {
            this.notifyOutOfBOunds();
        } else if (steps > 0) {
            for (int i = 0; i < steps; ++i) {
                this.notifyOutOfBOundsFwd(dim);
            }
        } else {
            for (int i = 0; i < -steps; ++i) {
                this.notifyOutOfBOundsBck(dim);
            }
        }
    }

    @Override
    public void notifyOutOfBOundsFwd(int dim) {
        if (this.currentDirection[dim] == 1) {
            if (this.mirrorCursor.getPosition(dim) + 1 == this.dimension[dim]) {
                this.mirrorCursor.bck(dim);
                this.currentDirection[dim] = -1;
            } else {
                this.mirrorCursor.fwd(dim);
            }
        } else if (this.mirrorCursor.getPosition(dim) == 0) {
            this.currentDirection[dim] = 1;
            this.mirrorCursor.fwd(dim);
        } else {
            this.mirrorCursor.bck(dim);
        }
        this.type.set(this.mirrorType);
    }

    @Override
    public void notifyOutOfBOundsBck(int dim) {
        if (this.currentDirection[dim] == 1) {
            if (this.mirrorCursor.getPosition(dim) == 0) {
                this.mirrorCursor.fwd(dim);
                this.currentDirection[dim] = -1;
            } else {
                this.mirrorCursor.bck(dim);
            }
        } else if (this.mirrorCursor.getPosition(dim) + 1 == this.dimension[dim]) {
            this.mirrorCursor.bck(dim);
            this.currentDirection[dim] = 1;
        } else {
            this.mirrorCursor.fwd(dim);
        }
        this.type.set(this.mirrorType);
    }

    @Override
    public void initOutOfBOunds() {
        this.notifyOutOfBOunds();
    }

    protected void getMirrorCoordinate(int[] position, int[] mirroredPosition) {
        for (int d = 0; d < this.numDimensions; ++d) {
            mirroredPosition[d] = position[d];
            if (mirroredPosition[d] >= this.dimension[d]) {
                mirroredPosition[d] = this.dimension[d] - (mirroredPosition[d] - this.dimension[d] + 2);
            }
            if (mirroredPosition[d] >= 0) continue;
            int tmp = 0;
            int dir = 1;
            while (mirroredPosition[d] < 0) {
                if ((tmp += dir) == this.dimension[d] - 1 || tmp == 0) {
                    dir *= -1;
                }
                int n = d;
                mirroredPosition[n] = mirroredPosition[n] + 1;
            }
            mirroredPosition[d] = tmp;
        }
    }

    @Override
    public void close() {
        this.mirrorCursor.close();
    }
}

