/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import mpicbg.imglib.algorithm.fft.FourierTransform;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.complex.ComplexDoubleType;
import script.imglib.math.Compute;
import script.imglib.math.fn.IFunction;

public class FFT<T extends RealType<T>>
extends Image<ComplexDoubleType> {
    private static Map<Thread, FourierTransform<?, ComplexDoubleType>> m = Collections.synchronizedMap(new HashMap());
    final FourierTransform<T, ComplexDoubleType> fft = m.remove(Thread.currentThread());
    final T value;

    public FFT(Image<T> img) throws Exception {
        super(FFT.process(img).getContainer(), new ComplexDoubleType(), "FFT");
        this.value = (RealType)img.createType();
    }

    public FFT(IFunction fn) throws Exception {
        this(Compute.inDoubles(fn));
    }

    private static final synchronized <T extends RealType<T>> Image<ComplexDoubleType> process(Image<T> img) throws Exception {
        FourierTransform<T, ComplexDoubleType> fft = new FourierTransform<T, ComplexDoubleType>(img, new ComplexDoubleType());
        if (!fft.checkInput() || !fft.process()) {
            throw new Exception("FFT: failed to process for image " + img.getClass() + " -- " + fft.getErrorMessage());
        }
        m.put(Thread.currentThread(), fft);
        return fft.getResult();
    }
}

