/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.math.fn;

import java.util.Collection;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.IntType;
import mpicbg.imglib.type.numeric.integer.LongType;
import mpicbg.imglib.type.numeric.integer.ShortType;
import mpicbg.imglib.type.numeric.integer.UnsignedByteType;
import mpicbg.imglib.type.numeric.real.DoubleType;
import mpicbg.imglib.type.numeric.real.FloatType;
import script.imglib.math.fn.IFunction;

public final class NumberFunction
implements IFunction {
    private final double val;

    public NumberFunction(Number num) {
        this.val = NumberFunction.asType(num).getRealDouble();
    }

    public NumberFunction(double val) {
        this.val = val;
    }

    @Override
    public final double eval() {
        return this.val;
    }

    private static final RealType<?> asType(Number val) {
        Class<?> c = val.getClass();
        if (c == Double.class) {
            return new DoubleType(val.doubleValue());
        }
        if (c == Long.class) {
            return new LongType(val.longValue());
        }
        if (c == Float.class) {
            return new FloatType(val.floatValue());
        }
        if (c == Byte.class) {
            return new UnsignedByteType((int)val.byteValue());
        }
        if (c == Integer.class) {
            return new IntType(val.intValue());
        }
        if (c == Short.class) {
            return new ShortType(val.shortValue());
        }
        return new DoubleType(val.doubleValue());
    }

    @Override
    public final void findCursors(Collection<Cursor<?>> cursors) {
    }

    @Override
    public IFunction duplicate() {
        return new NumberFunction(this.val);
    }
}

