/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.basictypeaccess.nio;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.imglib2.img.basictypeaccess.array.AbstractFloatArray;
import net.imglib2.img.basictypeaccess.nio.AbstractBufferAccess;
import net.imglib2.img.basictypeaccess.volatiles.VolatileFloatAccess;

public class FloatBufferAccess
extends AbstractBufferAccess<FloatBufferAccess, FloatBuffer>
implements VolatileFloatAccess {
    private static final long serialVersionUID = -7265085228179236189L;
    private static final int NUM_BYTES_PER_ENTITY = 4;

    public FloatBufferAccess(FloatBuffer buffer, boolean isValid) {
        super(buffer, isValid);
    }

    public FloatBufferAccess(int numEntities, boolean isValid) {
        super(FloatBuffer.allocate(numEntities), isValid);
    }

    public FloatBufferAccess(ByteBuffer buffer, boolean isValid) {
        super(buffer.asFloatBuffer(), isValid);
    }

    public FloatBufferAccess(FloatBuffer buffer) {
        this(buffer, true);
    }

    public FloatBufferAccess(int numEntities) {
        this(numEntities, true);
    }

    public FloatBufferAccess(ByteBuffer buffer) {
        this(buffer, true);
    }

    public FloatBufferAccess() {
        this((FloatBuffer)null, false);
    }

    @Override
    public float getValue(int index) {
        return ((FloatBuffer)this.buffer).get(index);
    }

    @Override
    public void setValue(int index, float value) {
        ((FloatBuffer)this.buffer).put(index, value);
    }

    @Override
    public int getNumBytesPerEntity() {
        return 4;
    }

    @Override
    public FloatBufferAccess newInstance(ByteBuffer buffer, boolean isValid) {
        return FloatBufferAccess.fromByteBuffer(buffer, isValid);
    }

    @Override
    public FloatBufferAccess newInstance(FloatBuffer buffer, boolean isValid) {
        return new FloatBufferAccess(buffer, isValid);
    }

    @Override
    FloatBuffer duplicateBuffer(FloatBuffer buffer) {
        return buffer.duplicate();
    }

    @Override
    FloatBufferAccess allocate(int numEntities, boolean isDirect, boolean isValid) {
        if (isDirect) {
            return (FloatBufferAccess)super.allocate(numEntities, isDirect, isValid);
        }
        return new FloatBufferAccess(numEntities, isValid);
    }

    public static FloatBufferAccess fromByteBuffer(ByteBuffer buffer, boolean isValid) {
        return new FloatBufferAccess(buffer, isValid);
    }

    public FloatBuffer getValues(AbstractFloatArray<?> array) {
        return ((FloatBuffer)this.buffer).duplicate().get(array.getCurrentStorageArray());
    }

    public FloatBuffer getValues(AbstractFloatArray<?> array, int offset, int length) {
        return ((FloatBuffer)this.buffer).duplicate().get(array.getCurrentStorageArray(), offset, length);
    }

    public FloatBuffer setValues(AbstractFloatArray<?> array) {
        return ((FloatBuffer)this.buffer).duplicate().put(array.getCurrentStorageArray());
    }

    public FloatBuffer setValues(AbstractFloatArray<?> array, int offset, int length) {
        return ((FloatBuffer)this.buffer).duplicate().put(array.getCurrentStorageArray(), offset, length);
    }

    public FloatBuffer setValues(FloatBufferAccess access) {
        return ((FloatBuffer)this.buffer).duplicate().put((FloatBuffer)access.getCurrentStorageArray());
    }
}

