/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import java.math.BigInteger;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.integer.GenericLongType;
import net.imglib2.util.Util;

public class UnsignedLongType
extends GenericLongType<UnsignedLongType> {
    private static final double MAX_VALUE_PLUS_ONE = Math.pow(2.0, 64.0);
    private static final double MAX_LONG_PLUS_ONE = Math.pow(2.0, 63.0);
    private static final NativeTypeFactory<UnsignedLongType, LongAccess> typeFactory = NativeTypeFactory.LONG(UnsignedLongType::new);

    public UnsignedLongType(NativeImg<?, ? extends LongAccess> img) {
        super(img);
    }

    public UnsignedLongType(long value) {
        super(value);
    }

    public UnsignedLongType(BigInteger value) {
        super((NativeImg)null);
        this.dataAccess = new LongArray(1);
        this.set(value.longValue());
    }

    public UnsignedLongType(LongAccess access) {
        super(access);
    }

    public UnsignedLongType() {
        this(0L);
    }

    @Override
    public UnsignedLongType duplicateTypeOnSameNativeImg() {
        return new UnsignedLongType(this.img);
    }

    @Override
    public NativeTypeFactory<UnsignedLongType, LongAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    @Override
    public void mul(float c) {
        this.set(Util.round((double)((float)this.get() * c)));
    }

    @Override
    public void mul(double c) {
        this.set(Util.round((double)this.get() * c));
    }

    @Override
    public void add(UnsignedLongType c) {
        this.set(this.get() + c.get());
    }

    @Override
    public void div(UnsignedLongType c) {
        this.set(UnsignedLongType.divide(this.get(), c.get()));
    }

    public static final long divide(long d1, long d2) {
        if (d2 < 0L) {
            if (Long.compareUnsigned(d1, d2) < 0) {
                return 0L;
            }
            return 1L;
        }
        if (d1 < 0L) {
            long quotient;
            long reminder = d1 - (quotient = (d1 >>> 1) / d2 << 1) * d2;
            return quotient + (long)(Long.compareUnsigned(d2, reminder) < 0 ? 0 : 1);
        }
        return d1 / d2;
    }

    @Override
    public void mul(UnsignedLongType c) {
        this.set(this.get() * c.get());
    }

    @Override
    public void sub(UnsignedLongType c) {
        this.set(this.get() - c.get());
    }

    @Override
    public void setOne() {
        this.set(1L);
    }

    @Override
    public void setZero() {
        this.set(0L);
    }

    @Override
    public void inc() {
        this.set(this.get() + 1L);
    }

    @Override
    public void dec() {
        this.set(this.get() - 1L);
    }

    @Override
    public String toString() {
        return this.getBigInteger().toString();
    }

    public long get() {
        return this.dataAccess.getValue(this.i.get());
    }

    @Override
    public BigInteger getBigInteger() {
        BigInteger mask = new BigInteger("FFFFFFFFFFFFFFFF", 16);
        return BigInteger.valueOf(this.get()).and(mask);
    }

    @Override
    public void set(long value) {
        this.dataAccess.setValue(this.i.get(), value);
    }

    @Override
    public int getInteger() {
        return (int)this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set(f);
    }

    @Override
    public void setBigInteger(BigInteger b) {
        this.set(b.longValue());
    }

    @Override
    public void setReal(double real) {
        this.set(UnsignedLongType.doubleToUnsignedLong(real));
    }

    static long doubleToUnsignedLong(double real) {
        double value = real < MAX_LONG_PLUS_ONE ? Math.max(0.0, real) : Math.min(-1.0, real - MAX_VALUE_PLUS_ONE);
        return Util.round(value);
    }

    @Override
    public void setReal(float real) {
        this.setReal((double)real);
    }

    @Override
    public void set(BigInteger bi) {
        this.set(bi.longValue());
    }

    @Override
    public double getMaxValue() {
        return MAX_VALUE_PLUS_ONE - 1.0;
    }

    public BigInteger getMaxBigIntegerValue() {
        return new BigInteger("+FFFFFFFFFFFFFFFF", 16);
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Deprecated
    public static final int compare(long a, long b) {
        if (a == b) {
            return 0;
        }
        boolean test = a < b;
        if (a < 0L != b < 0L) {
            test = !test;
        }
        return test ? -1 : 1;
    }

    @Override
    public UnsignedLongType createVariable() {
        return new UnsignedLongType(0L);
    }

    @Override
    public UnsignedLongType copy() {
        return new UnsignedLongType(this.dataAccess != null ? this.get() : 0L);
    }

    @Override
    public float getRealFloat() {
        long l = this.get();
        return l >= 0L ? (float)l : (float)MAX_VALUE_PLUS_ONE + (float)l;
    }

    @Override
    public double getRealDouble() {
        return UnsignedLongType.unsignedLongToDouble(this.get());
    }

    static double unsignedLongToDouble(long l) {
        return l >= 0L ? (double)l : MAX_VALUE_PLUS_ONE + (double)l;
    }

    @Override
    public int compareTo(UnsignedLongType other) {
        return Long.compareUnsigned(this.get(), other.get());
    }
}

