/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij.export.imgloader;

import ij.ImagePlus;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicSetupImgLoader;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.ViewSetup;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.meta.Axes;
import net.imglib2.meta.AxisType;
import net.imglib2.meta.ImgPlus;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import spimopener.SPIMExperiment;

@Deprecated
public class HuiskenImageLoader
implements BasicImgLoader {
    private final File expFile;
    private SPIMExperiment exp;
    private boolean hasAlternatingIllumination;
    private final HashMap<Integer, SetupLoader> setupIdToSetupImgLoader;
    private static final String basenameFormatString = "t%05d-a%03d-c%03d-i%01d";

    public HuiskenImageLoader(File file, HashMap<Integer, ViewSetup> setups) {
        this.expFile = file;
        this.exp = null;
        this.setupIdToSetupImgLoader = new HashMap();
        for (Map.Entry<Integer, ViewSetup> entry : setups.entrySet()) {
            this.setupIdToSetupImgLoader.put(entry.getKey(), new SetupLoader(entry.getValue()));
        }
    }

    private synchronized void ensureExpIsOpen() {
        if (this.exp == null) {
            this.exp = new SPIMExperiment(this.expFile.getAbsolutePath());
            this.hasAlternatingIllumination = this.exp.d < this.exp.planeEnd + 1 - this.exp.planeStart;
        }
    }

    private static String getBasename(int timepoint, int angle, int channel, int illumination) {
        return String.format(basenameFormatString, timepoint, angle, channel, illumination);
    }

    public BasicSetupImgLoader<?> getSetupImgLoader(int setupId) {
        return this.setupIdToSetupImgLoader.get(setupId);
    }

    public class SetupLoader
    implements BasicSetupImgLoader<UnsignedShortType> {
        private final UnsignedShortType type = new UnsignedShortType();
        private final ViewSetup setup;

        public SetupLoader(ViewSetup setup) {
            this.setup = setup;
        }

        public ImgPlus<UnsignedShortType> getImage(int timepointId, ImgLoaderHint ... hints) {
            HuiskenImageLoader.this.ensureExpIsOpen();
            int channel = this.setup.getChannel().getId();
            int illumination = this.setup.getIllumination().getId();
            int angle = this.setup.getAngle().getId();
            ImagePlus imp = this.getImagePlus(timepointId);
            Img img = ImageJFunctions.wrapShort((ImagePlus)imp);
            String name = HuiskenImageLoader.getBasename(timepointId, angle, channel, illumination);
            AxisType[] axes = new AxisType[]{Axes.X, Axes.Y, Axes.Z};
            float zStretching = (float)(((HuiskenImageLoader)HuiskenImageLoader.this).exp.pd / ((HuiskenImageLoader)HuiskenImageLoader.this).exp.pw);
            double[] calibration = new double[]{1.0, 1.0, zStretching};
            return new ImgPlus(img, name, axes, calibration);
        }

        public UnsignedShortType getImageType() {
            return this.type;
        }

        private ImagePlus getImagePlus(int timepointId) {
            ImagePlus imp;
            int channel = this.setup.getChannel().getId();
            int illumination = this.setup.getIllumination().getId();
            int angle = this.setup.getAngle().getId();
            int s = ((HuiskenImageLoader)HuiskenImageLoader.this).exp.sampleStart;
            int r = ((HuiskenImageLoader)HuiskenImageLoader.this).exp.regionStart;
            int f = ((HuiskenImageLoader)HuiskenImageLoader.this).exp.frameStart;
            int zMin = ((HuiskenImageLoader)HuiskenImageLoader.this).exp.planeStart;
            int zMax = ((HuiskenImageLoader)HuiskenImageLoader.this).exp.planeEnd;
            boolean xMin = false;
            int xMax = ((HuiskenImageLoader)HuiskenImageLoader.this).exp.w - 1;
            boolean yMin = false;
            int yMax = ((HuiskenImageLoader)HuiskenImageLoader.this).exp.h - 1;
            if (HuiskenImageLoader.this.hasAlternatingIllumination) {
                int zStep = 2;
                imp = illumination == 0 ? HuiskenImageLoader.this.exp.openNotProjected(s, timepointId, timepointId, r, angle, channel, zMin, zMax - 1, 2, f, f, 0, yMax, 0, xMax, 0, 1, 3, false) : HuiskenImageLoader.this.exp.openNotProjected(s, timepointId, timepointId, r, angle, channel, zMin + 1, zMax, 2, f, f, 0, yMax, 0, xMax, 0, 1, 3, false);
            } else {
                imp = HuiskenImageLoader.this.exp.openNotProjected(s, timepointId, timepointId, r, angle, channel, zMin, zMax, f, f, 0, yMax, 0, xMax, 0, 1, 3, false);
            }
            return imp;
        }
    }
}

