/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import net.imagej.updater.util.HTTPSUtil;
import net.imagej.updater.util.UpdaterUtil;

public class UpdateSite
implements Cloneable,
Comparable<UpdateSite> {
    boolean active;
    private boolean official;
    private String name;
    private String url;
    private boolean keepURLModification;
    private String host;
    private String uploadDirectory;
    private String description;
    private String maintainer;
    private long timestamp;
    int rank;

    public UpdateSite(String name, String url, String sshHost, String uploadDirectory, String description, String maintainer, long timestamp) {
        this.setName(name);
        this.setURL(url);
        this.setUploadDirectory(uploadDirectory);
        this.setHost(sshHost);
        this.setDescription(description);
        this.setMaintainer(maintainer);
        this.setTimestamp(timestamp);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isOfficial() {
        return this.official;
    }

    public void setOfficial(boolean official) {
        this.official = official;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url = UpdateSite.format(url);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUploadDirectory() {
        return this.uploadDirectory;
    }

    public void setUploadDirectory(String uploadDirectory) {
        this.uploadDirectory = uploadDirectory == null || uploadDirectory.equals("") || uploadDirectory.endsWith("/") ? uploadDirectory : uploadDirectory + "/";
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public void setMaintainer(String maintainer) {
        this.maintainer = maintainer;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getRank() {
        return this.rank;
    }

    public Object clone() {
        UpdateSite clone = new UpdateSite(this.name, this.url, this.host, this.uploadDirectory, this.description, this.maintainer, this.timestamp);
        clone.setActive(this.isActive());
        clone.setOfficial(this.isOfficial());
        return clone;
    }

    public boolean isLastModified(long lastModified) {
        return this.timestamp == Long.parseLong(UpdaterUtil.timestamp(lastModified));
    }

    public void setLastModified(long lastModified) {
        this.timestamp = Long.parseLong(UpdaterUtil.timestamp(lastModified));
    }

    public boolean isUploadable() {
        return this.uploadDirectory != null && !this.uploadDirectory.equals("") || this.host != null && this.host.indexOf(58) > 0;
    }

    public String toString() {
        return this.getURL() + (this.host != null ? ", " + this.host : "") + (this.uploadDirectory != null ? ", " + this.uploadDirectory : "");
    }

    @Override
    public int compareTo(UpdateSite other) {
        return this.rank - other.rank;
    }

    public boolean equals(Object other) {
        if (other instanceof UpdateSite) {
            return this.rank == ((UpdateSite)other).rank;
        }
        return false;
    }

    public int hashCode() {
        return this.rank;
    }

    public String getUploadProtocol() {
        if (this.host == null) {
            throw new RuntimeException("Missing upload information for site " + this.url);
        }
        int at = this.host.indexOf(64);
        int colon = this.host.indexOf(58);
        if (colon > 0 && (at < 0 || colon < at)) {
            return this.host.substring(0, colon);
        }
        return "ssh";
    }

    public boolean shouldKeepURL() {
        return this.keepURLModification;
    }

    public void setKeepURL(boolean keepURL) {
        this.keepURLModification = keepURL;
    }

    public static String format(String url) {
        if (url == null || url.isEmpty()) {
            return url;
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = UpdateSite.rewriteOldURLs(url);
        return url;
    }

    private static String rewriteOldURLs(String url) {
        if ("http://pacific.mpi-cbg.de/update/".equals(url) || "http://fiji.sc/update/".equals(url)) {
            return HTTPSUtil.getProtocol() + "update.fiji.sc/";
        }
        return url;
    }
}

