/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class Histogram {
    private float _vmin;
    private float _vmax;
    private boolean _computedMinMax;
    private Sampling _sbin;
    private long[] _h;
    private long _nin;
    private long _nlo;
    private long _nhi;

    public Histogram(float[] v) {
        this.initMinMax(v);
        this.init(v, 0);
    }

    public Histogram(float[] v, int nbin) {
        this.initMinMax(v);
        this.init(v, nbin);
    }

    public Histogram(float[] v, float vmin, float vmax) {
        Check.argument(vmin <= vmax, "vmin<=vmax");
        this.initMinMax(vmin, vmax);
        this.init(v, 0);
    }

    public Histogram(float[] v, float vmin, float vmax, int nbin) {
        Check.argument(vmin <= vmax, "vmin<=vmax");
        this.initMinMax(vmin, vmax);
        this.init(v, nbin);
    }

    public float getMinValue() {
        return this._vmin;
    }

    public float getMaxValue() {
        return this._vmax;
    }

    public int getBinCount() {
        return this._sbin.getCount();
    }

    public double getBinDelta() {
        return this._sbin.getDelta();
    }

    public double getBinFirst() {
        return this._sbin.getFirst();
    }

    public Sampling getBinSampling() {
        return this._sbin;
    }

    public long[] getCounts() {
        return ArrayMath.copy(this._h);
    }

    public float[] getDensities() {
        int nbin = this.getBinCount();
        float[] d = new float[nbin];
        double s = 1.0 / (double)this._nin;
        for (int ibin = 0; ibin < nbin; ++ibin) {
            d[ibin] = (float)(s * (double)this._h[ibin]);
        }
        return d;
    }

    public long getInCount() {
        return this._nin;
    }

    public long getLowCount() {
        return this._nlo;
    }

    public long getHighCount() {
        return this._nhi;
    }

    private void initMinMax(float[] v) {
        int n = v.length;
        this._vmin = this._vmax = v[0];
        for (int i = 1; i < n; ++i) {
            float vi = v[i];
            if (vi < this._vmin) {
                this._vmin = vi;
            }
            if (!(vi > this._vmax)) continue;
            this._vmax = vi;
        }
        this._computedMinMax = true;
    }

    private void initMinMax(float vmin, float vmax) {
        this._vmin = vmin;
        this._vmax = vmax;
        this._computedMinMax = false;
    }

    private float[] trim(float[] v) {
        float[] t;
        if (this._computedMinMax) {
            t = ArrayMath.copy(v);
        } else {
            int n = v.length;
            t = new float[n];
            int m = 0;
            for (int i = 0; i < n; ++i) {
                float vi = v[i];
                if (!(this._vmin <= vi) || !(vi <= this._vmax)) continue;
                t[m++] = vi;
            }
            if (m < n) {
                t = ArrayMath.copy(m, t);
            }
        }
        return t;
    }

    private void init(float[] v, int nbin) {
        double dbin = (this._vmax - this._vmin) / (float)ArrayMath.max(1, nbin);
        if (dbin == 0.0) {
            dbin = ArrayMath.max(1.0, 2.0 * (double)ArrayMath.abs(this._vmin) * 1.1920928955078125E-7);
        }
        if (nbin == 0) {
            float[] t;
            int n;
            nbin = 1;
            if (this._vmin < this._vmax && (n = (t = this.trim(v)).length) > 0) {
                int k25 = (int)ArrayMath.rint(0.25 * (double)(n - 1));
                ArrayMath.quickPartialSort(k25, t);
                double v25 = t[k25];
                int k75 = (int)ArrayMath.rint(0.75 * (double)(n - 1));
                ArrayMath.quickPartialSort(k75, t);
                double v75 = t[k75];
                if (v25 < v75) {
                    dbin = 2.0 * (v75 - v25) * ArrayMath.pow((double)n, -0.3333333333333333);
                    nbin = ArrayMath.max(1, (int)ArrayMath.floor((double)(this._vmax - this._vmin) / dbin));
                    dbin = (this._vmax - this._vmin) / (float)nbin;
                }
            }
        }
        double fbin = (double)this._vmin + 0.5 * dbin;
        this._sbin = new Sampling(nbin, dbin, fbin);
        double vscl = 1.0 / dbin;
        int n = v.length;
        this._nlo = 0L;
        this._nhi = 0L;
        this._h = new long[nbin];
        this._nin = 0L;
        for (int i = 0; i < n; ++i) {
            float vi = v[i];
            if (vi < this._vmin) {
                ++this._nlo;
                continue;
            }
            if (vi > this._vmax) {
                ++this._nhi;
                continue;
            }
            int ibin = (int)ArrayMath.rint(((double)vi - fbin) * vscl);
            if (ibin < 0) {
                ibin = 0;
            } else if (ibin >= nbin) {
                ibin = nbin - 1;
            }
            int n2 = ibin;
            this._h[n2] = this._h[n2] + 1L;
            ++this._nin;
        }
    }
}

