/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.LocalDiffusionKernel;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.dsp.Tensors2;
import edu.mines.jtk.interp.Gridder2;
import edu.mines.jtk.interp.PolyTrend2;
import edu.mines.jtk.interp.SimpleGridder2;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;
import java.util.ArrayList;
import java.util.logging.Logger;

public class SplinesGridder2
implements Gridder2 {
    private static final float QNULL = Float.MIN_VALUE;
    private Tensors2 _tensors;
    private float _tension = 0.0f;
    private float[] _f;
    private float[] _x1;
    private float[] _x2;
    private float _small = 1.0E-4f;
    private int _niter = 10000;
    private ArrayList<Float> _residuals = new ArrayList();
    private LocalDiffusionKernel _ldk = new LocalDiffusionKernel(LocalDiffusionKernel.Stencil.D22);
    private static Logger log = Logger.getLogger(SplinesGridder2.class.getName());

    public SplinesGridder2() {
        this(null);
    }

    public SplinesGridder2(float[] f, float[] x1, float[] x2) {
        this(null);
        this.setScattered(f, x1, x2);
    }

    public SplinesGridder2(Tensors2 tensors) {
        this.setTensors(tensors);
    }

    public SplinesGridder2(Tensors2 tensors, float[] f, float[] x1, float[] x2) {
        this.setTensors(tensors);
        this.setScattered(f, x1, x2);
    }

    public void setTensors(Tensors2 tensors) {
        this._tensors = tensors;
        if (this._tensors == null) {
            this._tensors = new Tensors2(){

                @Override
                public void getTensor(int i1, int i2, float[] d) {
                    d[0] = 1.0f;
                    d[1] = 0.0f;
                    d[2] = 1.0f;
                }
            };
        }
    }

    public void setTension(double tension) {
        Check.argument(0.0 <= tension, "0<=tension");
        Check.argument(tension < 1.0, "tension<1");
        this._tension = (float)tension;
    }

    public void setMaxIterations(int niter) {
        this._niter = niter;
    }

    public int getIterationCount() {
        return this._residuals.size() - 1;
    }

    public float[] getResiduals() {
        int n = this._residuals.size();
        float[] r = new float[n];
        for (int i = 0; i < n; ++i) {
            r[i] = this._residuals.get(i).floatValue();
        }
        return r;
    }

    public void gridMissing(float qnull, float[][] q) {
        int n1 = q[0].length;
        int n2 = q.length;
        boolean[][] m = new boolean[n2][n1];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                m[i2][i1] = q[i2][i1] == qnull;
            }
        }
        this.gridMissing(m, q);
    }

    public void gridMissing(boolean[][] m, float[][] q) {
        int n1 = m[0].length;
        int n2 = m.length;
        float s = 0.02f * (float)(n1 - 1 + n2 - 1);
        float t = this._tension / (1.0f - this._tension) / (s * s);
        LaplaceOperator2 lop = new LaplaceOperator2(this._ldk, this._tensors, t, m);
        SmoothOperator2 sop = new SmoothOperator2();
        float[][] b = new float[n2][n1];
        lop.applyRhs(q, b);
        this.solve(lop, sop, b, q);
    }

    @Override
    public void setScattered(float[] f, float[] x1, float[] x2) {
        this._f = f;
        this._x1 = x1;
        this._x2 = x2;
    }

    @Override
    public float[][] grid(Sampling s1, Sampling s2) {
        Check.argument(s1.isUniform(), "s1 is uniform");
        Check.argument(s2.isUniform(), "s2 is uniform");
        Check.state(this._f != null, "scattered samples have been set");
        Check.state(this._x1 != null, "scattered samples have been set");
        Check.state(this._x2 != null, "scattered samples have been set");
        PolyTrend2 pt = new PolyTrend2(1, this._f, this._x1, this._x2);
        pt.detrend();
        SimpleGridder2 sg = new SimpleGridder2(this._f, this._x1, this._x2);
        sg.setNullValue(Float.MIN_VALUE);
        float[][] q = sg.grid(s1, s2);
        this.gridMissing(Float.MIN_VALUE, q);
        pt.restore(q, s1, s2);
        pt.restore();
        return q;
    }

    private void solve(Operator2 a, Operator2 m, float[][] b, float[][] x) {
        int iter;
        float rnorm;
        this._residuals.clear();
        int n1 = b[0].length;
        int n2 = b.length;
        float small = this._small * 100000.0f / (float)n1 / (float)n2;
        float[][] d = new float[n2][n1];
        float[][] q = new float[n2][n1];
        float[][] r = new float[n2][n1];
        float[][] s = new float[n2][n1];
        SplinesGridder2.szero(x);
        SplinesGridder2.scopy(b, r);
        m.apply(r, s);
        SplinesGridder2.scopy(s, d);
        float delta = SplinesGridder2.sdot(r, s);
        float rnormBegin = rnorm = ArrayMath.sqrt(delta);
        float rnormSmall = rnorm * small;
        this._residuals.add(Float.valueOf(1.0f));
        log.fine("solve: small=" + small);
        for (iter = 0; iter < this._niter && rnorm > rnormSmall; ++iter) {
            log.finer("  iter=" + iter + " rnorm=" + rnorm / rnormBegin);
            a.apply(d, q);
            float alpha = delta / SplinesGridder2.sdot(d, q);
            SplinesGridder2.saxpy(alpha, d, x);
            SplinesGridder2.saxpy(-alpha, q, r);
            m.apply(r, s);
            float deltaOld = delta;
            delta = SplinesGridder2.sdot(r, s);
            float beta = delta / deltaOld;
            SplinesGridder2.sxpay(beta, s, d);
            rnorm = ArrayMath.sqrt(delta);
            this._residuals.add(Float.valueOf(rnorm / rnormBegin));
        }
        log.fine("        iter=" + iter + " rnorm=" + rnorm / rnormBegin);
    }

    private static void szero(float[][] x) {
        ArrayMath.zero(x);
    }

    private static void scopy(float[][] x, float[][] y) {
        ArrayMath.copy(x, y);
    }

    private static float sdot(float[][] x, float[][] y) {
        int n1 = x[0].length;
        int n2 = x.length;
        float d = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            float[] x2 = x[i2];
            float[] y2 = y[i2];
            for (int i1 = 0; i1 < n1; ++i1) {
                d += x2[i1] * y2[i1];
            }
        }
        return d;
    }

    private static void saxpy(float a, float[][] x, float[][] y) {
        int n1 = x[0].length;
        int n2 = x.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float[] x2 = x[i2];
            float[] y2 = y[i2];
            for (int i1 = 0; i1 < n1; ++i1) {
                int n = i1;
                y2[n] = y2[n] + a * x2[i1];
            }
        }
    }

    private static void sxpay(float a, float[][] x, float[][] y) {
        int n1 = x[0].length;
        int n2 = x.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float[] x2 = x[i2];
            float[] y2 = y[i2];
            for (int i1 = 0; i1 < n1; ++i1) {
                y2[i1] = a * y2[i1] + x2[i1];
            }
        }
    }

    private static void smoothS(float[][] x, float[][] y) {
        int n1 = x[0].length;
        int n2 = x.length;
        int n1m = n1 - 1;
        int n2m = n2 - 1;
        float[][] t = new float[3][n1];
        ArrayMath.copy(x[0], t[0]);
        ArrayMath.copy(x[1], t[1]);
        for (int i2 = 0; i2 < n2; ++i2) {
            int i2m = i2 > 0 ? i2 - 1 : 0;
            int i2p = i2 < n2m ? i2 + 1 : n2m;
            int j2m = i2m % 3;
            int j2 = i2 % 3;
            int j2p = i2p % 3;
            ArrayMath.copy(x[i2p], t[j2p]);
            float[] x2m = t[j2m];
            float[] x2p = t[j2p];
            float[] x20 = t[j2];
            float[] y20 = y[i2];
            for (int i1 = 0; i1 < n1; ++i1) {
                int i1m = i1 > 0 ? i1 - 1 : 0;
                int i1p = i1 < n1m ? i1 + 1 : n1m;
                y20[i1] = 0.25f * x20[i1] + 0.125f * (x20[i1m] + x20[i1p] + x2m[i1] + x2p[i1]) + 0.0625f * (x2m[i1m] + x2m[i1p] + x2p[i1m] + x2p[i1p]);
            }
        }
    }

    private static void xsmoothS(float[][] x, float[][] y) {
        if (x == y) {
            x = ArrayMath.copy(x);
        }
        int n1 = x[0].length;
        int n2 = x.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int i2p;
            int i2m = i2 - 1;
            if (i2m < 0) {
                i2m += 2;
            }
            if ((i2p = i2 + 1) >= n2) {
                i2p -= 2;
            }
            float[] x2m = x[i2m];
            float[] x2p = x[i2p];
            float[] x20 = x[i2];
            float[] y20 = y[i2];
            for (int i1 = 0; i1 < n1; ++i1) {
                int i1p;
                int i1m = i1 - 1;
                if (i1m < 0) {
                    i1m += 2;
                }
                if ((i1p = i1 + 1) >= n1) {
                    i1p -= 2;
                }
                y20[i1] = 0.25f * x20[i1] + 0.125f * (x20[i1m] + x20[i1p] + x2m[i1] + x2p[i1]) + 0.0625f * (x2m[i1m] + x2m[i1p] + x2p[i1m] + x2p[i1p]);
            }
        }
    }

    private static void xxsmoothS(float[][] x, float[][] y) {
        if (x == y) {
            x = ArrayMath.copy(x);
        }
        ArrayMath.zero(y);
        int n1 = x[0].length;
        int n2 = x.length;
        int i2 = 1;
        int m2 = 0;
        while (i2 < n2) {
            int i1 = 1;
            int m1 = 0;
            while (i1 < n1) {
                float xs = 0.0625f * (x[i2][i1] + x[i2][m1] + x[m2][i1] + x[m2][m1]);
                float[] fArray = y[i2];
                int n = i1;
                fArray[n] = fArray[n] + xs;
                float[] fArray2 = y[i2];
                int n3 = m1;
                fArray2[n3] = fArray2[n3] + xs;
                float[] fArray3 = y[m2];
                int n4 = i1++;
                fArray3[n4] = fArray3[n4] + xs;
                float[] fArray4 = y[m2];
                int n5 = m1++;
                fArray4[n5] = fArray4[n5] + xs;
            }
            ++i2;
            ++m2;
        }
    }

    private static void testSmooth() {
        int n1 = 5;
        int n2 = 5;
        float[][] x = ArrayMath.zerofloat(n1, n2);
        float[][] y = ArrayMath.zerofloat(n1, n2);
        x[n2 - 1][n1 - 1] = 1.0f;
        x[0][n1 - 1] = 1.0f;
        x[n2 - 1][0] = 1.0f;
        x[0][0] = 1.0f;
        y[n2 - 1][n1 - 1] = 1.0f;
        y[0][n1 - 1] = 1.0f;
        y[n2 - 1][0] = 1.0f;
        y[0][0] = 1.0f;
        float[][] sx = ArrayMath.zerofloat(n1, n2);
        float[][] sy = ArrayMath.zerofloat(n1, n2);
        SplinesGridder2.smoothS(x, sx);
        SplinesGridder2.smoothS(sx, sx);
        SplinesGridder2.smoothS(y, sy);
        SplinesGridder2.smoothS(sy, sy);
        ArrayMath.dump(sx);
        ArrayMath.dump(sy);
        float ysx = ArrayMath.sum(ArrayMath.mul(y, sx));
        float xsy = ArrayMath.sum(ArrayMath.mul(x, sy));
        System.out.println("ysx=" + ysx + " xsy=" + xsy);
    }

    private static void main(String[] args) {
        SplinesGridder2.testSmooth();
    }

    private static class XLaplaceOperator2
    implements Operator2 {
        private LocalDiffusionKernel _ldk;
        private Tensors2 _d;
        private float _t;
        private boolean[][] _m;
        private float[][] _w;
        private float[][] _z;

        XLaplaceOperator2(LocalDiffusionKernel ldk, Tensors2 d, float t, boolean[][] m) {
            this._ldk = ldk;
            this._d = d;
            this._t = t;
            this._m = m;
            this._w = new float[m.length][m[0].length];
            this._z = new float[m.length][m[0].length];
        }

        @Override
        public void apply(float[][] x, float[][] y) {
            int i1;
            int i2;
            int n1 = x[0].length;
            int n2 = x.length;
            SplinesGridder2.smoothS(x, this._w);
            for (i2 = 0; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    this._z[i2][i1] = this._m[i2][i1] ? this._w[i2][i1] : 0.0f;
                }
            }
            SplinesGridder2.szero(y);
            this._ldk.apply(this._d, this._z, y);
            ArrayMath.mul(this._t, y, this._z);
            this._ldk.apply(this._d, y, this._z);
            for (i2 = 0; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    y[i2][i1] = this._m[i2][i1] ? this._z[i2][i1] : this._w[i2][i1];
                }
            }
            SplinesGridder2.smoothS(y, y);
        }

        public void applyRhs(float[][] x, float[][] y) {
            int i1;
            int i2;
            int n1 = x[0].length;
            int n2 = x.length;
            for (i2 = 0; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    this._z[i2][i1] = this._m[i2][i1] ? 0.0f : x[i2][i1];
                }
            }
            SplinesGridder2.szero(y);
            this._ldk.apply(this._d, this._z, y);
            ArrayMath.mul(this._t, y, this._z);
            this._ldk.apply(this._d, y, this._z);
            for (i2 = 0; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    y[i2][i1] = this._m[i2][i1] ? -this._z[i2][i1] : x[i2][i1];
                }
            }
            SplinesGridder2.smoothS(y, y);
        }
    }

    private static class LaplaceOperator2
    implements Operator2 {
        private LocalDiffusionKernel _ldk;
        private Tensors2 _d;
        private float _t;
        private boolean[][] _m;
        private float[][] _z;

        LaplaceOperator2(LocalDiffusionKernel ldk, Tensors2 d, float t, boolean[][] m) {
            this._ldk = ldk;
            this._d = d;
            this._t = t;
            this._m = m;
            this._z = new float[m.length][m[0].length];
        }

        @Override
        public void apply(float[][] x, float[][] y) {
            int i1;
            int i2;
            int n1 = x[0].length;
            int n2 = x.length;
            for (i2 = 0; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    this._z[i2][i1] = this._m[i2][i1] ? x[i2][i1] : 0.0f;
                }
            }
            SplinesGridder2.szero(y);
            this._ldk.apply(this._d, this._z, y);
            ArrayMath.mul(this._t, y, this._z);
            this._ldk.apply(this._d, y, this._z);
            for (i2 = 0; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    y[i2][i1] = this._m[i2][i1] ? this._z[i2][i1] : x[i2][i1];
                }
            }
        }

        public void applyRhs(float[][] x, float[][] y) {
            int i1;
            int i2;
            int n1 = x[0].length;
            int n2 = x.length;
            for (i2 = 0; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    this._z[i2][i1] = this._m[i2][i1] ? 0.0f : x[i2][i1];
                }
            }
            SplinesGridder2.szero(y);
            this._ldk.apply(this._d, this._z, y);
            ArrayMath.mul(this._t, y, this._z);
            this._ldk.apply(this._d, y, this._z);
            for (i2 = 0; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    y[i2][i1] = this._m[i2][i1] ? -this._z[i2][i1] : x[i2][i1];
                }
            }
        }
    }

    private static class SmoothOperator2
    implements Operator2 {
        private SmoothOperator2() {
        }

        @Override
        public void apply(float[][] x, float[][] y) {
            SplinesGridder2.smoothS(x, y);
            SplinesGridder2.smoothS(y, y);
        }
    }

    private static interface Operator2 {
        public void apply(float[][] var1, float[][] var2);
    }
}

