/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

class TimeHeap3 {
    private Type _type;
    private int _n1;
    private int _n2;
    private int _n3;
    private int _n;
    private int[][][] _imap;
    private Entry[] _e = new Entry[1024];

    public TimeHeap3(Type type, int n1, int n2, int n3) {
        this._type = type;
        this._n1 = n1;
        this._n2 = n2;
        this._n3 = n3;
        this._imap = new int[n3][n2][n1];
    }

    public Type getType() {
        return this._type;
    }

    public int getN1() {
        return this._n1;
    }

    public int getN2() {
        return this._n2;
    }

    public int getN3() {
        return this._n3;
    }

    public void insert(int i1, int i2, int i3, float time) {
        this.insert(i1, i2, i3, time, 0);
    }

    public void insert(int i1, int i2, int i3, float time, int mark) {
        Entry ei;
        int i = this.indexOf(i1, i2, i3);
        Check.argument(i < 0, "entry with indices (i1,i2) is not in the heap");
        i = this._n;
        if (this._n == this._e.length) {
            this.grow(this._n + 1);
        }
        if ((ei = this._e[i]) == null) {
            ei = new Entry();
        }
        ei.i1 = i1;
        ei.i2 = i2;
        ei.i3 = i3;
        ei.time = time;
        ei.mark = mark;
        this.set(i, ei);
        this.siftUp(i);
        ++this._n;
    }

    public void reduce(int i1, int i2, int i3, float time) {
        int i = this.indexOf(i1, i2, i3);
        Check.argument(i >= 0, "entry with indices (i1,i2) is in the heap");
        Check.argument(time < this._e[i].time, "specified time less than time in heap");
        this._e[i].time = time;
        if (this._type == Type.MIN) {
            this.siftUp(i);
        } else {
            this.siftDown(i);
        }
    }

    public Entry remove() {
        Check.state(this._n > 0, "heap is not empty");
        Entry e0 = this._e[0];
        --this._n;
        if (this._n > 0) {
            this.set(0, this._e[this._n]);
            this.set(this._n, e0);
            this.siftDown(0);
        }
        return e0;
    }

    public boolean contains(int i1, int i2, int i3) {
        return this.indexOf(i1, i2, i3) >= 0;
    }

    public void clear() {
        this._n = 0;
    }

    public int size() {
        return this._n;
    }

    public boolean isEmpty() {
        return this._n == 0;
    }

    public void dump() {
        this.dump("", 0);
    }

    private int indexOf(int i1, int i2, int i3) {
        int i = this._imap[i3][i2][i1];
        if (i < 0 || i >= this._n) {
            return -1;
        }
        Entry ei = this._e[i];
        if (ei.i1 != i1 || ei.i2 != i2 || ei.i3 != i3) {
            return -1;
        }
        return i;
    }

    private void set(int i, Entry ei) {
        this._e[i] = ei;
        this._imap[ei.i3][ei.i2][ei.i1] = i;
    }

    private void siftDown(int i) {
        Entry ei = this._e[i];
        float eit = ei.time;
        int m = this._n >>> 1;
        while (i < m) {
            int c = (i << 1) + 1;
            int r = c + 1;
            Entry ec = this._e[c];
            if (this._type == Type.MIN) {
                if (r < this._n && this._e[r].time < ec.time) {
                    c = r;
                    ec = this._e[c];
                }
                if (eit <= ec.time) {
                    break;
                }
            } else {
                if (r < this._n && this._e[r].time > ec.time) {
                    c = r;
                    ec = this._e[c];
                }
                if (eit >= ec.time) break;
            }
            this.set(i, ec);
            i = c;
        }
        if (ei != this._e[i]) {
            this.set(i, ei);
        }
    }

    private void siftUp(int i) {
        Entry ei = this._e[i];
        float eit = ei.time;
        while (i > 0) {
            int p = i - 1 >>> 1;
            Entry ep = this._e[p];
            if (this._type == Type.MIN ? eit >= ep.time : eit <= ep.time) break;
            this.set(i, ep);
            i = p;
        }
        if (ei != this._e[i]) {
            this.set(i, ei);
        }
    }

    private void grow(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        int oldCapacity = this._e.length;
        int newCapacity = oldCapacity * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        }
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        Entry[] e = new Entry[newCapacity];
        System.arraycopy(this._e, 0, e, 0, oldCapacity);
        this._e = e;
    }

    private void dump(String s, int i) {
        if (i < this._n) {
            s = s + "  ";
            Entry e = this._e[i];
            System.out.println(s + e.i1 + " " + e.i2 + " " + e.i3 + " " + e.time);
            this.dump(s, 2 * i + 1);
            this.dump(s, 2 * i + 2);
        }
    }

    public static void main(String[] args) {
        TimeHeap3.testHeap(new TimeHeap3(Type.MIN, 9, 11, 13));
        TimeHeap3.testHeap(new TimeHeap3(Type.MAX, 9, 11, 13));
    }

    private static void testHeap(TimeHeap3 heap) {
        int i1;
        int i2;
        int i3;
        int n1 = heap.getN1();
        int n2 = heap.getN2();
        int n3 = heap.getN3();
        int n = n1 * n2 * n3;
        float[] s = ArrayMath.randfloat(n);
        float[][][] t = ArrayMath.reshape(n1, n2, n3, s);
        int i = 0;
        for (i3 = 0; i3 < n3; ++i3) {
            for (i2 = 0; i2 < n2; ++i2) {
                i1 = 0;
                while (i1 < n1) {
                    float ti = t[i3][i2][i1];
                    heap.insert(i1, i2, i3, ti);
                    s[i] = ti;
                    ++i1;
                    ++i;
                }
            }
        }
        i = 0;
        for (i3 = 0; i3 < n3; ++i3) {
            for (i2 = 0; i2 < n2; ++i2) {
                for (i1 = 0; i1 < n1; ++i1) {
                    int n4 = i++;
                    s[n4] = s[n4] - 0.5f;
                    float[] fArray = t[i3][i2];
                    int n5 = i1;
                    fArray[n5] = fArray[n5] - 0.5f;
                    heap.reduce(i1, i2, i3, t[i3][i2][i1]);
                }
            }
        }
        assert (!heap.isEmpty());
        assert (heap.size() == n);
        ArrayMath.quickSort(s);
        if (heap.getType() == Type.MAX) {
            s = ArrayMath.reverse(s);
        }
        for (int i4 = 0; i4 < n; ++i4) {
            Entry e = heap.remove();
            float ti = e.time;
            assert (ti == s[i4]);
        }
        assert (heap.isEmpty());
        assert (heap.size() == 0);
    }

    public static class Entry {
        public int i1;
        public int i2;
        public int i3;
        public float time;
        public int mark;
    }

    public static enum Type {
        MIN,
        MAX;

    }
}

