/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.Axis;
import edu.mines.jtk.sgl.AxisAlignedFrame;
import edu.mines.jtk.sgl.DragContext;
import edu.mines.jtk.sgl.Dragable;
import edu.mines.jtk.sgl.Group;
import edu.mines.jtk.sgl.HandleBox;
import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.MouseConstrained;
import edu.mines.jtk.sgl.MouseOnLine;
import edu.mines.jtk.sgl.MouseOnPlane;
import edu.mines.jtk.sgl.Plane;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.Selectable;
import edu.mines.jtk.sgl.Vector3;
import java.awt.event.MouseEvent;

public class AxisAlignedQuad
extends Group
implements Selectable,
Dragable {
    private AxisAlignedFrame _frame;
    private boolean _handlesVisible;
    private Handle[] _h = new Handle[4];
    private Dragger _dragger;

    public AxisAlignedQuad(Axis axis, Point3 qa, Point3 qb) {
        this._frame = new AxisAlignedFrame(axis, qa, qb);
        this.addChild(this._frame);
    }

    public AxisAlignedFrame getFrame() {
        return this._frame;
    }

    @Override
    public void dragBegin(DragContext dc) {
        this._dragger = new Dragger();
        this._dragger.dragBegin(dc);
    }

    @Override
    public void drag(DragContext dc) {
        this._dragger.drag(dc);
    }

    @Override
    public void dragEnd(DragContext dc) {
        this._dragger.dragEnd(dc);
        this._dragger = null;
    }

    @Override
    protected void selectedChanged() {
        if (this.isSelected()) {
            this.updateHandles();
            this.showHandles();
        } else {
            this.hideHandles();
        }
    }

    private void updateHandles() {
        Point3 q0 = this._frame.getCorner(0);
        Point3 q1 = this._frame.getCorner(1);
        Point3 q2 = this._frame.getCorner(2);
        Point3 q3 = this._frame.getCorner(3);
        if (this._h[0] == null) {
            this._h[0] = new Handle(q0);
            this._h[1] = new Handle(q1);
            this._h[2] = new Handle(q2);
            this._h[3] = new Handle(q3);
        } else {
            this._h[0].setLocation(q0);
            this._h[1].setLocation(q1);
            this._h[2].setLocation(q2);
            this._h[3].setLocation(q3);
        }
    }

    private void showHandles() {
        if (!this._handlesVisible) {
            this._handlesVisible = true;
            this.addChild(this._h[0]);
            this.addChild(this._h[1]);
            this.addChild(this._h[2]);
            this.addChild(this._h[3]);
            this.dirtyDraw();
        }
    }

    private void hideHandles() {
        if (this._handlesVisible) {
            this._handlesVisible = false;
            this.removeChild(this._h[0]);
            this.removeChild(this._h[1]);
            this.removeChild(this._h[2]);
            this.removeChild(this._h[3]);
            this.dirtyDraw();
        }
    }

    private class Handle
    extends HandleBox
    implements Dragable {
        private MouseOnPlane _mouseOnPlane;

        Handle(Point3 p) {
            super(p);
        }

        @Override
        public void dragBegin(DragContext dc) {
            Point3 p = dc.getPointWorld();
            Vector3 n = null;
            Axis axis = AxisAlignedQuad.this._frame.getAxis();
            if (axis == Axis.X) {
                n = new Vector3(1.0, 0.0, 0.0);
            } else if (axis == Axis.Y) {
                n = new Vector3(0.0, 1.0, 0.0);
            } else if (axis == Axis.Z) {
                n = new Vector3(0.0, 0.0, 1.0);
            }
            MouseEvent event = dc.getMouseEvent();
            Point3 origin = this.getLocation();
            Plane plane = new Plane(p, n);
            Matrix44 worldToPixel = dc.getWorldToPixel();
            this._mouseOnPlane = new MouseOnPlane(event, origin, plane, worldToPixel);
        }

        @Override
        public void drag(DragContext dc) {
            Point3 qnew = this._mouseOnPlane.getPoint(dc.getMouseEvent());
            if (this == AxisAlignedQuad.this._h[0]) {
                AxisAlignedQuad.this._frame.setCorners(qnew, AxisAlignedQuad.this._frame.getCorner(3));
            } else if (this == AxisAlignedQuad.this._h[1]) {
                AxisAlignedQuad.this._frame.setCorners(qnew, AxisAlignedQuad.this._frame.getCorner(2));
            } else if (this == AxisAlignedQuad.this._h[2]) {
                AxisAlignedQuad.this._frame.setCorners(qnew, AxisAlignedQuad.this._frame.getCorner(1));
            } else if (this == AxisAlignedQuad.this._h[3]) {
                AxisAlignedQuad.this._frame.setCorners(qnew, AxisAlignedQuad.this._frame.getCorner(0));
            }
            AxisAlignedQuad.this.updateHandles();
        }

        @Override
        public void dragEnd(DragContext dc) {
            this._mouseOnPlane = null;
        }
    }

    private class Dragger
    implements Dragable {
        private MouseConstrained _mouseConstrained;
        private Point3 _origin;
        private Point3 _qa;
        private Point3 _qb;

        private Dragger() {
        }

        @Override
        public void dragBegin(DragContext dc) {
            Point3 origin = dc.getPointWorld();
            Vector3 normal = null;
            Axis axis = AxisAlignedQuad.this._frame.getAxis();
            if (axis == Axis.X) {
                normal = new Vector3(1.0, 0.0, 0.0);
            } else if (axis == Axis.Y) {
                normal = new Vector3(0.0, 1.0, 0.0);
            } else if (axis == Axis.Z) {
                normal = new Vector3(0.0, 0.0, 1.0);
            }
            Plane plane = new Plane(origin, normal);
            MouseEvent event = dc.getMouseEvent();
            Matrix44 worldToPixel = dc.getWorldToPixel();
            this._mouseConstrained = event.isControlDown() || event.isAltDown() ? new MouseOnPlane(event, origin, plane, worldToPixel) : new MouseOnLine(event, origin, normal, worldToPixel);
            this._origin = origin;
            this._qa = AxisAlignedQuad.this._frame.getCornerMin();
            this._qb = AxisAlignedQuad.this._frame.getCornerMax();
        }

        @Override
        public void drag(DragContext dc) {
            assert (this._mouseConstrained != null) : "mouseConstrained!=null";
            Point3 point = this._mouseConstrained.getPoint(dc.getMouseEvent());
            Vector3 vector = point.minus(this._origin);
            Point3 qa = this._qa.plus(vector);
            Point3 qb = this._qb.plus(vector);
            AxisAlignedQuad.this._frame.setCorners(qa, qb);
            AxisAlignedQuad.this.updateHandles();
        }

        @Override
        public void dragEnd(DragContext dc) {
            this._mouseConstrained = null;
        }
    }
}

