/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.AbstractPNode;
import org.lsmp.djep.sjep.MutiableMonomial;
import org.lsmp.djep.sjep.MutiablePolynomial;
import org.lsmp.djep.sjep.PConstant;
import org.lsmp.djep.sjep.PFunction;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.PVariable;
import org.lsmp.djep.sjep.Polynomial;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class Monomial
extends AbstractPNode {
    PConstant coeff;
    PNodeI[] vars;
    PNodeI[] powers;

    Monomial(PolynomialCreator pc, PConstant coeff, PNodeI[] vars, PNodeI[] powers) {
        super(pc);
        if (vars.length != powers.length) {
            throw new IllegalArgumentException("Monomial.valueOf length of variables and powers must be equal. they are " + vars.length + " " + powers.length);
        }
        this.coeff = coeff;
        this.vars = vars;
        this.powers = powers;
    }

    Monomial(PolynomialCreator pc, PConstant coeff, PNodeI var) {
        super(pc);
        this.coeff = coeff;
        this.vars = new PNodeI[]{var};
        this.powers = new PNodeI[]{pc.oneConstant};
    }

    Monomial(PolynomialCreator pc, PConstant coeff, PNodeI var, PNodeI power) {
        super(pc);
        this.coeff = coeff;
        this.vars = new PNodeI[]{var};
        this.powers = new PNodeI[]{power};
    }

    PNodeI valueOf(PConstant coefficient, PNodeI[] terms, PNodeI[] pows) {
        if (coefficient.isZero()) {
            return this.pc.zeroConstant;
        }
        if (terms.length == 0) {
            return coefficient;
        }
        return new Monomial(this.pc, coefficient, terms, pows);
    }

    MutiableMonomial toMutiableMonomial() {
        PNodeI[] newTerms = new PNodeI[this.vars.length];
        PNodeI[] newPows = new PNodeI[this.vars.length];
        for (int i = 0; i < this.vars.length; ++i) {
            newTerms[i] = this.vars[i];
            newPows[i] = this.powers[i];
        }
        return new MutiableMonomial(this.pc, this.coeff, newTerms, newPows);
    }

    @Override
    public PNodeI mul(PNodeI node) throws ParseException {
        if (node instanceof PConstant) {
            return this.valueOf((PConstant)this.coeff.mul(node), this.vars, this.powers);
        }
        if (node instanceof Monomial) {
            return this.mul((Monomial)node);
        }
        MutiableMonomial mm = this.toMutiableMonomial();
        mm.mul(node, this.pc.oneConstant);
        return mm.toPNode();
    }

    @Override
    public PNodeI div(PNodeI node) throws ParseException {
        if (node instanceof PConstant) {
            return this.valueOf((PConstant)this.coeff.div(node), this.vars, this.powers);
        }
        if (node instanceof Monomial) {
            return this.div((Monomial)node);
        }
        MutiableMonomial mm = this.toMutiableMonomial();
        mm.mul(node, this.pc.minusOneConstant);
        return mm.toPNode();
    }

    PNodeI mul(Monomial m) throws ParseException {
        MutiableMonomial mm = this.toMutiableMonomial();
        mm.mul(m.coeff);
        for (int i = 0; i < m.vars.length; ++i) {
            mm.mul(m.vars[i], m.powers[i]);
        }
        return mm.toPNode();
    }

    PNodeI div(Monomial m) throws ParseException {
        MutiableMonomial mm = this.toMutiableMonomial();
        mm.div(m.coeff);
        for (int i = 0; i < this.vars.length; ++i) {
            mm.mul(m.vars[i], m.powers[i].negate());
        }
        return mm.toPNode();
    }

    @Override
    public PNodeI pow(PNodeI pow) throws ParseException {
        if (pow instanceof PConstant) {
            MutiableMonomial mm = this.toMutiableMonomial();
            mm.power((PConstant)pow);
            return mm.toPNode();
        }
        return super.pow(pow);
    }

    @Override
    public PNodeI negate() throws ParseException {
        return new Monomial(this.pc, (PConstant)this.coeff.negate(), this.vars, this.powers);
    }

    @Override
    public PNodeI invert() throws ParseException {
        PNodeI[] newPows = new PNodeI[this.vars.length];
        for (int i = 0; i < this.vars.length; ++i) {
            newPows[i] = this.powers[i].negate();
        }
        return new Monomial(this.pc, (PConstant)this.coeff.invert(), this.vars, newPows);
    }

    @Override
    public PNodeI add(PNodeI node) throws ParseException {
        Monomial mon;
        if (node instanceof PVariable && this.equalsIgnoreConstant(node)) {
            return this.valueOf((PConstant)this.coeff.add(this.pc.oneConstant), this.vars, this.powers);
        }
        if (node instanceof Monomial && this.equalsIgnoreConstant(mon = (Monomial)node)) {
            return this.valueOf((PConstant)this.coeff.add(mon.coeff), this.vars, this.powers);
        }
        return super.add(node);
    }

    @Override
    public PNodeI sub(PNodeI node) throws ParseException {
        Monomial mon;
        if (node instanceof PVariable && this.equalsIgnoreConstant(node)) {
            return this.valueOf((PConstant)this.coeff.sub(this.pc.oneConstant), this.vars, this.powers);
        }
        if (node instanceof Monomial && this.equalsIgnoreConstant(mon = (Monomial)node)) {
            return this.valueOf((PConstant)this.coeff.sub(mon.coeff), this.vars, this.powers);
        }
        return super.sub(node);
    }

    PNodeI addConstant(PConstant c) throws ParseException {
        return this.valueOf((PConstant)this.coeff.add(c), this.vars, this.powers);
    }

    @Override
    public boolean equals(PNodeI node) {
        if (!(node instanceof Monomial)) {
            return false;
        }
        if (!this.coeff.equals(((Monomial)node).coeff)) {
            return false;
        }
        return this.equalsIgnoreConstant((Monomial)node);
    }

    boolean equalsIgnoreConstant(Monomial mon) {
        if (this.vars.length != mon.vars.length) {
            return false;
        }
        for (int i = 0; i < this.vars.length; ++i) {
            if (!this.vars[i].equals(mon.vars[i])) {
                return false;
            }
            if (this.powers[i].equals(mon.powers[i])) continue;
            return false;
        }
        return true;
    }

    boolean equalsIgnoreConstant(PNodeI node) {
        if (node instanceof Monomial) {
            return this.equalsIgnoreConstant((Monomial)node);
        }
        if (this.vars.length != 1) {
            return false;
        }
        if (!this.vars[0].equals(node)) {
            return false;
        }
        return this.powers[0].isOne();
    }

    @Override
    public int compareTo(PNodeI node) {
        if (node instanceof PConstant) {
            return 1;
        }
        if (node instanceof Monomial) {
            Monomial mon = (Monomial)node;
            for (int i = 0; i < this.vars.length; ++i) {
                if (i >= mon.vars.length) {
                    return 1;
                }
                int res = this.vars[i].compareTo(mon.vars[i]);
                if (res != 0) {
                    return res;
                }
                res = this.powers[i].compareTo(mon.powers[i]);
                if (res == 0) continue;
                return res;
            }
            if (this.vars.length > mon.vars.length) {
                return 1;
            }
            if (this.vars.length < mon.vars.length) {
                return -1;
            }
            return this.coeff.compareTo(mon.coeff);
        }
        int res = this.vars[0].compareTo(node);
        if (res == 0) {
            res = this.powers[0].compareTo(this.pc.oneConstant);
        }
        return res;
    }

    private boolean negativePower(PNodeI pow) {
        return pow instanceof PConstant && ((PConstant)pow).isNegative();
    }

    private void printPower(StringBuffer sb, PNodeI pow) {
        if (pow.isOne()) {
            return;
        }
        if (pow instanceof PConstant || pow instanceof PVariable || pow instanceof PFunction) {
            sb.append('^');
            sb.append(((Object)pow).toString());
        } else {
            sb.append("^(");
            sb.append(((Object)pow).toString());
            sb.append(")");
        }
    }

    @Override
    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        boolean flag = false;
        if (this.coeff.isMinusOne()) {
            sb.append('-');
        } else if (!this.coeff.isOne()) {
            sb.append(this.coeff.toString());
            flag = true;
        }
        int numNeg = 0;
        for (i = 0; i < this.vars.length; ++i) {
            if (this.negativePower(this.powers[i])) {
                ++numNeg;
                continue;
            }
            if (flag) {
                sb.append('*');
            }
            if (this.vars[i] instanceof Polynomial) {
                sb.append('(');
                sb.append(((Object)this.vars[i]).toString());
                sb.append(')');
            } else {
                sb.append(((Object)this.vars[i]).toString());
            }
            this.printPower(sb, this.powers[i]);
            flag = true;
        }
        if (numNeg > 0) {
            if (!flag) {
                sb.append('1');
            }
            if (numNeg > 1) {
                sb.append("/(");
            } else {
                sb.append("/");
            }
            flag = false;
            for (i = 0; i < this.vars.length; ++i) {
                if (!this.negativePower(this.powers[i])) continue;
                if (flag) {
                    sb.append('*');
                }
                if (this.vars[i] instanceof Polynomial) {
                    sb.append('(');
                    sb.append(((Object)this.vars[i]).toString());
                    sb.append(')');
                } else {
                    sb.append(((Object)this.vars[i]).toString());
                }
                try {
                    this.printPower(sb, this.powers[i].negate());
                }
                catch (ParseException e) {
                    throw new IllegalStateException(e.getMessage());
                }
                flag = true;
            }
            if (numNeg > 1) {
                sb.append(")");
            }
        }
        return sb.toString();
    }

    @Override
    public Node toNode() throws ParseException {
        int nCoeff = this.coeff.isOne() ? 0 : 1;
        int numDivisors = 0;
        for (int i = 0; i < this.vars.length; ++i) {
            if (!this.negativePower(this.powers[i])) continue;
            ++numDivisors;
        }
        Node[] args = new Node[nCoeff + this.vars.length - numDivisors];
        int pos = 0;
        if (nCoeff > 0) {
            args[pos++] = this.coeff.toNode();
        }
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.negativePower(this.powers[i])) continue;
            args[pos++] = this.powers[i].isOne() ? this.vars[i].toNode() : this.pc.nf.buildOperatorNode(this.pc.os.getPower(), this.vars[i].toNode(), this.powers[i].toNode());
        }
        Node top = args.length == 0 ? this.coeff.toNode() : (args.length == 1 ? args[0] : this.pc.nf.buildOperatorNode(this.pc.os.getMultiply(), args));
        if (numDivisors == 0) {
            return top;
        }
        Node[] divisors = new Node[numDivisors];
        pos = 0;
        for (int i = 0; i < this.vars.length; ++i) {
            if (!this.negativePower(this.powers[i])) continue;
            PNodeI pow = this.powers[i].negate();
            divisors[pos++] = this.powers[i] instanceof PConstant && ((PConstant)this.powers[i]).isMinusOne() ? this.vars[i].toNode() : this.pc.nf.buildOperatorNode(this.pc.os.getPower(), this.vars[i].toNode(), pow.toNode());
        }
        Node bottom = divisors.length == 1 ? divisors[0] : this.pc.nf.buildOperatorNode(this.pc.os.getMultiply(), divisors);
        return this.pc.nf.buildOperatorNode(this.pc.os.getDivide(), top, bottom);
    }

    boolean negativeCoefficient() {
        return this.coeff.isNegative();
    }

    @Override
    public PNodeI expand() throws ParseException {
        MutiablePolynomial mp = new MutiablePolynomial(this.pc, new PNodeI[]{this.coeff});
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.powers[i] instanceof PConstant) {
                PConstant pow = (PConstant)this.powers[i];
                if (pow.isZero()) continue;
                if (pow.isOne()) {
                    mp.expandMul(this.vars[i].expand());
                    continue;
                }
                if (!pow.isInteger()) continue;
                int intpow = pow.intValue();
                if (intpow > 0) {
                    PNodeI res = this.vars[i].expand();
                    for (int j = 1; j <= intpow; ++j) {
                        mp.expandMul(res);
                    }
                    continue;
                }
                mp.expandMul(new Monomial(this.pc, this.pc.oneConstant, this.vars[i].expand(), this.powers[i]));
                continue;
            }
            mp.expandMul(new Monomial(this.pc, this.pc.oneConstant, this.vars[i].expand(), this.powers[i]));
        }
        return mp.toPNode();
    }
}

