/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.commands.convolve;

import net.imagej.ImgPlus;
import net.imagej.axis.Axis;
import net.imagej.ops.Op;
import net.imagej.ops.OpService;
import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class)
public class Convolve<I extends RealType<I>, K extends RealType<K>, O extends RealType<O>>
implements Command {
    @Parameter
    private ImgPlus<I> in;
    @Parameter
    private ImgPlus<K> kernel;
    @Parameter
    private Axis[] axes;
    @Parameter
    private OutOfBoundsFactory<I, ImgPlus<I>> outOfBounds = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);
    @Parameter
    private boolean asFloat;
    @Parameter(type=ItemIO.OUTPUT)
    private ImgPlus<O> out;
    @Parameter
    private OpService ops;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        int[] axisIndices = new int[]{0, 1};
        if (this.axes.length != axisIndices.length) {
            throw new IllegalArgumentException("The number of selected dimension doesn't conforms with the kernel size.");
        }
        if (this.asFloat) {
            try {
                this.out = (ImgPlus)this.in.factory().imgFactory((Object)new FloatType()).create(this.in, (Object)new FloatType());
            }
            catch (IncompatibleTypeException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.out = (ImgPlus)this.in.factory().create(this.in, (Object)((RealType)this.in.firstElement()).createVariable());
        }
        Op op = this.ops.op(Ops.Filter.Convolve.class, new Object[]{this.out, this.in, this.kernel});
        if (this.in.numDimensions() > this.kernel.numDimensions()) {
            if (!(op instanceof UnaryComputerOp)) throw new IllegalArgumentException("The input image has more dimensions than the kernel!");
            this.ops.run(Ops.Slice.class, new Object[]{this.out, this.in, op, axisIndices});
            return;
        } else {
            if (this.in.numDimensions() != this.kernel.numDimensions()) return;
            this.ops.run(op, new Object[]{this.out, this.in, this.kernel});
        }
    }
}

