/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.create.integerType;

import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractNullaryFunctionOp;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Create.IntegerType.class)
public class DefaultCreateIntegerType
extends AbstractNullaryFunctionOp<IntegerType>
implements Ops.Create.IntegerType {
    @Parameter(required=false)
    private long maxValue;

    @Override
    public IntegerType calculate() {
        if (this.maxValue <= 0L) {
            return new IntType();
        }
        if (this.maxValue <= 1L) {
            return new BitType();
        }
        if (this.maxValue <= 127L) {
            return new ByteType();
        }
        if (this.maxValue <= 255L) {
            return new UnsignedByteType();
        }
        if (this.maxValue <= 32767L) {
            return new ShortType();
        }
        if (this.maxValue <= 65535L) {
            return new UnsignedShortType();
        }
        if (this.maxValue <= Integer.MAX_VALUE) {
            return new IntType();
        }
        if (this.maxValue <= 0xFFFFFFFFL) {
            return new UnsignedIntType();
        }
        return new LongType();
    }
}

