/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.haralick;

import net.imagej.ops.Ops;
import net.imagej.ops.features.haralick.AbstractHaralickFeature;
import net.imagej.ops.features.haralick.helper.CoocMeanX;
import net.imagej.ops.features.haralick.helper.CoocMeanY;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Haralick.ClusterPromenence.class, label="Haralick: Cluster Promenence")
public class DefaultClusterPromenence<T extends RealType<T>>
extends AbstractHaralickFeature<T>
implements Ops.Haralick.ClusterPromenence {
    private UnaryFunctionOp<double[][], DoubleType> coocMeanXFunc;
    private UnaryFunctionOp<double[][], DoubleType> coocMeanYFunc;

    @Override
    public void initialize() {
        super.initialize();
        this.coocMeanXFunc = Functions.unary(this.ops(), CoocMeanX.class, DoubleType.class, double[][].class, new Object[0]);
        this.coocMeanYFunc = Functions.unary(this.ops(), CoocMeanY.class, DoubleType.class, double[][].class, new Object[0]);
    }

    @Override
    public void compute(IterableInterval<T> input, DoubleType output) {
        double[][] matrix = this.getCooccurrenceMatrix(input);
        int nrGrayLevels = matrix.length;
        double mux = this.coocMeanXFunc.calculate(matrix).getRealDouble();
        double muy = this.coocMeanYFunc.calculate(matrix).getRealDouble();
        double res = 0.0;
        for (int i = 0; i < nrGrayLevels; ++i) {
            for (int j = 0; j < nrGrayLevels; ++j) {
                res += Math.pow((double)(i + j) - mux - muy, 4.0) * matrix[i][j];
            }
        }
        output.setReal(res);
    }
}

