/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom;

import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.roi.geom.real.Polygon2D;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.Centroid.class, label="Geometric: Center of Gravity")
public class CentroidPolygon
extends AbstractUnaryFunctionOp<Polygon2D, RealLocalizable>
implements Ops.Geometric.Centroid {
    private UnaryFunctionOp<Polygon2D, DoubleType> sizeFunc;

    @Override
    public void initialize() {
        this.sizeFunc = Functions.unary(this.ops(), Ops.Geometric.Size.class, DoubleType.class, this.in(), new Object[0]);
    }

    @Override
    public RealLocalizable calculate(Polygon2D input) {
        double area = this.sizeFunc.calculate(input).get();
        double cx = 0.0;
        double cy = 0.0;
        for (int i = 0; i < input.numVertices(); ++i) {
            RealLocalizable p0 = input.vertex(i);
            RealLocalizable p1 = input.vertex((i + 1) % input.numVertices());
            double p0_x = p0.getDoublePosition(0);
            double p0_y = p0.getDoublePosition(1);
            double p1_x = p1.getDoublePosition(0);
            double p1_y = p1.getDoublePosition(1);
            cx += (p0_x + p1_x) * (p0_x * p1_y - p1_x * p0_y);
            cy += (p0_y + p1_y) * (p0_x * p1_y - p1_x * p0_y);
        }
        return new RealPoint(new double[]{cx / (area * 6.0), cy / (area * 6.0)});
    }
}

