/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold.localPhansalkar;

import net.imagej.ops.Ops;
import net.imagej.ops.map.neighborhood.CenterAwareIntegralComputerOp;
import net.imagej.ops.special.computer.AbstractBinaryComputerOp;
import net.imagej.ops.stats.IntegralMean;
import net.imagej.ops.stats.IntegralVariance;
import net.imagej.ops.threshold.apply.LocalThresholdIntegral;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;
import net.imglib2.converter.RealDoubleConverter;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.composite.Composite;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Threshold.LocalPhansalkarThreshold.class, priority=-101.0)
public class LocalPhansalkarThresholdIntegral<T extends RealType<T>>
extends LocalThresholdIntegral<T>
implements Ops.Threshold.LocalPhansalkarThreshold {
    @Parameter(required=false)
    private double k = 0.25;
    @Parameter(required=false)
    private double r = 0.5;
    private final double p = 2.0;
    private final double q = 10.0;

    @Override
    protected CenterAwareIntegralComputerOp<T, BitType> unaryComputer() {
        LocalPhansalkarThresholdComputer op = new LocalPhansalkarThresholdComputer(this.ops().op(IntegralMean.class, DoubleType.class, RectangleNeighborhood.class), this.ops().op(IntegralVariance.class, DoubleType.class, RectangleNeighborhood.class));
        op.setEnvironment(this.ops());
        return op;
    }

    @Override
    protected int[] requiredIntegralImages() {
        return new int[]{1, 2};
    }

    private class LocalPhansalkarThresholdComputer<I extends RealType<I>>
    extends AbstractBinaryComputerOp<I, RectangleNeighborhood<Composite<DoubleType>>, BitType>
    implements CenterAwareIntegralComputerOp<I, BitType> {
        private final IntegralMean<DoubleType> integralMean;
        private final IntegralVariance<DoubleType> integralVariance;

        public LocalPhansalkarThresholdComputer(IntegralMean<DoubleType> integralMean, IntegralVariance<DoubleType> integralVariance) {
            this.integralMean = integralMean;
            this.integralVariance = integralVariance;
        }

        @Override
        public void compute(I center, RectangleNeighborhood<Composite<DoubleType>> neighborhood, BitType output) {
            DoubleType mean = new DoubleType();
            this.integralMean.compute(neighborhood, mean);
            DoubleType variance = new DoubleType();
            this.integralVariance.compute(neighborhood, variance);
            DoubleType stdDev = new DoubleType(Math.sqrt(variance.get()));
            DoubleType threshold = new DoubleType(mean.getRealDouble() * (1.0 + 2.0 * Math.exp(-10.0 * mean.getRealDouble()) + LocalPhansalkarThresholdIntegral.this.k * (stdDev.getRealDouble() / LocalPhansalkarThresholdIntegral.this.r - 1.0)));
            RealDoubleConverter conv = new RealDoubleConverter();
            DoubleType centerPixelAsDoubleType = variance;
            conv.convert(center, (Object)centerPixelAsDoubleType);
            output.set(centerPixelAsDoubleType.compareTo((AbstractRealType)threshold) > 0);
        }
    }
}

