/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold.percentile;

import net.imagej.ops.Ops;
import net.imagej.ops.threshold.AbstractComputeThresholdHistogram;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Threshold.Percentile.class, priority=100.0)
public class ComputePercentileThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T>
implements Ops.Threshold.Percentile {
    @Override
    public long computeBin(Histogram1d<T> hist) {
        long[] histogram = hist.toLongArray();
        int threshold = -1;
        double ptile = 0.5;
        double[] avec = new double[histogram.length];
        for (int i = 0; i < histogram.length; ++i) {
            avec[i] = 0.0;
        }
        double total = this.partialSum(histogram, histogram.length - 1);
        double temp = 1.0;
        for (int i = 0; i < histogram.length; ++i) {
            avec[i] = Math.abs(this.partialSum(histogram, i) / total - ptile);
            if (!(avec[i] < temp)) continue;
            temp = avec[i];
            threshold = i;
        }
        return threshold;
    }

    private double partialSum(long[] y, int j) {
        double x = 0.0;
        for (int i = 0; i <= j; ++i) {
            x += (double)y[i];
        }
        return x;
    }
}

