/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.omevisual.gui.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import loci.formats.ome.OMEXMLMetadata;
import ome.xml.model.primitives.PositiveInteger;
import sc.fiji.omevisual.gui.model.GenericModel;
import sc.fiji.omevisual.gui.model.TiffDataModel;

public class ImageModel
extends GenericModel<TiffDataModel> {
    private final int imageID;
    private final String id;
    private final String name;
    private final String pixelID;
    private final float physicalSizeX;
    private final float physicalSizeY;
    private final float physicalSizeZ;
    private final float timeIncrement;
    private final PositiveInteger sizeC;
    private final PositiveInteger sizeT;
    private final PositiveInteger sizeX;
    private final PositiveInteger sizeY;
    private final PositiveInteger sizeZ;
    private final List<Map<String, String>> channels;

    public ImageModel(int imageID, OMEXMLMetadata md) {
        this.imageID = imageID;
        this.id = md.getImageID(imageID);
        this.name = md.getImageName(imageID);
        this.pixelID = md.getPixelsID(imageID);
        this.physicalSizeX = md.getPixelsPhysicalSizeX(imageID) != null ? md.getPixelsPhysicalSizeX(imageID).value().floatValue() : -1.0f;
        this.physicalSizeY = md.getPixelsPhysicalSizeY(imageID) != null ? md.getPixelsPhysicalSizeY(imageID).value().floatValue() : -1.0f;
        this.physicalSizeZ = md.getPixelsPhysicalSizeZ(imageID) != null ? md.getPixelsPhysicalSizeZ(imageID).value().floatValue() : -1.0f;
        this.timeIncrement = md.getPixelsTimeIncrement(imageID) != null ? md.getPixelsTimeIncrement(imageID).value().floatValue() : -1.0f;
        this.sizeC = md.getPixelsSizeC(imageID);
        this.sizeT = md.getPixelsSizeT(imageID);
        this.sizeX = md.getPixelsSizeX(imageID);
        this.sizeY = md.getPixelsSizeY(imageID);
        this.sizeZ = md.getPixelsSizeZ(imageID);
        this.channels = new ArrayList<Map<String, String>>();
        for (int i = 0; i < md.getChannelCount(imageID); ++i) {
            HashMap<String, String> channel = new HashMap<String, String>();
            channel.put("ID", md.getChannelID(imageID, i));
            channel.put("Name", md.getChannelName(imageID, i));
            this.channels.add(channel);
        }
    }

    @Override
    public String toString() {
        return "Image : " + this.name;
    }

    @Override
    public Iterable<List<String>> getInformationsRow() {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        rows.add(Arrays.asList("Name", this.name));
        rows.add(Arrays.asList("ID", this.id));
        rows.add(Arrays.asList("Pixel ID", this.pixelID));
        if (this.physicalSizeX > -1.0f) {
            rows.add(Arrays.asList("Physical Size X", this.physicalSizeX + " \u00b5m"));
        } else {
            rows.add(Arrays.asList("Physical Size X", ""));
        }
        if (this.physicalSizeY > -1.0f) {
            rows.add(Arrays.asList("Physical Size Y", this.physicalSizeY + " \u00b5m"));
        } else {
            rows.add(Arrays.asList("Physical Size Y", ""));
        }
        if (this.physicalSizeZ > -1.0f) {
            rows.add(Arrays.asList("Physical Size Z", this.physicalSizeZ + " \u00b5m"));
        } else {
            rows.add(Arrays.asList("Physical Size Z", ""));
        }
        if (this.timeIncrement > -1.0f) {
            rows.add(Arrays.asList("Time Increment", this.timeIncrement + " s"));
        } else {
            rows.add(Arrays.asList("Time Increment", ""));
        }
        rows.add(Arrays.asList("Size X", this.sizeX.toString()));
        rows.add(Arrays.asList("Size Y", this.sizeY.toString()));
        rows.add(Arrays.asList("Size Z", this.sizeZ.toString()));
        rows.add(Arrays.asList("Size Channel", this.sizeC.toString()));
        rows.add(Arrays.asList("Size Time", this.sizeT.toString()));
        for (int i = 0; i < this.channels.size(); ++i) {
            Map<String, String> channel = this.channels.get(i);
            for (Map.Entry<String, String> entry : channel.entrySet()) {
                rows.add(Arrays.asList("Channel " + Integer.toString(i) + " - " + entry.getKey(), entry.getValue()));
            }
        }
        return rows;
    }
}

