/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import java.awt.Rectangle;
import view5d.ROI;

class RectROI
extends ROI {
    int[] ProjMin;
    int[] ProjMax;

    RectROI() {
    }

    @Override
    double GetROISize(int dim) {
        return this.ProjMax[dim] - this.ProjMin[dim] + 1;
    }

    public Rectangle GetSqrROI(int dim) {
        if (this.ProjMin == null) {
            return null;
        }
        if (dim == 0) {
            return new Rectangle(this.ProjMin[2], this.ProjMin[1], (int)this.GetROISize(2) - 1, (int)this.GetROISize(1) - 1);
        }
        if (dim == 1) {
            return new Rectangle(this.ProjMin[0], this.ProjMin[2], (int)this.GetROISize(0) - 1, (int)this.GetROISize(2) - 1);
        }
        if (dim == 2) {
            return new Rectangle(this.ProjMin[0], this.ProjMin[1], (int)this.GetROISize(0) - 1, (int)this.GetROISize(1) - 1);
        }
        return null;
    }

    void TakeSqrROIs(int[] Pmin, int[] Pmax) {
        if (this.ProjMin == null) {
            this.ProjMin = new int[3];
            this.ProjMax = new int[3];
        }
        for (int d = 0; d < 3; ++d) {
            this.ProjMin[d] = Pmin[d];
            this.ProjMax[d] = Pmax[d];
        }
    }

    public void UpdateSqrROI(int ROIX, int ROIY, int ROIXe, int ROIYe, int dir) {
        if (dir == 0) {
            this.ProjMin[2] = ROIX;
            this.ProjMax[2] = ROIXe;
            this.ProjMin[1] = ROIY;
            this.ProjMax[1] = ROIYe;
        } else if (dir == 1) {
            this.ProjMin[0] = ROIX;
            this.ProjMax[0] = ROIXe;
            this.ProjMin[2] = ROIY;
            this.ProjMax[2] = ROIYe;
        } else {
            this.ProjMin[0] = ROIX;
            this.ProjMax[0] = ROIXe;
            this.ProjMin[1] = ROIY;
            this.ProjMax[1] = ROIYe;
        }
    }

    @Override
    boolean InROIRange(int x, int y, int z) {
        if (this.ProjMin == null) {
            return true;
        }
        if (x < this.ProjMin[0]) {
            return false;
        }
        if (y < this.ProjMin[1]) {
            return false;
        }
        if (z < this.ProjMin[2]) {
            return false;
        }
        if (x > this.ProjMax[0]) {
            return false;
        }
        if (y > this.ProjMax[1]) {
            return false;
        }
        return z <= this.ProjMax[2];
    }
}

