/*
 * Decompiled with CFR 0.152.
 */
package fiji.threshold;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.NewImage;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.gui.YesNoCancelDialog;
import ij.plugin.CanvasResizer;
import ij.plugin.ContrastEnhancer;
import ij.plugin.MontageMaker;
import ij.plugin.PlugIn;
import ij.plugin.filter.RankFilters;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.Frame;
import org.scijava.util.VersionUtils;

public class Auto_Local_Threshold
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        if (null == imp) {
            IJ.showMessage((String)"There must be at least one image open");
            return;
        }
        if (imp.getBitDepth() != 8) {
            IJ.showMessage((String)"Error", (String)"Only 8-bit images are supported");
            return;
        }
        GenericDialog gd = new GenericDialog("Auto Local Threshold");
        String[] methods = new String[]{"Try all", "Bernsen", "Contrast", "Mean", "Median", "MidGrey", "Niblack", "Otsu", "Phansalkar", "Sauvola"};
        String version = VersionUtils.getVersion(this.getClass());
        gd.addMessage("Auto Local Threshold v" + version);
        gd.addChoice("Method", methods, methods[0]);
        gd.addNumericField("Radius", 15.0, 0);
        gd.addMessage("Special parameters (if different from default)");
        gd.addNumericField("Parameter_1", 0.0, 0);
        gd.addNumericField("Parameter_2", 0.0, 0);
        gd.addCheckbox("White objects on black background", true);
        if (imp.getStackSize() > 1) {
            gd.addCheckbox("Stack", false);
        }
        gd.addMessage("Thresholded result is always shown in white [255].");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String myMethod = gd.getNextChoice();
        int radius = (int)gd.getNextNumber();
        double par1 = gd.getNextNumber();
        double par2 = gd.getNextNumber();
        boolean doIwhite = gd.getNextBoolean();
        boolean doIstack = false;
        int stackSize = imp.getStackSize();
        if (stackSize > 1) {
            doIstack = gd.getNextBoolean();
        }
        if (myMethod.equals("Try all")) {
            int k;
            ImageProcessor ip = imp.getProcessor();
            int xe = ip.getWidth();
            int ye = ip.getHeight();
            int ml = methods.length;
            ImageStack tstack = null;
            if (stackSize > 1 && doIstack) {
                boolean doItAnyway = true;
                if (stackSize > 25) {
                    YesNoCancelDialog d = new YesNoCancelDialog((Frame)IJ.getInstance(), "Auto Local Threshold", "You might run out of memory.\n \nDisplay " + stackSize + " slices?\n \n 'No' will process without display and\noutput results to the log window.");
                    if (!d.yesPressed()) {
                        doItAnyway = false;
                    }
                    if (d.cancelPressed()) {
                        return;
                    }
                }
                for (int j = 1; j <= stackSize; ++j) {
                    int k2;
                    imp.setSlice(j);
                    ip = imp.getProcessor();
                    tstack = new ImageStack(xe, ye);
                    for (k2 = 1; k2 < ml; ++k2) {
                        tstack.addSlice(methods[k2], ip.duplicate());
                    }
                    ImagePlus imp2 = new ImagePlus("Auto Threshold", tstack);
                    imp2.updateAndDraw();
                    for (k2 = 1; k2 < ml; ++k2) {
                        imp2.setSlice(k2);
                        Object[] objectArray = this.exec(imp2, methods[k2], radius, par1, par2, doIwhite);
                    }
                    CanvasResizer cr = new CanvasResizer();
                    ImageStack stackNew = cr.expandStack(tstack, xe + 2, ye + 18, 1, 1);
                    ImagePlus imp3 = new ImagePlus("Auto Threshold", stackNew);
                    imp3.updateAndDraw();
                    MontageMaker mm = new MontageMaker();
                    mm.makeMontage(imp3, 3, 3, 1.0, 1, ml - 1, 1, 0, true);
                }
                imp.setSlice(1);
                IJ.run((String)"Images to Stack", (String)"method=[Copy (center)] title=Montage");
                return;
            }
            tstack = new ImageStack(xe, ye);
            for (k = 1; k < ml; ++k) {
                tstack.addSlice(methods[k], ip.duplicate());
            }
            ImagePlus imp2 = new ImagePlus("Auto Threshold", tstack);
            imp2.updateAndDraw();
            for (k = 1; k < ml; ++k) {
                imp2.setSlice(k);
                Object[] j = this.exec(imp2, methods[k], radius, par1, par2, doIwhite);
            }
            CanvasResizer cr = new CanvasResizer();
            ImageStack stackNew = cr.expandStack(tstack, xe + 2, ye + 18, 1, 1);
            ImagePlus imp3 = new ImagePlus("Auto Threshold", stackNew);
            imp3.updateAndDraw();
            MontageMaker mm = new MontageMaker();
            mm.makeMontage(imp3, 3, 3, 1.0, 1, ml - 1, 1, 0, true);
            return;
        }
        if (stackSize > 1 && doIstack) {
            for (int k = 1; k <= stackSize; ++k) {
                imp.setSlice(k);
                Object[] objectArray = this.exec(imp, myMethod, radius, par1, par2, doIwhite);
            }
            imp.setSlice(1);
        } else {
            Object[] objectArray = this.exec(imp, myMethod, radius, par1, par2, doIwhite);
        }
    }

    public Object[] exec(ImagePlus imp, String myMethod, int radius, double par1, double par2, boolean doIwhite) {
        if (null == imp) {
            return null;
        }
        ImageProcessor ip = imp.getProcessor();
        int xe = ip.getWidth();
        int ye = ip.getHeight();
        IJ.showStatus((String)"Thresholding...");
        long startTime = System.currentTimeMillis();
        if (imp.getStackSize() == 1) {
            ip.snapshot();
            Undo.setup((int)1, (ImagePlus)imp);
        }
        if (myMethod.equals("Bernsen")) {
            this.Bernsen(imp, radius, par1, par2, doIwhite);
        } else if (myMethod.equals("Contrast")) {
            this.Contrast(imp, radius, par1, par2, doIwhite);
        } else if (myMethod.equals("Mean")) {
            this.Mean(imp, radius, par1, par2, doIwhite);
        } else if (myMethod.equals("Median")) {
            this.Median(imp, radius, par1, par2, doIwhite);
        } else if (myMethod.equals("MidGrey")) {
            this.MidGrey(imp, radius, par1, par2, doIwhite);
        } else if (myMethod.equals("Niblack")) {
            this.Niblack(imp, radius, par1, par2, doIwhite);
        } else if (myMethod.equals("Otsu")) {
            this.Otsu(imp, radius, par1, par2, doIwhite);
        } else if (myMethod.equals("Phansalkar")) {
            this.Phansalkar(imp, radius, par1, par2, doIwhite);
        } else if (myMethod.equals("Sauvola")) {
            this.Sauvola(imp, radius, par1, par2, doIwhite);
        }
        imp.updateAndDraw();
        imp.getProcessor().setThreshold(255.0, 255.0, 2);
        IJ.showStatus((String)("\nDone " + (double)(System.currentTimeMillis() - startTime) / 1000.0));
        return new Object[]{imp};
    }

    void Bernsen(ImagePlus imp, int radius, double par1, double par2, boolean doIwhite) {
        int backg;
        int object;
        ImageProcessor ip = imp.getProcessor();
        int contrast_threshold = 15;
        if (par1 != 0.0) {
            if (IJ.debugMode) {
                IJ.log((String)("Bernsen: changed contrast_threshold from :" + contrast_threshold + "  to:" + par1));
            }
            contrast_threshold = (int)par1;
        }
        if (doIwhite) {
            object = -1;
            backg = 0;
        } else {
            object = 0;
            backg = -1;
        }
        ImagePlus Maximp = this.duplicateImage(ip);
        ImageProcessor ipMax = Maximp.getProcessor();
        RankFilters rf = new RankFilters();
        rf.rank(ipMax, (double)radius, 2);
        ImagePlus Minimp = this.duplicateImage(ip);
        ImageProcessor ipMin = Minimp.getProcessor();
        rf.rank(ipMin, (double)radius, 1);
        byte[] pixels = (byte[])ip.getPixels();
        byte[] max = (byte[])ipMax.getPixels();
        byte[] min = (byte[])ipMin.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            int local_contrast = (max[i] & 0xFF) - (min[i] & 0xFF);
            int mid_gray = ((min[i] & 0xFF) + (max[i] & 0xFF)) / 2;
            int temp = pixels[i] & 0xFF;
            pixels[i] = local_contrast < contrast_threshold ? (mid_gray >= 128 ? object : backg) : (temp >= mid_gray ? object : backg);
        }
    }

    void Contrast(ImagePlus imp, int radius, double par1, double par2, boolean doIwhite) {
        int backg;
        int object;
        ImageProcessor ip = imp.getProcessor();
        boolean c_value = false;
        if (doIwhite) {
            object = -1;
            backg = 0;
        } else {
            object = 0;
            backg = -1;
        }
        ImagePlus Maximp = this.duplicateImage(ip);
        ImageProcessor ipMax = Maximp.getProcessor();
        RankFilters rf = new RankFilters();
        rf.rank(ipMax, (double)radius, 2);
        ImagePlus Minimp = this.duplicateImage(ip);
        ImageProcessor ipMin = Minimp.getProcessor();
        rf.rank(ipMin, (double)radius, 1);
        byte[] pixels = (byte[])ip.getPixels();
        byte[] max = (byte[])ipMax.getPixels();
        byte[] min = (byte[])ipMin.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = Math.abs((max[i] & 0xFF) - (pixels[i] & 0xFF)) <= Math.abs((pixels[i] & 0xFF) - (min[i] & 0xFF)) && (pixels[i] & 0xFF) != 0 ? object : backg;
        }
    }

    void Mean(ImagePlus imp, int radius, double par1, double par2, boolean doIwhite) {
        int backg;
        int object;
        ImageProcessor ip = imp.getProcessor();
        int c_value = 0;
        if (par1 != 0.0) {
            if (IJ.debugMode) {
                IJ.log((String)("Mean: changed c_value from :" + c_value + "  to:" + par1));
            }
            c_value = (int)par1;
        }
        if (doIwhite) {
            object = -1;
            backg = 0;
        } else {
            object = 0;
            backg = -1;
        }
        ImagePlus Meanimp = this.duplicateImage(ip);
        ImageConverter ic = new ImageConverter(Meanimp);
        ic.convertToGray32();
        ImageProcessor ipMean = Meanimp.getProcessor();
        RankFilters rf = new RankFilters();
        rf.rank(ipMean, (double)radius, 0);
        byte[] pixels = (byte[])ip.getPixels();
        float[] mean = (float[])ipMean.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = (pixels[i] & 0xFF) > (int)(mean[i] - (float)c_value) ? object : backg;
        }
    }

    void Median(ImagePlus imp, int radius, double par1, double par2, boolean doIwhite) {
        int backg;
        int object;
        ImageProcessor ip = imp.getProcessor();
        int c_value = 0;
        if (par1 != 0.0) {
            if (IJ.debugMode) {
                IJ.log((String)("Median: changed c_value from :" + c_value + "  to:" + par1));
            }
            c_value = (int)par1;
        }
        if (doIwhite) {
            object = -1;
            backg = 0;
        } else {
            object = 0;
            backg = -1;
        }
        ImagePlus Medianimp = this.duplicateImage(ip);
        ImageProcessor ipMedian = Medianimp.getProcessor();
        RankFilters rf = new RankFilters();
        rf.rank(ipMedian, (double)radius, 4);
        byte[] pixels = (byte[])ip.getPixels();
        byte[] median = (byte[])ipMedian.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = (pixels[i] & 0xFF) > (median[i] & 0xFF) - c_value ? object : backg;
        }
    }

    void MidGrey(ImagePlus imp, int radius, double par1, double par2, boolean doIwhite) {
        int backg;
        int object;
        ImageProcessor ip = imp.getProcessor();
        int c_value = 0;
        if (par1 != 0.0) {
            if (IJ.debugMode) {
                IJ.log((String)("MidGrey: changed c_value from :" + c_value + "  to:" + par1));
            }
            c_value = (int)par1;
        }
        if (doIwhite) {
            object = -1;
            backg = 0;
        } else {
            object = 0;
            backg = -1;
        }
        ImagePlus Maximp = this.duplicateImage(ip);
        ImageProcessor ipMax = Maximp.getProcessor();
        RankFilters rf = new RankFilters();
        rf.rank(ipMax, (double)radius, 2);
        ImagePlus Minimp = this.duplicateImage(ip);
        ImageProcessor ipMin = Minimp.getProcessor();
        rf.rank(ipMin, (double)radius, 1);
        byte[] pixels = (byte[])ip.getPixels();
        byte[] max = (byte[])ipMax.getPixels();
        byte[] min = (byte[])ipMin.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = (pixels[i] & 0xFF) > ((max[i] & 0xFF) + (min[i] & 0xFF)) / 2 - c_value ? object : backg;
        }
    }

    void Niblack(ImagePlus imp, int radius, double par1, double par2, boolean doIwhite) {
        int backg;
        int object;
        double k_value;
        ImageProcessor ip = imp.getProcessor();
        int c_value = 0;
        if (doIwhite) {
            k_value = 0.2;
            object = -1;
            backg = 0;
        } else {
            k_value = -0.2;
            object = 0;
            backg = -1;
        }
        if (par1 != 0.0) {
            if (IJ.debugMode) {
                IJ.log((String)("Niblack: changed k_value from :" + k_value + "  to:" + par1));
            }
            k_value = par1;
        }
        if (par2 != 0.0) {
            if (IJ.debugMode) {
                IJ.log((String)("Niblack: changed c_value from :" + c_value + "  to:" + par2));
            }
            c_value = (int)par2;
        }
        ImagePlus Meanimp = this.duplicateImage(ip);
        ImageConverter ic = new ImageConverter(Meanimp);
        ic.convertToGray32();
        ImageProcessor ipMean = Meanimp.getProcessor();
        RankFilters rf = new RankFilters();
        rf.rank(ipMean, (double)radius, 0);
        ImagePlus Varimp = this.duplicateImage(ip);
        ic = new ImageConverter(Varimp);
        ic.convertToGray32();
        ImageProcessor ipVar = Varimp.getProcessor();
        rf.rank(ipVar, (double)radius, 3);
        byte[] pixels = (byte[])ip.getPixels();
        float[] mean = (float[])ipMean.getPixels();
        float[] var = (float[])ipVar.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = (pixels[i] & 0xFF) > (int)((double)mean[i] + k_value * Math.sqrt(var[i]) - (double)c_value) ? object : backg;
        }
    }

    void Otsu(ImagePlus imp, int radius, double par1, double par2, boolean doIwhite) {
        int position;
        int backg;
        int object;
        int w = imp.getWidth();
        int h = imp.getHeight();
        int radiusx2 = radius * 2;
        ImageProcessor ip = imp.getProcessor();
        byte[] pixels = (byte[])ip.getPixels();
        byte[] pixelsOut = new byte[pixels.length];
        if (doIwhite) {
            object = -1;
            backg = 0;
        } else {
            object = 0;
            backg = -1;
        }
        int L = 256;
        double[] cnh = new double[L];
        double[] mean = new double[L];
        double[] histo = new double[L];
        OvalRoi roi = new OvalRoi(0, 0, radiusx2, radiusx2);
        for (int y = 0; y < h; ++y) {
            IJ.showProgress((double)((double)y / (double)(h - 1)));
            int roiy = y - radius;
            for (int x = 0; x < w; ++x) {
                int ih;
                roi.setLocation(x - radius, roiy);
                ip.setRoi((Roi)roi);
                position = x + y * w;
                int[] data = ip.getHistogram();
                int num_pixels = 0;
                for (ih = 0; ih < L; ++ih) {
                    num_pixels += data[ih];
                }
                double term = 1.0 / (double)num_pixels;
                for (ih = 0; ih < L; ++ih) {
                    histo[ih] = term * (double)data[ih];
                }
                cnh[0] = histo[0];
                for (ih = 1; ih < L; ++ih) {
                    cnh[ih] = cnh[ih - 1] + histo[ih];
                }
                mean[0] = 0.0;
                for (ih = 1; ih < L; ++ih) {
                    mean[ih] = mean[ih - 1] + (double)ih * histo[ih];
                }
                double total_mean = mean[L - 1];
                int threshold = 0;
                double max_bcv = 0.0;
                for (ih = 0; ih < L; ++ih) {
                    double bcv = total_mean * cnh[ih] - mean[ih];
                    if (!(max_bcv < (bcv *= bcv / (cnh[ih] * (1.0 - cnh[ih]))))) continue;
                    max_bcv = bcv;
                    threshold = ih;
                }
                pixelsOut[position] = (pixels[position] & 0xFF) > threshold || (pixels[position] & 0xFF) == 255 ? object : backg;
            }
        }
        for (position = 0; position < w * h; ++position) {
            pixels[position] = pixelsOut[position];
        }
    }

    void Phansalkar(ImagePlus imp, int radius, double par1, double par2, boolean doIwhite) {
        int backg;
        int object;
        ImageProcessor ip = imp.getProcessor();
        double k_value = 0.25;
        double r_value = 0.5;
        double p_value = 2.0;
        double q_value = 10.0;
        if (par1 != 0.0) {
            if (IJ.debugMode) {
                IJ.log((String)("Phansalkar: changed k_value from :" + k_value + "  to:" + par1));
            }
            k_value = par1;
        }
        if (par2 != 0.0) {
            if (IJ.debugMode) {
                IJ.log((String)("Phansalkar: changed r_value from :" + r_value + "  to:" + par2));
            }
            r_value = par2;
        }
        if (doIwhite) {
            object = -1;
            backg = 0;
        } else {
            object = 0;
            backg = -1;
        }
        ImagePlus Meanimp = this.duplicateImage(ip);
        ContrastEnhancer ce = new ContrastEnhancer();
        ce.setNormalize(true);
        ce.stretchHistogram(Meanimp, 0.0);
        ImageConverter ic = new ImageConverter(Meanimp);
        ic.convertToGray32();
        ImageProcessor ipMean = Meanimp.getProcessor();
        ipMean.multiply(0.00392156862745098);
        ImagePlus Orimp = this.duplicateImage(ip);
        ce.stretchHistogram(Orimp, 0.0);
        ic = new ImageConverter(Orimp);
        ic.convertToGray32();
        ImageProcessor ipOri = Orimp.getProcessor();
        ipOri.multiply(0.00392156862745098);
        RankFilters rf = new RankFilters();
        rf.rank(ipMean, (double)radius, 0);
        ImagePlus Varimp = this.duplicateImage(ip);
        ce.stretchHistogram(Varimp, 0.0);
        ic = new ImageConverter(Varimp);
        ic.convertToGray32();
        ImageProcessor ipVar = Varimp.getProcessor();
        ipVar.multiply(0.00392156862745098);
        rf.rank(ipVar, (double)radius, 3);
        ipVar.sqrt();
        byte[] pixels = (byte[])ip.getPixels();
        float[] ori = (float[])ipOri.getPixels();
        float[] mean = (float[])ipMean.getPixels();
        float[] sd = (float[])ipVar.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = (double)ori[i] > (double)mean[i] * (1.0 + p_value * Math.exp(-q_value * (double)mean[i]) + k_value * ((double)sd[i] / r_value - 1.0)) ? object : backg;
        }
    }

    void Sauvola(ImagePlus imp, int radius, double par1, double par2, boolean doIwhite) {
        int backg;
        int object;
        ImageProcessor ip = imp.getProcessor();
        double k_value = 0.5;
        double r_value = 128.0;
        if (par1 != 0.0) {
            if (IJ.debugMode) {
                IJ.log((String)("Sauvola: changed k_value from :" + k_value + "  to:" + par1));
            }
            k_value = par1;
        }
        if (par2 != 0.0) {
            if (IJ.debugMode) {
                IJ.log((String)("Sauvola: changed r_value from :" + r_value + "  to:" + par2));
            }
            r_value = par2;
        }
        if (doIwhite) {
            object = -1;
            backg = 0;
        } else {
            object = 0;
            backg = -1;
        }
        ImagePlus Meanimp = this.duplicateImage(ip);
        ImageConverter ic = new ImageConverter(Meanimp);
        ic.convertToGray32();
        ImageProcessor ipMean = Meanimp.getProcessor();
        RankFilters rf = new RankFilters();
        rf.rank(ipMean, (double)radius, 0);
        ImagePlus Varimp = this.duplicateImage(ip);
        ic = new ImageConverter(Varimp);
        ic.convertToGray32();
        ImageProcessor ipVar = Varimp.getProcessor();
        rf.rank(ipVar, (double)radius, 3);
        byte[] pixels = (byte[])ip.getPixels();
        float[] mean = (float[])ipMean.getPixels();
        float[] var = (float[])ipVar.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = (pixels[i] & 0xFF) > (int)((double)mean[i] * (1.0 + k_value * (Math.sqrt(var[i]) / r_value - 1.0))) ? object : backg;
        }
    }

    private ImagePlus duplicateImage(ImageProcessor iProcessor) {
        int w = iProcessor.getWidth();
        int h = iProcessor.getHeight();
        ImagePlus iPlus = NewImage.createByteImage((String)"Image", (int)w, (int)h, (int)1, (int)1);
        ImageProcessor imageProcessor = iPlus.getProcessor();
        imageProcessor.copyBits(iProcessor, 0, 0, 0);
        return iPlus;
    }
}

