/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.vaa3d.reader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.janelia.vaa3d.reader.PbdInputStream;

public class Pbd8InputStream
extends PbdInputStream {
    private final byte mask = (byte)3;
    private byte decompressionPrior = 0;
    private byte repeatValue = 0;
    private byte[] differenceGroup = new byte[4];
    private int dgPos = 0;
    private int fillNumber = 0;

    protected Pbd8InputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len < 1) {
            return 0;
        }
        ByteBuffer out = ByteBuffer.wrap(b, off, len);
        block0: while (out.hasRemaining()) {
            if (this.state == PbdInputStream.State.STATE_BEGIN) {
                int value = this.in.read();
                assert (value >= 0);
                if (value < 33) {
                    this.state = PbdInputStream.State.STATE_LITERAL;
                    this.leftToFill = value + 1;
                    continue;
                }
                if (value < 128) {
                    this.state = PbdInputStream.State.STATE_DIFFERENCE;
                    this.leftToFill = value - 32;
                    continue;
                }
                this.state = PbdInputStream.State.STATE_REPEAT;
                this.leftToFill = value - 127;
                this.repeatValue = (byte)this.in.read();
                continue;
            }
            if (this.state == PbdInputStream.State.STATE_LITERAL) {
                int numBytesToRead = Math.min(out.remaining(), this.leftToFill);
                this.in.read(out.array(), off + out.position(), numBytesToRead);
                out.position(out.position() + numBytesToRead);
                this.leftToFill -= numBytesToRead;
                if (this.leftToFill == 0) {
                    this.state = PbdInputStream.State.STATE_BEGIN;
                    this.leftToFill = 1;
                }
                this.decompressionPrior = out.get(out.position() - 1);
                continue;
            }
            if (this.state == PbdInputStream.State.STATE_DIFFERENCE) {
                while (this.leftToFill > 0 && out.hasRemaining()) {
                    this.fillNumber = this.leftToFill < 4 ? this.leftToFill : 4;
                    byte sourceChar = (byte)this.in.read();
                    byte p0 = (byte)(sourceChar & 3);
                    sourceChar = (byte)(sourceChar >>> 2);
                    byte p1 = (byte)(sourceChar & 3);
                    sourceChar = (byte)(sourceChar >>> 2);
                    byte p2 = (byte)(sourceChar & 3);
                    sourceChar = (byte)(sourceChar >>> 2);
                    byte p3 = (byte)(sourceChar & 3);
                    byte[] pv = this.differenceGroup;
                    pv[0] = (byte)((p0 == 3 ? -1 : (int)p0) + this.decompressionPrior);
                    pv[1] = (byte)(pv[0] + (p1 == 3 ? -1 : (int)p1));
                    pv[2] = (byte)((p2 == 3 ? -1 : (int)p2) + pv[1]);
                    pv[3] = (byte)((p3 == 3 ? -1 : (int)p3) + pv[2]);
                    this.dgPos = 0;
                    while (this.dgPos < this.fillNumber) {
                        if (out.hasRemaining()) {
                            out.put(pv[this.dgPos++]);
                            --this.leftToFill;
                            continue;
                        }
                        this.state = PbdInputStream.State.STATE_DIFFERENCE_SUBPIXEL;
                        break;
                    }
                    this.decompressionPrior = out.get(out.position() - 1);
                }
                if (this.leftToFill >= 1) continue;
                this.state = PbdInputStream.State.STATE_BEGIN;
                continue;
            }
            if (this.state == PbdInputStream.State.STATE_DIFFERENCE_SUBPIXEL) {
                this.state = PbdInputStream.State.STATE_DIFFERENCE;
                byte[] pv = this.differenceGroup;
                while (this.dgPos < this.fillNumber) {
                    if (out.hasRemaining()) {
                        out.put(pv[this.dgPos++]);
                        --this.leftToFill;
                        continue;
                    }
                    this.state = PbdInputStream.State.STATE_DIFFERENCE_SUBPIXEL;
                    continue block0;
                }
                continue;
            }
            if (this.state == PbdInputStream.State.STATE_REPEAT) {
                int repeatCount = Math.min(this.leftToFill, out.remaining());
                for (int j = 0; j < repeatCount; ++j) {
                    out.put(this.repeatValue);
                }
                this.leftToFill -= repeatCount;
                if (this.leftToFill < 1) {
                    this.state = PbdInputStream.State.STATE_BEGIN;
                }
                this.decompressionPrior = this.repeatValue;
                continue;
            }
            throw new IOException("Unexpected state");
        }
        return out.position();
    }
}

