/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.mdi;

import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.scijava.display.Display;
import org.scijava.display.event.window.WinActivatedEvent;
import org.scijava.display.event.window.WinClosedEvent;
import org.scijava.display.event.window.WinClosingEvent;
import org.scijava.display.event.window.WinDeactivatedEvent;
import org.scijava.display.event.window.WinDeiconifiedEvent;
import org.scijava.display.event.window.WinIconifiedEvent;
import org.scijava.display.event.window.WinOpenedEvent;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;

public class InternalFrameEventDispatcher
implements InternalFrameListener {
    private final Display<?> display;
    private final EventService eventService;

    public InternalFrameEventDispatcher(Display<?> display) {
        this.display = display;
        this.eventService = (EventService)display.getContext().getService(EventService.class);
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
        JInternalFrame window = e.getInternalFrame();
        this.eventService.publish((SciJavaEvent)new WinActivatedEvent(this.display, (Object)window));
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        JInternalFrame window = e.getInternalFrame();
        this.eventService.publish((SciJavaEvent)new WinClosedEvent(this.display, (Object)window));
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        JInternalFrame window = e.getInternalFrame();
        this.eventService.publish((SciJavaEvent)new WinClosingEvent(this.display, (Object)window));
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
        JInternalFrame window = e.getInternalFrame();
        this.eventService.publish((SciJavaEvent)new WinDeactivatedEvent(this.display, (Object)window));
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
        JInternalFrame window = e.getInternalFrame();
        this.eventService.publish((SciJavaEvent)new WinDeiconifiedEvent(this.display, (Object)window));
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
        JInternalFrame window = e.getInternalFrame();
        this.eventService.publish((SciJavaEvent)new WinIconifiedEvent(this.display, (Object)window));
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
        JInternalFrame window = e.getInternalFrame();
        this.eventService.publish((SciJavaEvent)new WinOpenedEvent(this.display, (Object)window));
    }
}

