/*
 * Decompiled with CFR 0.152.
 */
package FlowJ;

import FlowJ.FlowJFlow;
import FlowJ.FlowJMapper;
import ij.process.ImageProcessor;
import java.awt.Color;

public class FlowJQuiverMapper
extends FlowJMapper {
    public FlowJQuiverMapper(ImageProcessor impr, float[][][] flow, int axes, int maxp, int maxq, double pScaling, double qScaling, double rho) {
        super(impr, flow, axes, maxp, maxq, pScaling, qScaling, rho);
    }

    @Override
    public void pixel(int ip, int iq, int ix, int iy, double dx, double dy) {
        if (ip % (int)this.pScaling == 0 && iq % (int)this.qScaling == 0) {
            int itq;
            int itp;
            double r = Math.random();
            float[] v = this.pScaling == 1.0 && this.qScaling == 1.0 ? new float[]{this.flow[iy][ix][0], this.flow[iy][ix][1]} : FlowJQuiverMapper.bl(this.flow, ix, iy, dx, dy);
            float[] pv = FlowJFlow.polar(v);
            Color c = new Color(0, 0, 0);
            this.impr.setColor(c);
            double shiftp = (double)v[0] / this.rho * this.pScaling;
            double shiftq = (double)v[1] / this.rho * this.qScaling;
            if (shiftp >= this.pScaling) {
                shiftp -= 1.0;
            }
            if (shiftp <= -this.pScaling) {
                shiftp += 1.0;
            }
            if (shiftq >= this.qScaling) {
                shiftq -= 1.0;
            }
            if (shiftq <= -this.qScaling) {
                shiftq += 1.0;
            }
            int shiftip = (int)(shiftp + 0.5);
            int shiftiq = (int)(shiftq + 0.5);
            if (shiftip < 0) {
                itp = ip + shiftip;
            } else {
                itp = ip;
                ip -= shiftip;
            }
            if (shiftiq > 0) {
                itq = iq - shiftiq;
            } else {
                itq = iq;
                iq += shiftiq;
            }
            this.impr.moveTo(ip, iq);
            this.impr.lineTo(itp, itq);
        }
    }
}

