/*
 * Decompiled with CFR 0.152.
 */
package bijnum;

import bijnum.BIJfunctions;
import bijnum.BIJmatrix;
import ij.IJ;
import java.util.Random;

public class BIJstats {
    public static float CI95 = 1.96f;
    public static float CI99 = 2.576f;
    public static float CI99_9 = 3.39f;

    public static double getSignificanceLevel(double significance) {
        if (significance <= 0.95) {
            return CI95;
        }
        if (significance == 0.99) {
            return CI99;
        }
        return CI99_9;
    }

    public static float[][] covariance(float[][] m, boolean doShowProgress) {
        float[][] cov = new float[m.length][m.length];
        for (int j = 0; j < m.length; ++j) {
            for (int i = 0; i < m.length; ++i) {
                if (doShowProgress) {
                    IJ.showProgress((int)j, (int)m.length);
                }
                double r = 0.0;
                for (int k = 0; k < m[0].length; ++k) {
                    r += (double)(m[j][k] * m[i][k]);
                }
                cov[j][i] = (float)r;
            }
        }
        BIJmatrix.mul(cov, cov, 1.0f / (float)m.length);
        return cov;
    }

    public static int n(float[] v) {
        return v.length;
    }

    public static int n(float[] v, float[] mask) {
        int n = 0;
        for (int j = 0; j < v.length; ++j) {
            if (mask[j] == 0.0f) continue;
            ++n;
        }
        return n;
    }

    public static float avg(float[] v, float[] mask) {
        return (float)BIJstats.sum(v, mask) / (float)BIJstats.n(v, mask);
    }

    public static String getSignificanceString(double sign) {
        String s = "<unknown>";
        if (sign == (double)CI95) {
            s = "95%";
        } else if (sign == (double)CI99) {
            s = "99%";
        } else if (sign == (double)CI99_9) {
            s = "99.9%";
        }
        return s;
    }

    public static float stdev(float[] v, float[] mask) {
        double avg = BIJstats.avg(v, mask);
        double var = 0.0;
        double eps = 0.0;
        int n = 0;
        for (int j = 0; j < v.length; ++j) {
            if (mask[j] == 0.0f) continue;
            double d = (double)v[j] - avg;
            eps += d;
            var += d * d;
            ++n;
        }
        var = (var - eps * eps / (double)n) / (double)(n - 1);
        float stdev = (float)Math.sqrt(var);
        return stdev;
    }

    public static double sem(float[] v) {
        double avg = BIJstats.avg(v);
        double var = 0.0;
        double eps = 0.0;
        for (int j = 0; j < v.length; ++j) {
            double s = (double)v[j] - avg;
            eps += s;
            var += s * s;
        }
        var = (var - eps * eps / (double)v.length) / (double)(v.length - 1);
        double stdev = Math.sqrt(var);
        double sem = stdev / Math.sqrt(v.length);
        return sem;
    }

    public static double sem(float[] v, float[] mask) {
        double avg = BIJstats.avg(v, mask);
        double var = 0.0;
        double eps = 0.0;
        int n = 0;
        for (int j = 0; j < v.length; ++j) {
            if (mask[j] == 0.0f) continue;
            double d = (double)v[j] - avg;
            eps += d;
            var += d * d;
            ++n;
        }
        var = (var - eps * eps / (double)n) / (double)(n - 1);
        double stdev = Math.sqrt(var);
        double sem = (float)(stdev / Math.sqrt(n));
        return sem;
    }

    public static double sem(double estimateAB, double estimateA, double semA, double estimateB, double semB) {
        double rseA = semA / estimateA;
        double rseB = semB / estimateB;
        double rse = Math.sqrt(rseA * rseA + rseB * rseB);
        double sem = estimateAB * rse;
        return sem;
    }

    public static float avgNoExtremes(float[] v, float nrstddev) {
        double avg = BIJstats.avg(v);
        float stddev = BIJstats.stdev(v);
        float cum = 0.0f;
        int n = 0;
        for (int j = 0; j < v.length; ++j) {
            float val = v[j];
            if (!(Math.abs((double)val - avg) < (double)(nrstddev * stddev))) continue;
            cum = (float)((double)cum + (double)val);
            ++n;
        }
        return cum /= (float)n;
    }

    public static float[] meanColumnT(float[][] m) {
        int i;
        int iN = m.length;
        int iM = m[0].length;
        float[] v = new float[iM];
        for (i = 0; i < iM; ++i) {
            for (int j = 0; j < iN; ++j) {
                int n = i;
                v[n] = v[n] + m[j][i];
            }
        }
        i = 0;
        while (i < iM) {
            int n = i++;
            v[n] = v[n] / (float)iN;
        }
        return v;
    }

    public static float[] meanColumn(float[][] m) {
        int j;
        int iN = m.length;
        int iM = m[0].length;
        float[] v = new float[iM];
        for (j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                int n = j;
                v[n] = v[n] + m[j][i];
            }
        }
        j = 0;
        while (j < iN) {
            int n = j++;
            v[n] = v[n] / (float)iM;
        }
        return v;
    }

    public static double means(float[][] m) {
        int j;
        int iN = m.length;
        int iM = m[0].length;
        double v = 0.0;
        for (j = 0; j < iN; ++j) {
            for (int i = 0; i < iM; ++i) {
                v += (double)m[j][i];
            }
        }
        for (j = 0; j < iN; ++j) {
            v /= (double)(iM * iN);
        }
        return (float)v;
    }

    public static double avg(float[] v) {
        return (float)(BIJstats.sum(v) / (double)v.length);
    }

    public static double avg(float[][] m) {
        return (float)(BIJstats.sum(m) / (double)(m.length * m[0].length));
    }

    public static double avg(double[] v) {
        return (float)(BIJstats.sum(v) / (double)v.length);
    }

    public static double sum(float[] v) {
        double aggr = 0.0;
        for (int j = 0; j < v.length; ++j) {
            aggr += (double)v[j];
        }
        return aggr;
    }

    public static double sum(float[][] m) {
        double aggr = 0.0;
        for (int j = 0; j < m.length; ++j) {
            for (int i = 0; i < m[0].length; ++i) {
                aggr += (double)m[j][i];
            }
        }
        return aggr;
    }

    public static double sum(float[] v, float[] mask) {
        double agr = 0.0;
        for (int j = 0; j < v.length; ++j) {
            if (mask[j] == 0.0f) continue;
            agr += (double)v[j];
        }
        return agr;
    }

    public static double sum(double[] v) {
        double aggr = 0.0;
        for (int j = 0; j < v.length; ++j) {
            aggr += v[j];
        }
        return aggr;
    }

    public static double var(float[] v) {
        double avg = BIJstats.avg(v);
        double var = 0.0;
        double eps = 0.0;
        int n = 0;
        for (int j = 0; j < v.length; ++j) {
            double d = (double)v[j] - avg;
            eps += d;
            var += d * d;
            ++n;
        }
        var = (var - eps * eps / (double)n) / (double)(n - 1);
        return var;
    }

    public static void unitvar(float[][] m) {
        double avg = BIJstats.avg(m);
        double var = 0.0;
        double eps = 0.0;
        int n = 0;
        for (int j = 0; j < m.length; ++j) {
            for (int i = 0; i < m[0].length; ++i) {
                double d = (double)m[j][i] - avg;
                eps += d;
                var += d * d;
                ++n;
            }
        }
        var = (var - eps * eps / (double)n) / (double)(n - 1);
        double sigma = Math.sqrt(var);
        for (int j = 0; j < m.length; ++j) {
            for (int i = 0; i < m[0].length; ++i) {
                m[j][i] = (float)(((double)m[j][i] - avg) / sigma);
            }
        }
    }

    public static double var(double[] v) {
        double avg = BIJstats.avg(v);
        double var = 0.0;
        double eps = 0.0;
        int n = 0;
        for (int j = 0; j < v.length; ++j) {
            double d = v[j] - avg;
            eps += d;
            var += d * d;
            ++n;
        }
        var = (var - eps * eps / (double)n) / (double)(n - 1);
        return var;
    }

    public static float[] unitvar(float[] v) {
        float[] n = BIJstats.zeromean(v);
        double var = BIJstats.var(n);
        int j = 0;
        while (j < v.length) {
            int n2 = j++;
            n[n2] = (float)((double)n[n2] / Math.sqrt(var));
        }
        return n;
    }

    public static double[] zeromean(double[] v) {
        double[] n = new double[v.length];
        double avg = BIJstats.sum(v) / (double)v.length;
        for (int j = 0; j < v.length; ++j) {
            n[j] = v[j] - avg;
        }
        return n;
    }

    public static float[] zeromean(float[] v) {
        float[] n = new float[v.length];
        double avg = BIJstats.avg(v);
        for (int j = 0; j < v.length; ++j) {
            n[j] = (float)((double)v[j] - avg);
        }
        return n;
    }

    public static float stdev(float[] v) {
        float stdev = (float)Math.sqrt(BIJstats.var(v));
        return stdev;
    }

    public static float thresholdFraction(float[] v, double fraction) {
        return BIJstats.thresholdFraction(v, (float)fraction);
    }

    public static float thresholdFraction(float[] v, float fraction) {
        float[] minmax = BIJmatrix.minmax(v);
        float scale = (minmax[1] - minmax[0]) / 255.0f;
        int[] histogram = BIJstats.histogram(v, minmax[0], 1.0f / scale, 255);
        int bin = BIJstats.binIndex(histogram, fraction);
        return minmax[0] + (float)bin * scale;
    }

    public static int[] histogram(float[] v, float min, float d, int n) {
        int[] Pv = new int[n];
        for (int i = 0; i < v.length; ++i) {
            int ix = Math.round((v[i] - min) * d);
            if (ix < 0 || ix >= Pv.length) continue;
            int n2 = ix;
            Pv[n2] = Pv[n2] + 1;
        }
        return Pv;
    }

    public static int binIndex(int[] histogram, float fraction) {
        int total = 0;
        for (int i = 0; i < histogram.length; ++i) {
            total += histogram[i];
        }
        int aggr = 0;
        int bin = histogram.length - 1;
        while (fraction * (float)total - (float)aggr >= 0.0f) {
            aggr += histogram[bin--];
        }
        return bin;
    }

    public static float correl(float[] a, float[] b) {
        int iN = Math.min(a.length, b.length);
        double avga = BIJstats.avg(a);
        double avgb = BIJstats.avg(b);
        double agr = 0.0;
        double vara = 0.0;
        double varb = 0.0;
        for (int i = 0; i < iN; ++i) {
            agr += ((double)a[i] - avga) * ((double)b[i] - avgb);
            vara += Math.pow((double)a[i] - avga, 2.0);
            varb += Math.pow((double)b[i] - avgb, 2.0);
        }
        double r = vara == 0.0 || varb == 0.0 ? 0.0 : agr / Math.sqrt(vara * varb);
        if (Double.isNaN(r)) {
            System.out.println("NAN->" + agr + " " + vara + " " + varb);
        }
        return (float)r;
    }

    public static float[] spectrum(float[] v) {
        float[] spectrum = new float[v.length];
        double sum = BIJstats.sum(v);
        BIJmatrix.mulElements(spectrum, v, (double)((float)(1.0 / sum)));
        return spectrum;
    }

    public static double erf(double x) {
        double a1 = 0.0705230784;
        double a2 = 0.0422820123;
        double a3 = 0.0092705272;
        double a4 = 1.520143E-4;
        double a5 = 2.765672E-4;
        double a6 = 4.30638E-5;
        double xs = x * x;
        double xc = xs * x;
        return 1.0 - 1.0 / Math.pow(1.0 + a1 * x + a2 * xs + a3 * xc + a4 * xs * xs + a5 * xc * xs + a6 * xc * xc, 16.0);
    }

    public static float mse(float[] a, float[] b) throws IllegalArgumentException {
        if (a.length != b.length) {
            throw new IllegalArgumentException("mse: vectors do not match");
        }
        float[] auv = BIJstats.unitvar(a);
        float[] buv = BIJstats.unitvar(b);
        float agr = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            agr = (float)((double)agr + Math.pow(auv[i] - buv[i], 2.0));
        }
        float mse = agr / (float)a.length;
        return mse;
    }

    public static float[] residuals(float[] a, float[] b) throws IllegalArgumentException {
        float[] res = new float[Math.min(a.length, b.length)];
        for (int i = 0; i < res.length; ++i) {
            res[i] = b[i] - a[i];
        }
        return res;
    }

    public static float rmse(float[] a, float[] b) throws IllegalArgumentException {
        return (float)Math.sqrt(BIJstats.mse(a, b));
    }

    public static double ttest(float[] data1, float[] data2) {
        double ave1 = BIJstats.avg(data1);
        double ave2 = BIJstats.avg(data2);
        double var1 = BIJstats.var(data1);
        double var2 = BIJstats.var(data2);
        double df = data1.length + data2.length - 2;
        double svar = ((double)(data1.length - 1) * var1 + (double)(data2.length - 1) * var2) / df;
        double t = (ave1 - ave2) / Math.sqrt(svar * (1.0 / (double)data1.length + 1.0 / (double)data2.length));
        double prob = BIJfunctions.betai(0.5 * df, 0.5, df / (df + t * t));
        return prob;
    }

    public static double[] autocov(double[] data, int maxk) {
        double[] ac = new double[maxk];
        data = BIJstats.zeromean(data);
        data = BIJstats.linearcorrect(data);
        double mu = BIJstats.avg(data);
        for (int k = 0; k < maxk; ++k) {
            for (int t = 0; t < data.length - k; ++t) {
                int n = k;
                ac[n] = ac[n] + (data[t] - mu) * (data[t + k] - mu);
            }
            int n = k;
            ac[n] = ac[n] / (double)(data.length - k);
        }
        return ac;
    }

    protected static double[] linearcorrect(double[] data) {
        double sumx = 0.0;
        double sumy = 0.0;
        double sumxy = 0.0;
        double sumxx = 0.0;
        double sumyy = 0.0;
        for (int k = 0; k < data.length; ++k) {
            sumx += (double)k;
            sumy += data[k];
            sumxx += (double)(k * k);
            sumyy += data[k] * data[k];
            sumxy += data[k] * (double)k;
        }
        double Sxx = sumxx - sumx * sumx / (double)data.length;
        double yy = sumyy - sumy * sumy / (double)data.length;
        double Sxy = sumxy - sumx * sumy / (double)data.length;
        double b = Sxy / Sxx;
        double a = (sumy - b * sumx) / (double)data.length;
        for (int k = 0; k < data.length; ++k) {
            data[k] = data[k] - b * (double)k;
        }
        return data;
    }

    public static double[] autocorr(double[] data, int maxk) {
        double[] acov = BIJstats.autocov(data, maxk);
        double[] acorr = new double[acov.length];
        for (int k = 0; k < acov.length; ++k) {
            acorr[k] = acov[k] / acov[0];
        }
        return acorr;
    }

    public static double ttest(double[] data1, double[] data2) {
        double ave1 = BIJstats.avg(data1);
        double ave2 = BIJstats.avg(data2);
        double var1 = BIJstats.var(data1);
        double var2 = BIJstats.var(data2);
        double df = data1.length + data2.length - 2;
        double svar = ((double)(data1.length - 1) * var1 + (double)(data2.length - 1) * var2) / df;
        double t = (ave1 - ave2) / Math.sqrt(svar * (1.0 / (double)data1.length + 1.0 / (double)data2.length));
        double prob = BIJfunctions.betai(0.5 * df, 0.5, df / (df + t * t));
        return prob;
    }

    public static double tptest(double[] data1, double[] data2) {
        double ave1 = BIJstats.avg(data1);
        double ave2 = BIJstats.avg(data2);
        double var1 = BIJstats.var(data1);
        double var2 = BIJstats.var(data2);
        double cov = 0.0;
        if (data1.length != data2.length) {
            System.out.println("data1 and data2 are not paired");
            return Double.MAX_VALUE;
        }
        for (int j = 0; j < data1.length; ++j) {
            cov += (data1[j] - ave1) * (data2[j] - ave2);
        }
        double df = data1.length - 1;
        double sd = Math.sqrt(var1 + var2 - 2.0 * (cov /= df)) / (double)data1.length;
        double t = (ave1 - ave2) / sd;
        double prob = BIJfunctions.betai(0.5 * df, 0.5, df / (df + t * t));
        return prob;
    }

    public static float[] randomFraction(float[] v, double fraction) {
        int length = 1 + (int)Math.round((double)v.length * fraction);
        float[] r = new float[length];
        Random random = new Random();
        for (int i = 0; i < r.length; ++i) {
            r[i] = v[(int)((double)v.length * random.nextDouble())];
        }
        return r;
    }

    public static float[] sensitivities(float[] truth, float[] exp, int n) throws IllegalArgumentException {
        float[] s = new float[n];
        for (int c = 0; c < s.length; ++c) {
            float[] table2x2 = BIJstats.table2x2(exp, truth, c);
            s[c] = (float)BIJstats.sensitivity(table2x2);
        }
        return s;
    }

    public static float[] specificities(float[] exp, float[] truth, int n) throws IllegalArgumentException {
        float[] s = new float[n];
        for (int c = 0; c < s.length; ++c) {
            float[] table2x2 = BIJstats.table2x2(exp, truth, c);
            s[c] = (float)BIJstats.specificity(table2x2);
        }
        return s;
    }

    public static float[] table2x2(float[] obs0, float[] obs1, int c) throws IllegalArgumentException {
        if (obs0.length != obs1.length || c < 0) {
            throw new IllegalArgumentException("illegal argument in table2x2");
        }
        float[] table = new float[4];
        for (int i = 0; i < obs0.length; ++i) {
            if (obs0[i] == (float)c && obs1[i] == (float)c) {
                table[0] = table[0] + 1.0f;
                continue;
            }
            if (obs0[i] != (float)c && obs1[i] == (float)c) {
                table[1] = table[1] + 1.0f;
                continue;
            }
            if (obs0[i] == (float)c && obs1[i] != (float)c) {
                table[2] = table[2] + 1.0f;
                continue;
            }
            if (obs0[i] == (float)c || obs1[i] == (float)c) continue;
            table[3] = table[3] + 1.0f;
        }
        return table;
    }

    public static int[][] tablenxn(float[] obs0, float[] obs1, int n) throws IllegalArgumentException {
        if (obs0.length != obs1.length || n < 0) {
            throw new IllegalArgumentException("illegal argument in tablenxn");
        }
        int[][] table = new int[n][n];
        for (int i = 0; i < obs0.length; ++i) {
            int c0 = (int)obs0[i];
            int c1 = (int)obs1[i];
            int[] nArray = table[c0];
            int n2 = c1;
            nArray[n2] = nArray[n2] + 1;
        }
        return table;
    }

    public static double kappa(float[] table2x2) {
        double g1 = table2x2[0] + table2x2[1];
        double g2 = table2x2[2] + table2x2[3];
        double f1 = table2x2[0] + table2x2[2];
        double f2 = table2x2[1] + table2x2[3];
        double n = f1 + f2;
        double pObserved = (double)(table2x2[0] + table2x2[3]) / n;
        double pExpected = (f1 * g1 + f2 * g2) / (n * n);
        double kappa = (pObserved - pExpected) / (1.0 - pExpected);
        return kappa;
    }

    public static double accuracyMultipleClasses(float[] exp, float[] truth, int n) throws IllegalArgumentException {
        if (exp.length != truth.length) {
            throw new IllegalArgumentException("accuracy: " + exp.length + "!=" + truth.length);
        }
        int nom = 0;
        int denom = 0;
        for (int i = 0; i < exp.length; ++i) {
            ++denom;
            if (truth[i] != exp[i]) continue;
            ++nom;
        }
        return nom / denom;
    }

    public static double sensitivity(float[] table2x2) throws IllegalArgumentException {
        return table2x2[0] / (table2x2[0] + table2x2[2]);
    }

    public static double specificity(float[] table2x2) throws IllegalArgumentException {
        return table2x2[3] / (table2x2[1] + table2x2[3]);
    }

    public static double accuracy(float[] table2x2) throws IllegalArgumentException {
        return (table2x2[0] + table2x2[3]) / (table2x2[0] + table2x2[1] + table2x2[2] + table2x2[3]);
    }

    public static double accuracyMultipleClasses(int[][] tablenxn) throws IllegalArgumentException {
        double nom = 0.0;
        double denom = 0.0;
        for (int j = 0; j < tablenxn.length; ++j) {
            for (int i = 0; i < tablenxn[0].length; ++i) {
                if (i == j) {
                    nom += (double)tablenxn[i][j];
                }
                denom += (double)tablenxn[i][j];
            }
        }
        return nom / denom;
    }
}

