/*
 * Decompiled with CFR 0.152.
 */
package bijnum;

import bijnum.BIJmatrix;

public class BIJtransform {
    public static float[][] newMatrix(int dimensions) {
        float[][] m = new float[dimensions + 1][dimensions + 1];
        for (int j = 0; j < m.length; ++j) {
            for (int i = 0; i < m[0].length; ++i) {
                m[j][i] = i == j ? 1.0f : 0.0f;
            }
        }
        return m;
    }

    public static float[][] translate(float[][] m, double tx, double ty, double tz) {
        float[][] nm = new float[m.length][m[0].length];
        nm[0][0] = 1.0f;
        nm[1][1] = 1.0f;
        nm[2][2] = 1.0f;
        nm[3][3] = 1.0f;
        nm[0][3] = (float)tx;
        nm[1][3] = (float)ty;
        nm[2][3] = (float)tz;
        return BIJmatrix.mul(m, nm);
    }

    public static float[][] translate(float[][] m, double tx, double ty) {
        float[][] nm = new float[m.length][m[0].length];
        nm[0][0] = 1.0f;
        nm[1][1] = 1.0f;
        nm[2][2] = 1.0f;
        nm[0][2] = (float)tx;
        nm[1][2] = (float)ty;
        return BIJmatrix.mul(m, nm);
    }

    public static float[][] scale(float[][] m, double sx, double sy, double sz) {
        float[][] nm = new float[m.length][m[0].length];
        nm[3][3] = 1.0f;
        nm[0][0] = (float)sx;
        nm[1][1] = (float)sy;
        nm[2][2] = (float)sz;
        return BIJmatrix.mul(m, nm);
    }

    public static float[][] scale(float[][] m, double sx, double sy) {
        float[][] nm = new float[m.length][m[0].length];
        nm[2][2] = 1.0f;
        nm[0][0] = (float)sx;
        nm[1][1] = (float)sy;
        return BIJmatrix.mul(m, nm);
    }

    public static float[][] rotatex(float[][] m, double theta) {
        double d_theta = theta * Math.PI / 180.0;
        double sin_theta = BIJtransform.clean(Math.sin(d_theta));
        double cos_theta = BIJtransform.clean(Math.cos(d_theta));
        float[][] nm = new float[m.length][m[0].length];
        nm[0][0] = 1.0f;
        nm[3][3] = 1.0f;
        nm[1][1] = (float)cos_theta;
        nm[2][1] = (float)sin_theta;
        nm[1][2] = (float)(-sin_theta);
        nm[2][2] = (float)cos_theta;
        return BIJmatrix.mul(m, nm);
    }

    public static float[][] rotatey(float[][] m, double theta) {
        double d_theta = theta * Math.PI / 180.0;
        double sin_theta = BIJtransform.clean(Math.sin(d_theta));
        double cos_theta = BIJtransform.clean(Math.cos(d_theta));
        float[][] nm = new float[m.length][m[0].length];
        nm[1][1] = 1.0f;
        nm[3][3] = 1.0f;
        nm[0][0] = (float)cos_theta;
        nm[2][0] = (float)(-sin_theta);
        nm[0][2] = (float)sin_theta;
        nm[2][2] = (float)cos_theta;
        return BIJmatrix.mul(m, nm);
    }

    public static float[][] rotatez(float[][] m, double theta) {
        double d_theta = theta * Math.PI / 180.0;
        double sin_theta = BIJtransform.clean(Math.sin(d_theta));
        double cos_theta = BIJtransform.clean(Math.cos(d_theta));
        float[][] nm = new float[m.length][m[0].length];
        if (nm.length > 3) {
            nm[3][3] = 1.0f;
        }
        nm[2][2] = 1.0f;
        nm[0][0] = (float)cos_theta;
        nm[1][0] = (float)sin_theta;
        nm[0][1] = (float)(-sin_theta);
        nm[1][1] = (float)cos_theta;
        return BIJmatrix.mul(m, nm);
    }

    protected static double clean(double d) {
        return Math.abs(d) < 1.0E-8 ? 0.0 : d;
    }
}

