/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.universe;

import org.jogamp.java3d.Sensor;
import org.jogamp.java3d.utils.universe.ConfigCommand;
import org.jogamp.java3d.utils.universe.ConfigDevice;
import org.jogamp.java3d.utils.universe.ConfigObject;
import org.jogamp.vecmath.Point3d;

class ConfigSensor
extends ConfigObject {
    private int sensorIndex;
    private ConfigDevice configDevice;
    private Point3d hotspot = null;
    private int predictor = -1;
    private int predictionPolicy = -1;
    private int sensorReadCount = -1;
    Sensor j3dSensor;

    ConfigSensor() {
    }

    @Override
    protected void initialize(ConfigCommand command) {
        int argc = command.argc;
        Object[] argv = command.argv;
        if (argc != 4) {
            this.syntaxError("Incorrect number of arguments to " + command.commandName);
        }
        if (!this.isName(argv[2])) {
            this.syntaxError("The second argument to " + command.commandName + " must be the device name");
        }
        if (!(argv[3] instanceof Double)) {
            this.syntaxError("The third argument to " + command.commandName + " must be a sensor index");
        }
        this.sensorIndex = ((Double)argv[3]).intValue();
        this.configDevice = (ConfigDevice)this.configContainer.findConfigObject("Device", (String)argv[2]);
    }

    @Override
    protected void setProperty(ConfigCommand command) {
        String attribute;
        int argc = command.argc;
        Object[] argv = command.argv;
        if (argc != 4) {
            this.syntaxError("Incorrect number of arguments to " + command.commandName);
        }
        if (!this.isName(argv[1])) {
            this.syntaxError("The first argument to " + command.commandName + " must be the instance name");
        }
        if (!this.isName(argv[2])) {
            this.syntaxError("The second argument to " + command.commandName + " must be a property name");
        }
        if ((attribute = (String)argv[2]).equals("Hotspot")) {
            if (!(argv[3] instanceof Point3d)) {
                this.syntaxError("Hotspot must be a 3D point");
            }
            this.hotspot = (Point3d)argv[3];
        } else {
            this.syntaxError("Unknown " + command.commandName + " \"" + attribute + "\"");
        }
    }

    void configureSensor() {
        this.j3dSensor = this.configDevice.j3dInputDevice.getSensor(this.sensorIndex);
        if (this.hotspot != null) {
            this.j3dSensor.setHotspot(this.hotspot);
        }
        if (this.predictor != -1) {
            this.j3dSensor.setPredictor(this.predictor);
        }
        if (this.predictionPolicy != -1) {
            this.j3dSensor.setPredictionPolicy(this.predictionPolicy);
        }
        if (this.sensorReadCount != -1) {
            this.j3dSensor.setSensorReadCount(this.sensorReadCount);
        }
    }
}

