/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector;

import ij.gui.Plot;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.imglib2.RealPoint;

public class GeometryUtils {
    public static RealPoint add(RealPoint point1, RealPoint point2) {
        RealPoint point = new RealPoint(point1.numDimensions());
        for (int d = 0; d < point1.numDimensions(); ++d) {
            point.setPosition(point1.getDoublePosition(d) + point2.getDoublePosition(d), d);
        }
        return point;
    }

    public static RealPoint subtract(RealPoint point1, RealPoint point2) {
        RealPoint point = new RealPoint(point1.numDimensions());
        for (int d = 0; d < point1.numDimensions(); ++d) {
            point.setPosition(point1.getDoublePosition(d) - point2.getDoublePosition(d), d);
        }
        return point;
    }

    public static double distance(RealPoint point1, RealPoint point2) {
        double sum = 0.0;
        for (int d = 0; d < point1.numDimensions(); ++d) {
            sum += Math.pow(point1.getDoublePosition(d) - point2.getDoublePosition(d), 2.0);
        }
        return Math.sqrt(sum);
    }

    public static List<RealPoint> getLinePointsFromNumberOfPoints(RealPoint start, RealPoint end, int numPts) {
        ArrayList<RealPoint> line = new ArrayList<RealPoint>();
        for (int i = 0; i < numPts; ++i) {
            double x = (double)i * (end.getDoublePosition(0) - start.getDoublePosition(0)) / (double)(numPts - 1) + start.getDoublePosition(0);
            double y = (double)i * (end.getDoublePosition(1) - start.getDoublePosition(1)) / (double)(numPts - 1) + start.getDoublePosition(1);
            line.add(new RealPoint(new double[]{x, y}));
        }
        return line;
    }

    public static List<RealPoint> getLinePointsFromSpacing(RealPoint start, RealPoint end, double spacing) {
        ArrayList<RealPoint> line = new ArrayList<RealPoint>();
        double dist = GeometryUtils.distance(start, end);
        long nPoints = (long)(dist / spacing);
        line.add(start);
        for (long i = 1L; i <= nPoints; ++i) {
            line.add(GeometryUtils.getPointOnVectorFromDistance(start, end, spacing * (double)i));
        }
        line.add(end);
        return line;
    }

    public static RealPoint getPointOnVectorFromDistance(RealPoint start, RealPoint end, double distance) {
        double distRatio = distance / Math.sqrt(Math.pow(start.getDoublePosition(0) - end.getDoublePosition(0), 2.0) + Math.pow(start.getDoublePosition(1) - end.getDoublePosition(1), 2.0));
        double x = (1.0 - distRatio) * start.getDoublePosition(0) + distRatio * end.getDoublePosition(0);
        double y = (1.0 - distRatio) * start.getDoublePosition(1) + distRatio * end.getDoublePosition(1);
        return new RealPoint(new double[]{x, y});
    }

    public static float[] getPointOnVectorFromDistance(float[] start, float[] end, double distance) {
        float distRatio = (float)(distance / Math.sqrt(Math.pow(start[0] - end[0], 2.0) + Math.pow(start[1] - end[1], 2.0)));
        float x = (1.0f - distRatio) * start[0] + distRatio * end[0];
        float y = (1.0f - distRatio) * start[1] + distRatio * end[1];
        return new float[]{x, y};
    }

    public static double[] getPointOnVectorFromDistance(double[] start, double[] end, double distance) {
        double distRatio = distance / Math.sqrt(Math.pow(start[0] - end[0], 2.0) + Math.pow(start[1] - end[1], 2.0));
        double x = (1.0 - distRatio) * start[0] + distRatio * end[0];
        double y = (1.0 - distRatio) * start[1] + distRatio * end[1];
        return new double[]{x, y};
    }

    public static Plot plotPoints(double[] y) {
        double[] x = IntStream.range(0, y.length).mapToDouble(i -> i).toArray();
        return GeometryUtils.plotPoints(x, y);
    }

    public static Plot plotPoints(double[] x, double[] y) {
        List<RealPoint> points = IntStream.range(0, x.length).mapToObj(i -> new RealPoint(new double[]{x[i], y[i]})).collect(Collectors.toList());
        return GeometryUtils.plotPoints(points);
    }

    public static Plot plotPoints(List<RealPoint> points) {
        double[] x = points.stream().mapToDouble(p -> p.getDoublePosition(0)).toArray();
        double[] y = points.stream().mapToDouble(p -> p.getDoublePosition(1)).toArray();
        Plot plot = new Plot("", "x", "y", x, y);
        plot.show();
        return plot;
    }

    public static List<List<RealPoint>> getParallelLines(List<RealPoint> middleLine, double thickness, double spacing) {
        ArrayList<List<RealPoint>> lines = new ArrayList<List<RealPoint>>();
        lines.add(middleLine);
        double xN = (middleLine.get(middleLine.size() - 1).getDoublePosition(1) - middleLine.get(0).getDoublePosition(1)) * -1.0;
        double yN = middleLine.get(middleLine.size() - 1).getDoublePosition(0) - middleLine.get(0).getDoublePosition(0);
        RealPoint normalVector1 = new RealPoint(new double[]{xN, yN});
        xN = middleLine.get(middleLine.size() - 1).getDoublePosition(1) - middleLine.get(0).getDoublePosition(1);
        yN = (middleLine.get(middleLine.size() - 1).getDoublePosition(0) - middleLine.get(0).getDoublePosition(0)) * -1.0;
        RealPoint normalVector2 = new RealPoint(new double[]{xN, yN});
        for (int i = 1; i < (int)(thickness / 2.0) + 1; ++i) {
            double dist = spacing * (double)i;
            RealPoint p1 = GeometryUtils.getPointOnVectorFromDistance(middleLine.get(0), GeometryUtils.add(middleLine.get(0), normalVector1), dist);
            RealPoint p2 = GeometryUtils.getPointOnVectorFromDistance(middleLine.get(middleLine.size() - 1), GeometryUtils.add(middleLine.get(middleLine.size() - 1), normalVector1), dist);
            List<RealPoint> line = GeometryUtils.getLinePointsFromSpacing(p1, p2, spacing);
            lines.add(line);
            p1 = GeometryUtils.getPointOnVectorFromDistance(middleLine.get(0), GeometryUtils.add(middleLine.get(0), normalVector2), dist);
            p2 = GeometryUtils.getPointOnVectorFromDistance(middleLine.get(middleLine.size() - 1), GeometryUtils.add(middleLine.get(middleLine.size() - 1), normalVector2), dist);
            line = GeometryUtils.getLinePointsFromSpacing(p1, p2, spacing);
            lines.add(line);
        }
        return lines;
    }
}

