/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.view;

import java.text.DecimalFormat;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.event.FilamentSelectedEvent;
import sc.fiji.filamentdetector.gui.GUIUtils;
import sc.fiji.filamentdetector.gui.controller.DetailedFilamentController;
import sc.fiji.filamentdetector.gui.model.FilamentModel;
import sc.fiji.filamentdetector.model.Filament;
import sc.fiji.filamentdetector.model.Filaments;
import sc.fiji.filamentdetector.overlay.FilamentOverlayService;

public class FilamentsTableView
extends TableView<FilamentModel> {
    @Parameter
    FilamentOverlayService overlayService;
    @Parameter
    private LogService log;
    @Parameter
    private StatusService status;
    @Parameter
    private EventService eventService;
    private DecimalFormat formatter;
    private AnchorPane detailPane;
    private Filaments filaments;
    private Label nFilamentsField;
    private Pane infoPane;

    public FilamentsTableView(Context context, Filaments filaments) {
        context.inject((Object)this);
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        TableColumn idColumn = new TableColumn("ID");
        TableColumn lengthColumn = new TableColumn("Length");
        TableColumn frameColumn = new TableColumn("Frame");
        TableColumn colorColumn = new TableColumn("Color");
        this.getColumns().add((Object)idColumn);
        this.getColumns().add((Object)lengthColumn);
        this.getColumns().add((Object)frameColumn);
        this.getColumns().add((Object)colorColumn);
        idColumn.setStyle("-fx-alignment: CENTER;");
        lengthColumn.setStyle("-fx-alignment: CENTER;");
        frameColumn.setStyle("-fx-alignment: CENTER;");
        colorColumn.setStyle("-fx-alignment: CENTER;");
        idColumn.setCellValueFactory(cellData -> ((FilamentModel)cellData.getValue()).getId().asObject());
        lengthColumn.setCellValueFactory(cellData -> ((FilamentModel)cellData.getValue()).getLength().asObject());
        frameColumn.setCellValueFactory(cellData -> ((FilamentModel)cellData.getValue()).getFrame().asObject());
        colorColumn.setCellValueFactory(cellData -> ((FilamentModel)cellData.getValue()).getColor());
        this.formatter = new DecimalFormat("#0.00");
        lengthColumn.setCellFactory(column -> new TableCell<FilamentModel, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(FilamentsTableView.this.formatter.format(item));
                }
            }
        });
        colorColumn.setCellFactory(column -> new TableCell<FilamentModel, String>(){

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                    this.setStyle("-fx-background-color: none");
                } else {
                    this.setText(" ");
                    this.setStyle("-fx-background-color:" + item);
                }
            }
        });
        this.detailPane = new AnchorPane(new Node[]{this});
        AnchorPane.setTopAnchor((Node)this.detailPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.detailPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.detailPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.detailPane, (Double)0.0);
        this.detailPane.setPrefHeight(-1.0);
        this.detailPane.setPrefWidth(-1.0);
        this.setNoDetail();
        this.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            ObservableList filamentModels = this.getSelectionModel().getSelectedItems();
            if (filamentModels.size() == 1 && oldSelection != newSelection) {
                this.overlayService.setSelected(newSelection.getFilament(), true, true);
                DetailedFilamentController controller = new DetailedFilamentController(newSelection.getFilament());
                Pane pane = GUIUtils.loadFXML("/sc/fiji/filamentdetector/gui/view/detection/DetailedFilamentView.fxml", controller);
                this.detailPane.getChildren().clear();
                this.detailPane.getChildren().add((Object)pane);
                AnchorPane.setTopAnchor((Node)pane, (Double)0.0);
                AnchorPane.setLeftAnchor((Node)pane, (Double)0.0);
                AnchorPane.setRightAnchor((Node)pane, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)pane, (Double)0.0);
                pane.setPrefHeight(-1.0);
                pane.setPrefWidth(-1.0);
                controller.getRemoveFilamentLabel().setOnAction(event -> this.removeFilament(controller.getFilament()));
            } else if (filamentModels.size() > 1) {
                this.setMultipleSelectionDetail();
            } else {
                this.setNoDetail();
            }
        });
        this.eventService.subscribe((Object)this);
        this.infoPane = new Pane();
        this.infoPane.setMinHeight(25.0);
        VBox vbox = new VBox();
        vbox.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        vbox.setSpacing(3.0);
        this.nFilamentsField = new Label("");
        vbox.getChildren().add((Object)this.nFilamentsField);
        this.infoPane.getChildren().add((Object)vbox);
        this.setFilaments(filaments);
    }

    public Filaments getFilaments() {
        return this.filaments;
    }

    public void setFilaments(Filaments filaments) {
        this.filaments = filaments;
        ObservableList filamentModelList = FXCollections.observableArrayList();
        for (Filament filament : filaments) {
            filamentModelList.add((Object)new FilamentModel(filament));
        }
        this.setItems(filamentModelList);
        this.overlayService.reset();
        this.overlayService.add(filaments);
        this.updateNFilamentsField();
    }

    public void addFilament(Filament filament) {
        this.getItems().add((Object)new FilamentModel(filament));
        this.filaments.add(filament);
        this.overlayService.add(filament);
        this.updateNFilamentsField();
    }

    public Pane getDetailPane() {
        return this.detailPane;
    }

    private void setNoDetail() {
        Label noDetail = new Label("No filament selected.");
        this.detailPane.getChildren().clear();
        this.detailPane.getChildren().add((Object)noDetail);
    }

    private void setMultipleSelectionDetail() {
        ObservableList filamentModels = this.getSelectionModel().getSelectedItems();
        for (FilamentModel filamentModel : filamentModels) {
            this.overlayService.setSelected(filamentModel.getFilament(), true, false);
        }
        VBox vbox = new VBox();
        vbox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        vbox.setSpacing(10.0);
        Label label = new Label(filamentModels.size() + " filaments selected.");
        Button button = new Button("Delete Filaments");
        button.setOnAction(event -> {
            this.removeFilaments((List<FilamentModel>)this.getSelectionModel().getSelectedItems());
            this.getSelectionModel().clearSelection();
        });
        vbox.getChildren().add((Object)label);
        vbox.getChildren().add((Object)button);
        this.detailPane.getChildren().clear();
        this.detailPane.getChildren().add((Object)vbox);
    }

    private void removeFilament(Filament filament) {
        FilamentModel filamentModel = this.getItems().stream().filter(f -> f.getFilament().equals(filament)).findFirst().orElse(null);
        this.removeFilament(filamentModel);
    }

    private void removeFilament(FilamentModel filamentModel) {
        this.getItems().remove((Object)filamentModel);
        this.filaments.remove(filamentModel.getFilament());
        this.overlayService.remove(filamentModel.getFilament());
        this.updateNFilamentsField();
    }

    private void removeFilaments(List<FilamentModel> filamentModels) {
        for (FilamentModel filamentModel : filamentModels) {
            this.overlayService.remove(filamentModel.getFilament());
            this.filaments.remove(filamentModel.getFilament());
        }
        this.getItems().removeAll(filamentModels);
        this.updateNFilamentsField();
    }

    @EventHandler
    public void filamentSelected(FilamentSelectedEvent event) {
        FilamentModel filamentModel = this.getItems().stream().filter(f -> f.getFilament().equals(event.getFilament())).findFirst().orElse(null);
        if (filamentModel != null) {
            Platform.runLater(() -> {
                this.getSelectionModel().clearSelection();
                this.getSelectionModel().select((Object)filamentModel);
            });
        }
    }

    public Pane getInfoPane() {
        return this.infoPane;
    }

    public void updateNFilamentsField() {
        if (this.filaments.size() == 0) {
            this.nFilamentsField.setText("");
        } else {
            this.nFilamentsField.setText(this.filaments.size() + " Filaments.");
        }
    }
}

