/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.java3d.TexCoordGenerationRetained;
import org.jogamp.vecmath.Vector4f;

public class TexCoordGeneration
extends NodeComponent {
    public static final int ALLOW_ENABLE_READ = 0;
    public static final int ALLOW_ENABLE_WRITE = 1;
    public static final int ALLOW_FORMAT_READ = 2;
    public static final int ALLOW_MODE_READ = 3;
    public static final int ALLOW_PLANE_READ = 4;
    public static final int ALLOW_PLANE_WRITE = 5;
    public static final int OBJECT_LINEAR = 0;
    public static final int EYE_LINEAR = 1;
    public static final int SPHERE_MAP = 2;
    public static final int NORMAL_MAP = 3;
    public static final int REFLECTION_MAP = 4;
    public static final int TEXTURE_COORDINATE_2 = 0;
    public static final int TEXTURE_COORDINATE_3 = 1;
    public static final int TEXTURE_COORDINATE_4 = 2;
    private static final int[] readCapabilities = new int[]{0, 2, 3, 4};

    public TexCoordGeneration() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public TexCoordGeneration(int genMode, int format) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((TexCoordGenerationRetained)this.retained).initGenMode(genMode);
        ((TexCoordGenerationRetained)this.retained).initFormat(format);
    }

    public TexCoordGeneration(int genMode, int format, Vector4f planeS) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((TexCoordGenerationRetained)this.retained).initGenMode(genMode);
        ((TexCoordGenerationRetained)this.retained).initFormat(format);
        ((TexCoordGenerationRetained)this.retained).initPlaneS(planeS);
    }

    public TexCoordGeneration(int genMode, int format, Vector4f planeS, Vector4f planeT) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((TexCoordGenerationRetained)this.retained).initGenMode(genMode);
        ((TexCoordGenerationRetained)this.retained).initFormat(format);
        ((TexCoordGenerationRetained)this.retained).initPlaneS(planeS);
        ((TexCoordGenerationRetained)this.retained).initPlaneT(planeT);
    }

    public TexCoordGeneration(int genMode, int format, Vector4f planeS, Vector4f planeT, Vector4f planeR) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((TexCoordGenerationRetained)this.retained).initGenMode(genMode);
        ((TexCoordGenerationRetained)this.retained).initFormat(format);
        ((TexCoordGenerationRetained)this.retained).initPlaneS(planeS);
        ((TexCoordGenerationRetained)this.retained).initPlaneT(planeT);
        ((TexCoordGenerationRetained)this.retained).initPlaneR(planeR);
    }

    public TexCoordGeneration(int genMode, int format, Vector4f planeS, Vector4f planeT, Vector4f planeR, Vector4f planeQ) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((TexCoordGenerationRetained)this.retained).initGenMode(genMode);
        ((TexCoordGenerationRetained)this.retained).initFormat(format);
        ((TexCoordGenerationRetained)this.retained).initPlaneS(planeS);
        ((TexCoordGenerationRetained)this.retained).initPlaneT(planeT);
        ((TexCoordGenerationRetained)this.retained).initPlaneR(planeR);
        ((TexCoordGenerationRetained)this.retained).initPlaneQ(planeQ);
    }

    public void setEnable(boolean state) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TexCoordGeneration0"));
        }
        if (this.isLive()) {
            ((TexCoordGenerationRetained)this.retained).setEnable(state);
        } else {
            ((TexCoordGenerationRetained)this.retained).initEnable(state);
        }
    }

    public boolean getEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TexCoordGeneration1"));
        }
        return ((TexCoordGenerationRetained)this.retained).getEnable();
    }

    public void setFormat(int format) {
        this.checkForLiveOrCompiled();
        ((TexCoordGenerationRetained)this.retained).initFormat(format);
    }

    public int getFormat() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TexCoordGeneration2"));
        }
        return ((TexCoordGenerationRetained)this.retained).getFormat();
    }

    public void setGenMode(int genMode) {
        this.checkForLiveOrCompiled();
        if (genMode < 0 || genMode > 4) {
            throw new IllegalArgumentException(J3dI18N.getString("TexCoordGeneration5"));
        }
        ((TexCoordGenerationRetained)this.retained).initGenMode(genMode);
    }

    public int getGenMode() {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TexCoordGeneration3"));
        }
        return ((TexCoordGenerationRetained)this.retained).getGenMode();
    }

    public void setPlaneS(Vector4f planeS) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TexCoordGeneration6"));
        }
        if (this.isLive()) {
            ((TexCoordGenerationRetained)this.retained).setPlaneS(planeS);
        } else {
            ((TexCoordGenerationRetained)this.retained).initPlaneS(planeS);
        }
    }

    public void getPlaneS(Vector4f planeS) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TexCoordGeneration4"));
        }
        ((TexCoordGenerationRetained)this.retained).getPlaneS(planeS);
    }

    public void setPlaneT(Vector4f planeT) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TexCoordGeneration6"));
        }
        if (this.isLive()) {
            ((TexCoordGenerationRetained)this.retained).setPlaneT(planeT);
        } else {
            ((TexCoordGenerationRetained)this.retained).initPlaneT(planeT);
        }
    }

    public void getPlaneT(Vector4f planeT) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TexCoordGeneration4"));
        }
        ((TexCoordGenerationRetained)this.retained).getPlaneT(planeT);
    }

    public void setPlaneR(Vector4f planeR) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TexCoordGeneration6"));
        }
        if (this.isLive()) {
            ((TexCoordGenerationRetained)this.retained).setPlaneR(planeR);
        } else {
            ((TexCoordGenerationRetained)this.retained).initPlaneR(planeR);
        }
    }

    public void getPlaneR(Vector4f planeR) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TexCoordGeneration4"));
        }
        ((TexCoordGenerationRetained)this.retained).getPlaneR(planeR);
    }

    public void setPlaneQ(Vector4f planeQ) {
        if (this.isLiveOrCompiled() && !this.getCapability(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TexCoordGeneration6"));
        }
        if (this.isLive()) {
            ((TexCoordGenerationRetained)this.retained).setPlaneQ(planeQ);
        } else {
            ((TexCoordGenerationRetained)this.retained).initPlaneQ(planeQ);
        }
    }

    public void getPlaneQ(Vector4f planeQ) {
        if (this.isLiveOrCompiled() && !this.getCapability(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TexCoordGeneration4"));
        }
        ((TexCoordGenerationRetained)this.retained).getPlaneQ(planeQ);
    }

    @Override
    void createRetained() {
        this.retained = new TexCoordGenerationRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        TexCoordGeneration tga = new TexCoordGeneration();
        tga.duplicateNodeComponent(this);
        return tga;
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        TexCoordGenerationRetained tex = (TexCoordGenerationRetained)originalNodeComponent.retained;
        TexCoordGenerationRetained rt = (TexCoordGenerationRetained)this.retained;
        Vector4f v = new Vector4f();
        rt.initGenMode(tex.getGenMode());
        tex.getPlaneS(v);
        rt.initPlaneS(v);
        tex.getPlaneT(v);
        rt.initPlaneT(v);
        tex.getPlaneR(v);
        rt.initPlaneR(v);
        tex.getPlaneQ(v);
        rt.initPlaneQ(v);
        rt.initFormat(tex.getFormat());
        rt.initEnable(tex.getEnable());
    }
}

