/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.overlay;

import net.imagej.Dataset;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.overlay.BinaryMaskOverlay;
import net.imagej.overlay.Overlay;
import net.imagej.overlay.ThresholdOverlay;
import net.imagej.threshold.ThresholdService;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.ops.pointset.PointSetIterator;
import net.imglib2.roi.BinaryMaskRegionOfInterest;
import net.imglib2.type.NativeType;
import net.imglib2.type.logic.BitType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.ColorRGB;

@Plugin(type=Command.class, menu={@Menu(label="Process", weight=3.0, mnemonic=112), @Menu(label="Binary", mnemonic=98), @Menu(label="Make Mask Overlay...")}, headless=true, attrs={@Attr(name="no-legacy")})
public class ConvertToMask
extends ContextCommand {
    @Parameter(label="Input display", description="The display containing the image to be converted to a binary mask.")
    private ImageDisplay input;
    @Parameter(label="Output mask", description="The overlay that is the result of the operation", type=ItemIO.OUTPUT)
    private Overlay output;
    @Parameter(label="Overlay color", description="The color used to display the overlay")
    private ColorRGB color = new ColorRGB(255, 0, 0);
    @Parameter(label="Overlay alpha", description="The transparency (transparent = 0) or opacity (opaque=255) of the overlay", min="0", max="255")
    private int alpha = 128;
    @Parameter
    private Context context;
    @Parameter
    private ImageDisplayService dispSrv;
    @Parameter
    private ThresholdService threshSrv;

    public void setInput(ImageDisplay disp) {
        this.input = disp;
    }

    public ImageDisplay getInput() {
        return this.input;
    }

    public void setColor(ColorRGB val) {
        this.color = val;
    }

    public ColorRGB getColor() {
        return this.color;
    }

    public void setAlpha(int val) {
        this.alpha = val;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public Overlay getOutput() {
        return this.output;
    }

    public void run() {
        if (!this.threshSrv.hasThreshold(this.input)) {
            this.cancel("This command requires a thresholded image.");
            return;
        }
        ThresholdOverlay thresh = this.threshSrv.getThreshold(this.input);
        PointSetIterator iter = thresh.getPointsWithin().iterator();
        if (!iter.hasNext()) {
            this.cancel("No pixels are within the threshold");
            return;
        }
        Dataset ds = this.dispSrv.getActiveDataset(this.input);
        int numDims = ds.numDimensions();
        long[] dimensions = new long[numDims];
        long[] min = new long[numDims];
        for (int i = 0; i < numDims; ++i) {
            min[i] = (long)Math.floor(thresh.realMin(i));
            dimensions[i] = (long)Math.floor(thresh.realMax(i) - thresh.realMin(i) + 1.0);
        }
        ArrayImg arrayMask = ArrayImgs.bits((long[])dimensions);
        BitType t = new BitType((NativeImg)arrayMask);
        arrayMask.setLinkedType((NativeType)t);
        IntervalView mask = Views.translate((RandomAccessibleInterval)arrayMask, (long[])min);
        RandomAccess raMask = mask.randomAccess();
        iter.reset();
        while (iter.hasNext()) {
            long[] pos = (long[])iter.next();
            raMask.setPosition(pos);
            ((BitType)raMask.get()).set(true);
        }
        this.output = new BinaryMaskOverlay(this.context, new BinaryMaskRegionOfInterest((RandomAccessibleInterval)mask));
        this.output.setAlpha(this.alpha);
        this.output.setFillColor(this.color);
        for (int i = 0; i < numDims; ++i) {
            this.output.setAxis(ds.axis(i), i);
        }
    }
}

