/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import java.io.File;
import java.io.RandomAccessFile;

public class Vaa3d_Writer
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (null == imp) {
            return;
        }
        SaveDialog sd = new SaveDialog("Save .v3draw...", ".v3draw", null);
        String dir = sd.getDirectory();
        if (null == dir) {
            return;
        }
        if (!(dir = dir.replace('\\', '/')).endsWith("/")) {
            dir = dir + "/";
        }
        Vaa3d_Writer.saveV3draw(imp, dir + sd.getFileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveV3draw(ImagePlus imp, String path) {
        String formatkey = "raw_image_stack_by_hpeng";
        File file = new File(path);
        RandomAccessFile out = null;
        try {
            int unitSize;
            int imtype = imp.getType();
            int[] dim = new int[5];
            dim = imp.getDimensions();
            if (dim[4] != 1) {
                IJ.error((String)"Error: Currently .v3draw writing not support 5d hyperstacks.");
                return;
            }
            int[] sz = new int[]{dim[0], dim[1], dim[3], dim[2]};
            switch (imtype) {
                case 4: {
                    unitSize = 1;
                    sz[3] = 3;
                    break;
                }
                case 0: {
                    unitSize = 1;
                    break;
                }
                case 1: {
                    unitSize = 2;
                    break;
                }
                case 2: {
                    unitSize = 4;
                    break;
                }
                default: {
                    unitSize = imp.getBitDepth() / 8;
                }
            }
            out = new RandomAccessFile(file, "rw");
            out.write(formatkey.getBytes());
            out.write("B".getBytes());
            out.write(Vaa3d_Writer.int2byte(unitSize, 2));
            for (int d : sz) {
                out.write(Vaa3d_Writer.int2byte(d, 4));
            }
            int w = sz[0];
            int h = sz[1];
            int nChannel = sz[3];
            int bitdepth = imp.getBitDepth();
            int layerOffset = w * h;
            long colorOffset = (long)layerOffset * (long)sz[2] * (long)unitSize;
            ImageStack stack = imp.getStack();
            switch (imtype) {
                case 4: {
                    byte[] r = new byte[layerOffset];
                    byte[] g = new byte[layerOffset];
                    byte[] b = new byte[layerOffset];
                    long currentRedPointer = 43L;
                    long currentGreenPointer = 43L + colorOffset;
                    long currentBluePointer = 43L + 2L * colorOffset;
                    for (int layer = 1; layer <= sz[2]; ++layer) {
                        ColorProcessor cp = (ColorProcessor)stack.getProcessor(layer);
                        cp.getRGB(r, g, b);
                        out.seek(currentRedPointer);
                        out.write(r);
                        currentRedPointer = out.getFilePointer();
                        out.seek(currentGreenPointer);
                        out.write(g);
                        currentGreenPointer = out.getFilePointer();
                        out.seek(currentBluePointer);
                        out.write(b);
                        currentBluePointer = out.getFilePointer();
                    }
                    r = null;
                    g = null;
                    b = null;
                    break;
                }
                case 0: {
                    byte[] imtmp = new byte[layerOffset];
                    long[] currentPointers = new long[sz[3]];
                    for (int cNumber = 0; cNumber < sz[3]; ++cNumber) {
                        currentPointers[cNumber] = 43L + (long)cNumber * colorOffset;
                    }
                    for (int layer = 1; layer <= sz[2]; ++layer) {
                        for (int channelIndex = 0; channelIndex < sz[3]; ++channelIndex) {
                            out.seek(currentPointers[channelIndex]);
                            imtmp = (byte[])stack.getPixels((layer - 1) * sz[3] + channelIndex + 1);
                            out.write(imtmp);
                            currentPointers[channelIndex] = out.getFilePointer();
                        }
                    }
                    imtmp = null;
                    break;
                }
                case 1: {
                    byte[] im16asbytes = new byte[2 * layerOffset];
                    long[] currentPointers16 = new long[sz[3]];
                    for (int cNumber = 0; cNumber < sz[3]; ++cNumber) {
                        currentPointers16[cNumber] = 43L + (long)cNumber * colorOffset;
                    }
                    for (int layer = 1; layer <= sz[2]; ++layer) {
                        for (int channelIndex = 0; channelIndex < sz[3]; ++channelIndex) {
                            out.seek(currentPointers16[channelIndex]);
                            im16asbytes = Vaa3d_Writer.ShortToByte_Twiddle_Method((short[])stack.getPixels((layer - 1) * sz[3] + channelIndex + 1));
                            out.write(im16asbytes);
                            currentPointers16[channelIndex] = out.getFilePointer();
                        }
                    }
                    im16asbytes = null;
                    break;
                }
                case 2: {
                    long[] im32 = new long[layerOffset];
                    byte[] im32asbytes = new byte[4 * layerOffset];
                    long[] currentPointers32 = new long[sz[3]];
                    for (int cNumber = 0; cNumber < sz[3]; ++cNumber) {
                        currentPointers32[cNumber] = 43L + (long)cNumber * colorOffset;
                    }
                    for (int layer = 1; layer <= sz[2]; ++layer) {
                        for (int channelIndex = 0; channelIndex < sz[3]; ++channelIndex) {
                            out.seek(currentPointers32[channelIndex]);
                            im32asbytes = Vaa3d_Writer.FloatToByte_Twiddle_Method((float[])stack.getPixels((layer - 1) * sz[3] + channelIndex + 1));
                            out.write(im32asbytes);
                            currentPointers32[channelIndex] = out.getFilePointer();
                        }
                    }
                    im32asbytes = null;
                    break;
                }
                default: {
                    IJ.error((String)"Image type not supported by this plugin");
                    return;
                }
            }
            out.close();
            IJ.showStatus((String)("Saved " + path));
        }
        catch (Exception e) {
            IJ.error((String)("Error:" + e.toString()));
            return;
        }
    }

    static byte[] int2byte(int num, int len) {
        byte[] by = new byte[len];
        for (int i = len - 1; i >= 0; --i) {
            by[i] = (byte)(num & 0xFF);
            num >>= 8;
        }
        return by;
    }

    static byte[] ShortToByte_Twiddle_Method(short[] input) {
        int iterations = input.length;
        byte[] buffer = new byte[input.length * 2];
        int byte_index = 0;
        int short_index = 0;
        while (short_index != iterations) {
            buffer[byte_index] = (byte)((input[short_index] & 0xFF00) >> 8);
            buffer[byte_index + 1] = (byte)(input[short_index] & 0xFF);
            ++short_index;
            byte_index += 2;
        }
        return buffer;
    }

    static byte[] FloatToByte_Twiddle_Method(float[] input) {
        int iterations = input.length;
        byte[] buffer = new byte[input.length * 4];
        int byte_index = 0;
        int short_index = 0;
        int t = 0;
        while (short_index != iterations) {
            t = Float.floatToIntBits(input[short_index]);
            buffer[byte_index + 3] = (byte)(t & 0xFF);
            buffer[byte_index + 2] = (byte)((t >>= 8) & 0xFF);
            buffer[byte_index + 1] = (byte)((t >>= 8) & 0xFF);
            buffer[byte_index + 0] = (byte)((t >>= 8) & 0xFF);
            t >>= 8;
            ++short_index;
            byte_index += 4;
        }
        return buffer;
    }
}

