/*
 * Decompiled with CFR 0.152.
 */
package fiji.geom;

import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public class AreaCalculations {
    public static double circumference(PathIterator path) {
        return new Circumference().calculate(path);
    }

    public static double triangleArea(double[] a, double[] b, double[] c) {
        return ((a[1] - b[1]) * (c[0] - a[0]) + (b[0] - a[0]) * (c[1] - a[1])) / 2.0;
    }

    public static double area(PathIterator path) {
        return new Area().calculate(path);
    }

    public static double[] centroid(PathIterator path) {
        Centroid centroid = new Centroid();
        centroid.apply(path);
        return centroid.getResult();
    }

    public static void main(String[] args) {
        GeneralPath path = new GeneralPath(0);
        path.moveTo(100.0f, 100.0f);
        path.lineTo(200.0f, 110.0f);
        path.lineTo(190.0f, 213.0f);
        path.lineTo(105.0f, 205.0f);
        path.closePath();
        double result = AreaCalculations.circumference(path.getPathIterator(null));
        double expect = Math.sqrt(10100.0) + Math.sqrt(10709.0) + Math.sqrt(7289.0) + Math.sqrt(11050.0);
        System.err.println("result: " + result + ", expect: " + expect + ", diff: " + (result - expect));
        result = AreaCalculations.triangleArea(new double[]{100.0, 100.0}, new double[]{200.0, 110.0}, new double[]{190.0, 213.0});
        expect = 5200.0;
        System.err.println("triangleArea: " + result + ", expect: " + expect + ", diff: " + (result - expect));
        result = AreaCalculations.triangleArea(new double[]{100.0, 100.0}, new double[]{190.0, 213.0}, new double[]{105.0, 205.0});
        expect = 4442.5;
        System.err.println("triangleArea: " + result + ", expect: " + expect + ", diff: " + (result - expect));
        result = AreaCalculations.area(path.getPathIterator(null));
        expect = 9642.5;
        System.err.println("result: " + result + ", expect: " + expect + ", diff: " + (result - expect));
        double[] result2 = AreaCalculations.centroid(path.getPathIterator(null));
        double area1 = AreaCalculations.triangleArea(new double[]{100.0, 100.0}, new double[]{200.0, 110.0}, new double[]{190.0, 213.0});
        double area2 = AreaCalculations.triangleArea(new double[]{100.0, 100.0}, new double[]{190.0, 213.0}, new double[]{105.0, 205.0});
        double[] expect2 = new double[]{(area1 * 490.0 / 3.0 + area2 * 395.0 / 3.0) / (area1 + area2), (area1 * 423.0 / 3.0 + area2 * 518.0 / 3.0) / (area1 + area2)};
        System.err.println("result: " + result2[0] + ", " + result2[1] + ", expect: " + expect2[0] + ", " + expect2[1] + ", diff: " + Math.sqrt((result2[0] - expect2[0]) * (result2[0] - expect2[0]) + (result2[1] - expect2[1]) * (result2[1] - expect2[1])));
    }

    protected static class Centroid
    extends Calculation {
        double totalArea;
        double x;
        double y;

        protected Centroid() {
        }

        @Override
        public void handleSegment() {
            double area = AreaCalculations.triangleArea(this.start, this.previous, this.current);
            this.totalArea += area;
            this.x += (this.start[0] + this.previous[0] + this.current[0]) / 3.0 * area;
            this.y += (this.start[1] + this.previous[1] + this.current[1]) / 3.0 * area;
        }

        public double[] getResult() {
            return new double[]{this.x / this.totalArea, this.y / this.totalArea};
        }
    }

    protected static class Area
    extends Calculation {
        protected Area() {
        }

        @Override
        public void handleSegment() {
            this.result += AreaCalculations.triangleArea(this.start, this.previous, this.current);
        }
    }

    protected static class Circumference
    extends Calculation {
        protected Circumference() {
        }

        @Override
        public void handleSegment() {
            double x = this.current[0] - this.previous[0];
            double y = this.current[1] - this.previous[1];
            this.result += Math.sqrt(x * x + y * y);
        }
    }

    protected static abstract class Calculation {
        protected double[] start = new double[2];
        protected double[] previous = new double[2];
        protected double[] current = new double[2];
        public double result;

        protected Calculation() {
        }

        public abstract void handleSegment();

        public void apply(PathIterator path) {
            while (!path.isDone()) {
                switch (path.currentSegment(this.current)) {
                    case 0: {
                        System.arraycopy(this.current, 0, this.start, 0, 2);
                        break;
                    }
                    case 4: {
                        System.arraycopy(this.start, 0, this.current, 0, 2);
                    }
                    case 1: {
                        this.handleSegment();
                        break;
                    }
                    default: {
                        throw new RuntimeException("invalid polygon");
                    }
                }
                double[] swap = this.current;
                this.current = this.previous;
                this.previous = swap;
                path.next();
            }
        }

        public double calculate(PathIterator path) {
            this.result = 0.0;
            this.apply(path);
            return this.result;
        }
    }
}

