/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.NonWritableChannelException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.function.TriFunction;
import org.janelia.saalfeldlab.n5.KeyValueAccess;
import org.janelia.saalfeldlab.n5.LockedChannel;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.http.ListResponseParser;

public class HttpKeyValueAccess
implements KeyValueAccess {
    private int readTimeoutMilliseconds = 5000;
    private int connectionTimeoutMilliseconds = 5000;
    private ListResponseParser listResponseParser = ListResponseParser.defaultListParser();
    private ListResponseParser listDirectoryResponseParser = ListResponseParser.defaultDirectoryListParser();

    public void setReadTimeout(int readTimeoutMilliseconds) {
        this.readTimeoutMilliseconds = readTimeoutMilliseconds;
    }

    public void setConnectionTimeout(int connectionTimeoutMilliseconds) {
        this.connectionTimeoutMilliseconds = connectionTimeoutMilliseconds;
    }

    public void setListParser(ListResponseParser parser) {
        this.listResponseParser = parser;
    }

    public void setListDirectoryParser(ListResponseParser parser) {
        this.listDirectoryResponseParser = parser;
    }

    @Override
    public String normalize(String path) {
        return N5URI.normalizeGroupPath(path);
    }

    @Override
    public URI uri(String normalPath) throws URISyntaxException {
        return new URI(normalPath);
    }

    @Override
    public boolean exists(String normalPath) {
        try {
            this.requireValidHttpResponse(normalPath, "HEAD", "Error checking existence: " + normalPath, true);
            return true;
        }
        catch (N5Exception.N5NoSuchKeyException e) {
            return false;
        }
    }

    @Override
    public boolean isDirectory(String normalPath) {
        try {
            this.requireValidHttpResponse(HttpKeyValueAccess.getDirectoryPath(normalPath), "HEAD", (TriFunction<Integer, String, HttpURLConnection, N5Exception>)((TriFunction)(code, msg, http) -> {
                N5Exception cause = HttpKeyValueAccess.validExistsResponse(code, "Error checking directory: " + normalPath, msg, true);
                if (code >= 300 && code < 400) {
                    String redirectLocation = http.getHeaderField("Location");
                    if (!redirectLocation.endsWith("/") && !redirectLocation.endsWith("index.html")) {
                        return new N5Exception.N5NoSuchKeyException("Found File at " + normalPath + " but was not directory");
                    }
                    return null;
                }
                return cause;
            }));
            return true;
        }
        catch (N5Exception e) {
            return false;
        }
    }

    private static String getDirectoryPath(String normalPath) {
        String directoryNormalPath = normalPath.endsWith("/") ? normalPath : normalPath + "/";
        return directoryNormalPath;
    }

    @Override
    public boolean isFile(String normalPath) {
        try {
            this.requireValidHttpResponse(HttpKeyValueAccess.getFilePath(normalPath), "HEAD", (TriFunction<Integer, String, HttpURLConnection, N5Exception>)((TriFunction)(code, msg, http) -> {
                String redirectLocation;
                N5Exception cause = HttpKeyValueAccess.validExistsResponse(code, "Error accessing file: " + normalPath, msg, true);
                if (code >= 300 && code < 400 && ((redirectLocation = http.getHeaderField("Location")).endsWith("/") || redirectLocation.endsWith("index.html"))) {
                    return new N5Exception.N5NoSuchKeyException("Found key at " + normalPath + " but was directory");
                }
                return cause;
            }));
            return true;
        }
        catch (N5Exception e) {
            return false;
        }
    }

    private static String getFilePath(String normalPath) {
        String fileNormalPath = normalPath.replaceAll("/+$", "");
        return fileNormalPath;
    }

    private HttpURLConnection httpRequest(String normalPath, String method) throws IOException {
        URL url = URI.create(normalPath).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setReadTimeout(this.readTimeoutMilliseconds);
        connection.setConnectTimeout(this.connectionTimeoutMilliseconds);
        connection.setRequestMethod(method);
        return connection;
    }

    @Override
    public LockedChannel lockForReading(String normalPath) throws IOException {
        try {
            if (!this.exists(normalPath)) {
                throw new N5Exception.N5NoSuchKeyException("Key does not exist: " + normalPath);
            }
            return new HttpObjectChannel(this.uri(normalPath));
        }
        catch (URISyntaxException e) {
            throw new N5Exception("Invalid URI Syntax", e);
        }
    }

    @Override
    public LockedChannel lockForWriting(String normalPath) throws IOException {
        throw new N5Exception("HttpKeyValueAccess is read-only");
    }

    @Override
    public String[] listDirectories(String normalPath) throws IOException {
        return this.queryListEntries(normalPath, this.listDirectoryResponseParser, true);
    }

    @Override
    public String[] list(String normalPath) throws IOException {
        return this.queryListEntries(normalPath, this.listResponseParser, true);
    }

    private String[] queryListEntries(String normalPath, ListResponseParser parser, boolean allowRedirect) {
        HttpURLConnection http = this.requireValidHttpResponse(normalPath, "GET", "Error listing directory at " + normalPath, allowRedirect);
        try {
            String listResponse = this.responseToString(http.getInputStream());
            return parser.parseListResponse(listResponse);
        }
        catch (IOException e) {
            throw new N5Exception.N5IOException("Error listing directory at " + normalPath, e);
        }
    }

    private static N5Exception validExistsResponse(int code, String responseMsg, String message, boolean allowRedirect) {
        if (code >= 200 && code < (allowRedirect ? 400 : 300)) {
            return null;
        }
        RuntimeException cause = new RuntimeException(message + "( " + responseMsg + ")(" + code + ")");
        if (code == 404) {
            return new N5Exception.N5NoSuchKeyException(message, cause);
        }
        return new N5Exception(message, cause);
    }

    private HttpURLConnection requireValidHttpResponse(String uri, String method, String message, boolean allowRedirect) throws N5Exception {
        return this.requireValidHttpResponse(uri, method, (TriFunction<Integer, String, HttpURLConnection, N5Exception>)((TriFunction)(code, msg, http) -> HttpKeyValueAccess.validExistsResponse(code, msg, message, allowRedirect)));
    }

    private HttpURLConnection requireValidHttpResponse(String uri, String method, TriFunction<Integer, String, HttpURLConnection, N5Exception> filterCode) throws N5Exception {
        String responseMsg;
        int code;
        HttpURLConnection http;
        try {
            http = this.httpRequest(uri, method);
            code = http.getResponseCode();
            responseMsg = http.getResponseMessage();
        }
        catch (IOException e) {
            throw new N5Exception.N5IOException("Could not validate HTTP Response", e);
        }
        N5Exception cause = (N5Exception)filterCode.apply((Object)code, (Object)responseMsg, (Object)http);
        if (cause != null) {
            throw cause;
        }
        return http;
    }

    private String responseToString(InputStream inputStream) throws IOException {
        return IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
    }

    @Override
    public void createDirectories(String normalPath) {
        throw new N5Exception("HttpKeyValueAccess is read-only");
    }

    @Override
    public void delete(String normalPath) {
        throw new N5Exception("HttpKeyValueAccess is read-only");
    }

    private class HttpObjectChannel
    implements LockedChannel {
        protected final URI uri;
        private final ArrayList<Closeable> resources = new ArrayList();

        protected HttpObjectChannel(URI uri) {
            this.uri = uri;
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return this.uri.toURL().openStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Reader newReader() throws IOException {
            InputStreamReader reader = new InputStreamReader(this.newInputStream(), StandardCharsets.UTF_8);
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                this.resources.add(reader);
            }
            return reader;
        }

        @Override
        public OutputStream newOutputStream() {
            throw new NonWritableChannelException();
        }

        @Override
        public Writer newWriter() {
            throw new NonWritableChannelException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                for (Closeable resource : this.resources) {
                    resource.close();
                }
                this.resources.clear();
            }
        }
    }
}

