/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import java.util.TreeSet;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.BoundaryPolyCirculinearCurve2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearContour2D;
import math.geom2d.circulinear.CirculinearCurve2D;
import math.geom2d.circulinear.CirculinearCurveArray2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.circulinear.NonCirculinearClassException;
import math.geom2d.circulinear.PolyCirculinearCurve2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.conic.CircularShape2D;
import math.geom2d.curve.ContinuousCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.Curves2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.line.LinearShape2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CirculinearCurves2D {
    public static CirculinearCurve2D convert(Curve2D curve) {
        if (curve instanceof CirculinearCurve2D) {
            return (CirculinearCurve2D)curve;
        }
        if (curve instanceof ContinuousCurve2D) {
            ContinuousCurve2D continuous = (ContinuousCurve2D)curve;
            Collection<? extends SmoothCurve2D> smoothPieces = continuous.smoothPieces();
            ArrayList<CirculinearElement2D> elements = new ArrayList<CirculinearElement2D>(smoothPieces.size());
            for (SmoothCurve2D smoothCurve2D : smoothPieces) {
                if (smoothCurve2D instanceof CirculinearElement2D) {
                    elements.add((CirculinearElement2D)smoothCurve2D);
                    continue;
                }
                throw new NonCirculinearClassException(smoothCurve2D);
            }
            return new PolyCirculinearCurve2D(elements);
        }
        if (curve instanceof CurveSet2D) {
            CurveSet2D set = (CurveSet2D)curve;
            Collection<? extends ContinuousCurve2D> continuousCurves = set.continuousCurves();
            ArrayList<CirculinearContinuousCurve2D> curves = new ArrayList<CirculinearContinuousCurve2D>(continuousCurves.size());
            for (ContinuousCurve2D continuousCurve2D : continuousCurves) {
                if (continuousCurve2D instanceof CirculinearContinuousCurve2D) {
                    curves.add((CirculinearContinuousCurve2D)continuousCurve2D);
                    continue;
                }
                curves.add((CirculinearContinuousCurve2D)CirculinearCurves2D.convert(continuousCurve2D));
            }
            return CirculinearCurveArray2D.create(curves);
        }
        return null;
    }

    public static double getLength(CurveSet2D<? extends CirculinearCurve2D> curve, double pos) {
        double length = 0.0;
        int index = curve.curveIndex(pos);
        int i = 0;
        while (i < index) {
            length += curve.get(i).length();
            ++i;
        }
        if (index < curve.size()) {
            double pos2 = curve.localPosition(pos - (double)(2 * index));
            length += curve.get(index).length(pos2);
        }
        return length;
    }

    public static double getPosition(CurveSet2D<? extends CirculinearCurve2D> curveSet, double length) {
        double pos = 0.0;
        int index = 0;
        double cumLength = CirculinearCurves2D.getLength(curveSet, curveSet.t0());
        for (CirculinearCurve2D circulinearCurve2D : curveSet.curves()) {
            double curveLength = circulinearCurve2D.length();
            if (cumLength + curveLength < length) {
                cumLength += curveLength;
                ++index;
                continue;
            }
            double pos2 = circulinearCurve2D.position(length - cumLength);
            pos = curveSet.globalPosition(index, pos2);
            break;
        }
        return pos;
    }

    public static Collection<Point2D> findSelfIntersections(CirculinearCurve2D curve) {
        ArrayList<? extends CirculinearElement2D> elements = new ArrayList<CirculinearElement2D>();
        for (CirculinearContinuousCurve2D circulinearContinuousCurve2D : curve.continuousCurves()) {
            elements.addAll(circulinearContinuousCurve2D.smoothPieces());
        }
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>(0);
        int n = elements.size();
        int i = 0;
        while (i < n - 1) {
            CirculinearElement2D elem1 = (CirculinearElement2D)elements.get(i);
            int j = i;
            while (j < n) {
                CirculinearElement2D elem2 = (CirculinearElement2D)elements.get(j);
                for (Point2D inter : CirculinearCurves2D.findIntersections(elem1, elem2)) {
                    if (CirculinearCurves2D.isCommonVertex(inter, elem1, elem2)) continue;
                    arrayList.add(inter);
                }
                ++j;
            }
            ++i;
        }
        return arrayList;
    }

    public static double[][] locateSelfIntersections(CurveSet2D<? extends CirculinearElement2D> curve) {
        ArrayList<Double> list1 = new ArrayList<Double>(0);
        ArrayList<Double> list2 = new ArrayList<Double>(0);
        int n = curve.size();
        int i = 0;
        while (i < n - 1) {
            CirculinearElement2D elem1 = curve.get(i);
            int j = i + 1;
            while (j < n) {
                CirculinearElement2D elem2 = curve.get(j);
                for (Point2D inter : CirculinearCurves2D.findIntersections(elem1, elem2)) {
                    if (CirculinearCurves2D.isCommonVertex(inter, elem1, elem2)) continue;
                    double dt = Curves2D.toUnitSegment(elem1.position(inter), elem1.t0(), elem1.t1());
                    list1.add((double)(2 * i) + dt);
                    dt = Curves2D.toUnitSegment(elem2.position(inter), elem2.t0(), elem2.t1());
                    list2.add((double)(2 * j) + dt);
                }
                ++j;
            }
            ++i;
        }
        int np = list1.size();
        double[][] result = new double[np][2];
        int i2 = 0;
        while (i2 < np) {
            result[i2][0] = (Double)list1.get(i2);
            result[i2][1] = (Double)list2.get(i2);
            ++i2;
        }
        return result;
    }

    private static boolean isCommonVertex(Point2D inter, CirculinearCurve2D elem1, CirculinearCurve2D elem2) {
        double eps = 1.0E-12;
        if (!Double.isInfinite(elem1.t1()) && !Double.isInfinite(elem2.t0()) && inter.almostEquals(elem1.lastPoint(), eps) && inter.almostEquals(elem2.firstPoint(), eps)) {
            return true;
        }
        return !Double.isInfinite(elem1.t0()) && !Double.isInfinite(elem2.t1()) && inter.almostEquals(elem1.firstPoint(), eps) && inter.almostEquals(elem2.lastPoint(), eps);
    }

    public static Collection<Point2D> findIntersections(CirculinearCurve2D curve1, CirculinearCurve2D curve2) {
        ArrayList<? extends CirculinearElement2D> elements1 = new ArrayList<CirculinearElement2D>();
        ArrayList<? extends CirculinearElement2D> elements2 = new ArrayList<CirculinearElement2D>();
        for (CirculinearContinuousCurve2D circulinearContinuousCurve2D : curve1.continuousCurves()) {
            elements1.addAll(circulinearContinuousCurve2D.smoothPieces());
        }
        for (CirculinearContinuousCurve2D circulinearContinuousCurve2D : curve2.continuousCurves()) {
            elements2.addAll(circulinearContinuousCurve2D.smoothPieces());
        }
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>(0);
        int n1 = elements1.size();
        int n2 = elements2.size();
        int i = 0;
        while (i < n1) {
            CirculinearElement2D elem1 = (CirculinearElement2D)elements1.get(i);
            int j = 0;
            while (j < n2) {
                CirculinearElement2D elem2 = (CirculinearElement2D)elements2.get(j);
                for (Point2D inter : CirculinearCurves2D.findIntersections(elem1, elem2)) {
                    arrayList.add(inter);
                }
                ++j;
            }
            ++i;
        }
        return arrayList;
    }

    public static double[][] locateIntersections(CirculinearCurve2D curve1, CirculinearCurve2D curve2) {
        ArrayList<Double> list1 = new ArrayList<Double>(0);
        ArrayList<Double> list2 = new ArrayList<Double>(0);
        ArrayList<? extends CirculinearElement2D> elements1 = new ArrayList<CirculinearElement2D>();
        ArrayList<? extends CirculinearElement2D> elements2 = new ArrayList<CirculinearElement2D>();
        for (CirculinearContinuousCurve2D circulinearContinuousCurve2D : curve1.continuousCurves()) {
            elements1.addAll(circulinearContinuousCurve2D.smoothPieces());
        }
        for (CirculinearContinuousCurve2D circulinearContinuousCurve2D : curve2.continuousCurves()) {
            elements2.addAll(circulinearContinuousCurve2D.smoothPieces());
        }
        int n = elements1.size();
        int n2 = elements2.size();
        int i = 0;
        while (i < n) {
            CirculinearElement2D elem1 = (CirculinearElement2D)elements1.get(i);
            int j = 0;
            while (j < n2) {
                CirculinearElement2D elem2 = (CirculinearElement2D)elements2.get(j);
                for (Point2D inter : CirculinearCurves2D.findIntersections(elem1, elem2)) {
                    double pos1 = curve1.position(inter);
                    double pos2 = curve2.position(inter);
                    if (curve1.isSingular(pos1) && curve2.isSingular(pos2)) continue;
                    list1.add(pos1);
                    list2.add(pos2);
                }
                ++j;
            }
            ++i;
        }
        int np = list1.size();
        double[][] result = new double[np][2];
        int i2 = 0;
        while (i2 < np) {
            result[i2][0] = (Double)list1.get(i2);
            result[i2][1] = (Double)list2.get(i2);
            ++i2;
        }
        return result;
    }

    public static Collection<Point2D> findIntersections(CirculinearElement2D elem1, CirculinearElement2D elem2) {
        boolean b1 = elem1 instanceof LinearShape2D;
        boolean b2 = elem2 instanceof LinearShape2D;
        if (b1 && b2) {
            Vector2D v2;
            LinearShape2D line1 = (LinearShape2D)((Object)elem1);
            LinearShape2D line2 = (LinearShape2D)((Object)elem2);
            Vector2D v1 = line1.direction();
            if (Vector2D.isColinear(v1, v2 = line2.direction())) {
                return new ArrayList<Point2D>(0);
            }
            return line1.intersections(line2);
        }
        if (elem1 instanceof LinearShape2D) {
            return elem2.intersections((LinearShape2D)((Object)elem1));
        }
        if (elem2 instanceof LinearShape2D) {
            return elem1.intersections((LinearShape2D)((Object)elem2));
        }
        Circle2D circ1 = ((CircularShape2D)elem1).supportingCircle();
        Circle2D circ2 = ((CircularShape2D)elem2).supportingCircle();
        ArrayList<Point2D> pts = new ArrayList<Point2D>(2);
        for (Point2D inter : Circle2D.circlesIntersections(circ1, circ2)) {
            if (!elem1.contains(inter) || !elem2.contains(inter)) continue;
            pts.add(inter);
        }
        return pts;
    }

    public static Collection<CirculinearContinuousCurve2D> splitContinuousCurve(CirculinearContinuousCurve2D curve) {
        double pos2;
        double pos1;
        ArrayList<CirculinearContinuousCurve2D> result = new ArrayList<CirculinearContinuousCurve2D>();
        if (curve instanceof CirculinearElement2D) {
            result.add(curve);
            return result;
        }
        PolyCirculinearCurve2D<CirculinearElement2D> polyCurve = CirculinearCurves2D.createPolyCurve(curve.smoothPieces(), curve.isClosed());
        double[][] couples = CirculinearCurves2D.locateSelfIntersections(polyCurve);
        if (couples.length == 0) {
            result.add(CirculinearCurves2D.createPolyCurve(polyCurve.smoothPieces(), curve.isClosed()));
            return result;
        }
        TreeMap<Double, Double> twins = new TreeMap<Double, Double>();
        int i = 0;
        while (i < couples.length) {
            pos1 = couples[i][0];
            pos2 = couples[i][1];
            twins.put(pos1, pos2);
            twins.put(pos2, pos1);
            ++i;
        }
        ArrayList<CirculinearElement2D> elements = new ArrayList<CirculinearElement2D>();
        pos1 = polyCurve.t0();
        double pos0 = pos2 = ((Double)twins.firstKey()).doubleValue();
        CirculinearCurves2D.addElements(elements, (CirculinearContinuousCurve2D)polyCurve.subCurve(pos1, pos2));
        while (twins.higherKey(pos1 = ((Double)twins.remove(pos2)).doubleValue()) != null) {
            pos2 = twins.higherKey(pos1);
            CirculinearCurves2D.addElements(elements, (CirculinearContinuousCurve2D)polyCurve.subCurve(pos1, pos2));
        }
        pos2 = polyCurve.t1();
        CirculinearCurves2D.addElements(elements, (CirculinearContinuousCurve2D)polyCurve.subCurve(pos1, pos2));
        result.add(CirculinearCurves2D.createPolyCurve(elements, curve.isClosed()));
        while (!twins.isEmpty()) {
            elements = new ArrayList();
            pos0 = (Double)twins.firstKey();
            pos1 = (Double)twins.get(pos0);
            pos2 = twins.higherKey(pos1);
            CirculinearCurves2D.addElements(elements, (CirculinearContinuousCurve2D)polyCurve.subCurve(pos1, pos2));
            while (pos2 != pos0) {
                pos1 = (Double)twins.remove(pos2);
                if (twins.higherKey(pos1) == null) break;
                pos2 = twins.higherKey(pos1);
                CirculinearCurves2D.addElements(elements, (CirculinearContinuousCurve2D)polyCurve.subCurve(pos1, pos2));
            }
            pos1 = (Double)twins.remove(pos2);
            result.add(CirculinearCurves2D.createPolyCurve(elements, true));
        }
        return result;
    }

    private static PolyCirculinearCurve2D<CirculinearElement2D> createPolyCurve(Collection<? extends CirculinearElement2D> elements, boolean closed) {
        return new PolyCirculinearCurve2D<CirculinearElement2D>(elements, closed);
    }

    public static Collection<CirculinearContour2D> splitIntersectingContours(CirculinearContour2D curve1, CirculinearContour2D curve2) {
        double pos2;
        double pos1;
        ArrayList<CirculinearContour2D> contours = new ArrayList<CirculinearContour2D>();
        double[][] couples = CirculinearCurves2D.locateIntersections(curve1, curve2);
        if (couples.length == 0) {
            contours.add(curve1);
            contours.add(curve2);
            return contours;
        }
        TreeMap<Double, Double> twins1 = new TreeMap<Double, Double>();
        TreeMap<Double, Double> twins2 = new TreeMap<Double, Double>();
        TreeSet<Double> positions1 = new TreeSet<Double>();
        TreeSet<Double> positions2 = new TreeSet<Double>();
        int i = 0;
        while (i < couples.length) {
            pos1 = couples[i][0];
            pos2 = couples[i][1];
            twins1.put(pos1, pos2);
            twins2.put(pos2, pos1);
            positions1.add(pos1);
            positions2.add(pos2);
            ++i;
        }
        while (!twins1.isEmpty()) {
            double pos0;
            ArrayList<CirculinearElement2D> elements = new ArrayList<CirculinearElement2D>();
            pos1 = pos0 = ((Double)twins2.firstEntry().getValue()).doubleValue();
            do {
                pos2 = CirculinearCurves2D.nextValue(positions1, pos1);
                CirculinearCurves2D.addElements(elements, (CirculinearContinuousCurve2D)curve1.subCurve(pos1, pos2));
                pos1 = (Double)twins1.remove(pos2);
                pos2 = CirculinearCurves2D.nextValue(positions2, pos1);
                CirculinearCurves2D.addElements(elements, (CirculinearContinuousCurve2D)curve2.subCurve(pos1, pos2));
            } while ((pos1 = ((Double)twins2.remove(pos2)).doubleValue()) != pos0);
            contours.add((CirculinearContour2D)((Object)BoundaryPolyCirculinearCurve2D.create(elements, true)));
        }
        return contours;
    }

    public static Collection<CirculinearContour2D> splitIntersectingContours(Collection<? extends CirculinearContour2D> curves) {
        int ind0;
        double pos2;
        double pos1;
        double pos0 = 0.0;
        CirculinearContour2D[] curveArray = curves.toArray(new CirculinearContour2D[0]);
        int nCurves = curves.size();
        ArrayList twinIndices = new ArrayList(nCurves);
        ArrayList<TreeMap<Double, Double>> twinPositions = new ArrayList<TreeMap<Double, Double>>(nCurves);
        int i = 0;
        while (i < nCurves) {
            twinIndices.add(i, new TreeMap());
            twinPositions.add(i, new TreeMap());
            ++i;
        }
        ArrayList positions = new ArrayList(nCurves);
        int i2 = 0;
        while (i2 < nCurves) {
            positions.add(i2, new TreeSet());
            ++i2;
        }
        i2 = 0;
        while (i2 < nCurves - 1) {
            CirculinearContour2D curve1 = curveArray[i2];
            int j = i2 + 1;
            while (j < nCurves) {
                CirculinearContour2D curve2 = curveArray[j];
                double[][] couples = CirculinearCurves2D.locateIntersections(curve1, curve2);
                int k = 0;
                while (k < couples.length) {
                    pos1 = couples[k][0];
                    pos2 = couples[k][1];
                    ((TreeSet)positions.get(i2)).add(pos1);
                    ((TreeSet)positions.get(j)).add(pos2);
                    ((TreeMap)twinIndices.get(i2)).put(pos1, j);
                    ((TreeMap)twinIndices.get(j)).put(pos2, i2);
                    twinPositions.get(i2).put(pos1, pos2);
                    twinPositions.get(j).put(pos2, pos1);
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        ArrayList<CirculinearContour2D> contours = new ArrayList<CirculinearContour2D>();
        int i3 = 0;
        while (i3 < nCurves) {
            if (((TreeMap)twinPositions.get(i3)).isEmpty()) {
                contours.add(curveArray[i3]);
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < nCurves) {
            if (!curveArray[i3].isBounded() && !twinPositions.get(i3).isEmpty()) {
                pos0 = twinPositions.get(i3).firstEntry().getKey();
                ind0 = (Integer)((TreeMap)twinIndices.get(i3)).firstEntry().getValue();
                ArrayList<CirculinearElement2D> elements = new ArrayList<CirculinearElement2D>();
                CirculinearContour2D curve0 = curveArray[i3];
                CirculinearCurves2D.addElements(elements, (CirculinearContinuousCurve2D)curve0.subCurve(curve0.t0(), pos0));
                pos1 = twinPositions.get(i3).firstEntry().getValue();
                int ind = ind0;
                do {
                    CirculinearContour2D curve = curveArray[ind];
                    pos2 = CirculinearCurves2D.nextValue((TreeSet)positions.get(ind), pos1);
                    if (pos2 < pos1 && !curve.isBounded()) {
                        CirculinearCurves2D.addElements(elements, (CirculinearContinuousCurve2D)curve.subCurve(pos1, curve.t1()));
                        continue;
                    }
                    CirculinearCurves2D.addElements(elements, (CirculinearContinuousCurve2D)curve.subCurve(pos1, pos2));
                    pos1 = twinPositions.get(ind).remove(pos2);
                    ind = (Integer)((TreeMap)twinIndices.get(ind)).remove(pos2);
                } while (ind != ind0);
                twinPositions.get(i3).remove(pos0);
                ((TreeMap)twinIndices.get(i3)).remove(pos0);
                contours.add((CirculinearContour2D)((Object)BoundaryPolyCirculinearCurve2D.create(elements, true)));
            }
            ++i3;
        }
        while (!CirculinearCurves2D.isAllEmpty(twinPositions)) {
            ArrayList<CirculinearElement2D> elements = new ArrayList<CirculinearElement2D>();
            ind0 = 0;
            int i4 = 0;
            while (i4 < nCurves) {
                if (!twinPositions.get(i4).isEmpty()) {
                    pos0 = twinPositions.get(i4).firstEntry().getValue();
                    ind0 = (Integer)((TreeMap)twinIndices.get(i4)).firstEntry().getValue();
                    break;
                }
                ++i4;
            }
            if (ind0 == 0) {
                System.out.println("No more intersections, but was not detected");
            }
            pos1 = pos0;
            int ind = ind0;
            do {
                pos2 = CirculinearCurves2D.nextValue((TreeSet)positions.get(ind), pos1);
                CirculinearCurves2D.addElements(elements, (CirculinearContinuousCurve2D)curveArray[ind].subCurve(pos1, pos2));
                pos1 = twinPositions.get(ind).remove(pos2);
                ind = (Integer)((TreeMap)twinIndices.get(ind)).remove(pos2);
            } while (pos1 != pos0 || ind != ind0);
            contours.add((CirculinearContour2D)((Object)BoundaryPolyCirculinearCurve2D.create(elements, true)));
        }
        return contours;
    }

    private static void addElements(Collection<CirculinearElement2D> elements, CirculinearContinuousCurve2D curve) {
        elements.addAll(curve.smoothPieces());
    }

    private static boolean isAllEmpty(Collection<TreeMap<Double, Double>> coll) {
        for (TreeMap<Double, Double> map : coll) {
            if (map.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static double nextValue(TreeSet<Double> tree, double value) {
        if (tree.higher(value) == null) {
            return tree.first();
        }
        return tree.higher(value);
    }

    public static double getDistanceCurvePoints(CirculinearCurve2D curve, Collection<? extends Point2D> points) {
        double minDist = Double.MAX_VALUE;
        for (Point2D point2D : points) {
            minDist = Math.min(minDist, curve.distance(point2D));
        }
        return minDist;
    }
}

