/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear.buffer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.Point2D;
import math.geom2d.circulinear.BoundaryPolyCirculinearCurve2D;
import math.geom2d.circulinear.CirculinearBoundary2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearContour2D;
import math.geom2d.circulinear.CirculinearContourArray2D;
import math.geom2d.circulinear.CirculinearCurve2D;
import math.geom2d.circulinear.CirculinearCurveArray2D;
import math.geom2d.circulinear.CirculinearCurves2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.circulinear.GenericCirculinearDomain2D;
import math.geom2d.circulinear.GenericCirculinearRing2D;
import math.geom2d.circulinear.PolyCirculinearCurve2D;
import math.geom2d.circulinear.buffer.CapFactory;
import math.geom2d.circulinear.buffer.JoinFactory;
import math.geom2d.circulinear.buffer.RoundCapFactory;
import math.geom2d.circulinear.buffer.RoundJoinFactory;
import math.geom2d.conic.Circle2D;
import math.geom2d.curve.Curves2D;
import math.geom2d.line.StraightLine2D;
import math.geom2d.point.PointSet2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferCalculator {
    private static BufferCalculator defaultInstance = null;
    private JoinFactory joinFactory;
    private CapFactory capFactory;

    public static BufferCalculator getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new BufferCalculator();
        }
        return defaultInstance;
    }

    public BufferCalculator() {
        this.joinFactory = new RoundJoinFactory();
        this.capFactory = new RoundCapFactory();
    }

    public BufferCalculator(JoinFactory joinFactory, CapFactory capFactory) {
        this.joinFactory = joinFactory;
        this.capFactory = capFactory;
    }

    public CirculinearCurve2D createParallel(CirculinearCurve2D curve, double dist) {
        if (curve instanceof CirculinearContinuousCurve2D) {
            return this.createContinuousParallel((CirculinearContinuousCurve2D)curve, dist);
        }
        CirculinearCurveArray2D<CirculinearContinuousCurve2D> parallels = new CirculinearCurveArray2D<CirculinearContinuousCurve2D>();
        for (CirculinearContinuousCurve2D circulinearContinuousCurve2D : curve.continuousCurves()) {
            CirculinearContinuousCurve2D contParallel = this.createContinuousParallel(circulinearContinuousCurve2D, dist);
            if (contParallel == null) continue;
            parallels.add(contParallel);
        }
        return parallels;
    }

    public CirculinearBoundary2D createParallelBoundary(CirculinearBoundary2D boundary, double dist) {
        if (boundary instanceof CirculinearContour2D) {
            return this.createParallelContour((CirculinearContour2D)boundary, dist);
        }
        Collection<? extends CirculinearContour2D> contours = boundary.continuousCurves();
        ArrayList<CirculinearContour2D> parallelContours = new ArrayList<CirculinearContour2D>(contours.size());
        for (CirculinearContour2D circulinearContour2D : contours) {
            parallelContours.add(circulinearContour2D.parallel(dist));
        }
        return CirculinearContourArray2D.create(parallelContours);
    }

    public CirculinearContour2D createParallelContour(CirculinearContour2D contour, double dist) {
        if (contour instanceof StraightLine2D) {
            return ((StraightLine2D)contour).parallel(dist);
        }
        if (contour instanceof Circle2D) {
            return ((Circle2D)contour).parallel(dist);
        }
        Collection<CirculinearContinuousCurve2D> parallelCurves = this.getParallelElements(contour, dist);
        return BoundaryPolyCirculinearCurve2D.create(parallelCurves, contour.isClosed());
    }

    public CirculinearContinuousCurve2D createContinuousParallel(CirculinearContinuousCurve2D curve, double dist) {
        if (curve instanceof CirculinearElement2D) {
            return ((CirculinearElement2D)curve).parallel(dist);
        }
        Collection<CirculinearContinuousCurve2D> parallelCurves = this.getParallelElements(curve, dist);
        return PolyCirculinearCurve2D.create(parallelCurves, curve.isClosed());
    }

    private Collection<CirculinearContinuousCurve2D> getParallelElements(CirculinearContinuousCurve2D curve, double dist) {
        CirculinearContinuousCurve2D join;
        Collection<? extends CirculinearElement2D> elements = curve.smoothPieces();
        Iterator<? extends CirculinearElement2D> iterator = elements.iterator();
        CirculinearElement2D previous = null;
        CirculinearElement2D current = null;
        ArrayList<CirculinearContinuousCurve2D> parallelCurves = new ArrayList<CirculinearContinuousCurve2D>();
        if (!iterator.hasNext()) {
            return parallelCurves;
        }
        current = iterator.next();
        CirculinearElement2D parallel = current.parallel(dist);
        parallelCurves.add(parallel);
        while (iterator.hasNext()) {
            previous = current;
            join = this.joinFactory.createJoin(previous, current = iterator.next(), dist);
            if (join.length() > 0.0) {
                parallelCurves.add(join);
            }
            parallelCurves.add(current.parallel(dist));
        }
        if (curve.isClosed() && (join = this.joinFactory.createJoin(previous = current, current = elements.iterator().next(), dist)).length() > 0.0) {
            parallelCurves.add(join);
        }
        return parallelCurves;
    }

    public CirculinearDomain2D computeBuffer(CirculinearCurve2D curve, double dist) {
        ArrayList<Object> contours = new ArrayList();
        for (CirculinearContinuousCurve2D circulinearContinuousCurve2D : curve.continuousCurves()) {
            for (CirculinearContinuousCurve2D splitted : CirculinearCurves2D.splitContinuousCurve(circulinearContinuousCurve2D)) {
                contours.addAll(this.computeBufferSimpleCurve(splitted, dist));
            }
        }
        contours = new ArrayList<CirculinearContour2D>(CirculinearCurves2D.splitIntersectingContours(contours));
        ArrayList<CirculinearContour2D> arrayList = new ArrayList<CirculinearContour2D>(contours.size());
        for (CirculinearContour2D circulinearContour2D : contours) {
            double distCurves;
            Collection<Point2D> intersects = CirculinearCurves2D.findIntersections(curve, circulinearContour2D);
            Collection<Point2D> vertices = curve.singularPoints();
            vertices = curve.vertices();
            intersects.removeAll(vertices);
            if (intersects.size() > 0 || (distCurves = this.getDistanceCurveSingularPoints(curve, circulinearContour2D)) < dist - 1.0E-12) continue;
            arrayList.add(circulinearContour2D);
        }
        return new GenericCirculinearDomain2D(CirculinearContourArray2D.create(arrayList));
    }

    public CirculinearDomain2D computeBuffer(PointSet2D set, double dist) {
        Collection<Object> contours = new ArrayList(set.size());
        for (Point2D point : set) {
            contours.add(new Circle2D(point, Math.abs(dist), dist > 0.0));
        }
        contours = CirculinearCurves2D.splitIntersectingContours(contours);
        ArrayList<CirculinearContour2D> contours2 = new ArrayList<CirculinearContour2D>(contours.size());
        for (CirculinearContour2D circulinearContour2D : contours) {
            double minDist = CirculinearCurves2D.getDistanceCurvePoints(circulinearContour2D, set.points());
            if (minDist < dist - 1.0E-12) continue;
            contours2.add(circulinearContour2D);
        }
        return new GenericCirculinearDomain2D(CirculinearContourArray2D.create(contours2));
    }

    private Collection<? extends CirculinearContour2D> computeBufferSimpleCurve(CirculinearContinuousCurve2D curve, double d) {
        ArrayList<CirculinearContour2D> contours = new ArrayList<CirculinearContour2D>(2);
        CirculinearContinuousCurve2D parallel1 = this.createContinuousParallel(curve, d);
        CirculinearContinuousCurve2D parallel2 = this.createContinuousParallel(curve, -d).reverse();
        if (curve.isClosed()) {
            contours.add(this.convertCurveToBoundary(parallel1));
            contours.add(this.convertCurveToBoundary(parallel2));
        } else {
            contours.addAll(this.createSingleContourFromTwoParallels(parallel1, parallel2));
        }
        Collection<CirculinearContour2D> contours2 = this.removeIntersectingContours(contours, curve, d);
        return contours2;
    }

    private Collection<CirculinearContour2D> createSingleContourFromTwoParallels(CirculinearContinuousCurve2D curve1, CirculinearContinuousCurve2D curve2) {
        ArrayList<CirculinearContour2D> contours = new ArrayList<CirculinearContour2D>();
        if (curve1 != null && curve2 != null) {
            boolean b1;
            ArrayList<CirculinearElement2D> elements = new ArrayList<CirculinearElement2D>();
            boolean b0 = !Curves2D.isLeftInfinite(curve1);
            boolean bl = b1 = !Curves2D.isRightInfinite(curve1);
            if (b0 && b1) {
                Point2D p11 = curve1.firstPoint();
                Point2D p12 = curve1.lastPoint();
                Point2D p21 = curve2.firstPoint();
                Point2D p22 = curve2.lastPoint();
                elements.addAll(curve1.smoothPieces());
                CirculinearContinuousCurve2D cap = this.capFactory.createCap(p12, p21);
                elements.addAll(cap.smoothPieces());
                elements.addAll(curve2.smoothPieces());
                cap = this.capFactory.createCap(p22, p11);
                elements.addAll(cap.smoothPieces());
                contours.add(new GenericCirculinearRing2D((Collection<? extends CirculinearElement2D>)elements));
            } else if (!b0 && !b1) {
                contours.add(this.convertCurveToBoundary(curve1));
                contours.add(this.convertCurveToBoundary(curve2));
            } else if (b0 && !b1) {
                Point2D p11 = curve1.firstPoint();
                Point2D p22 = curve2.lastPoint();
                elements.addAll(curve2.smoothPieces());
                CirculinearContinuousCurve2D cap = this.capFactory.createCap(p22, p11);
                elements.addAll(cap.smoothPieces());
                elements.addAll(curve1.smoothPieces());
                contours.add(new GenericCirculinearRing2D((Collection<? extends CirculinearElement2D>)elements));
            } else if (b1 && !b0) {
                Point2D p12 = curve1.lastPoint();
                Point2D p21 = curve2.firstPoint();
                elements.addAll(curve1.smoothPieces());
                CirculinearContinuousCurve2D cap = this.capFactory.createCap(p12, p21);
                elements.addAll(cap.smoothPieces());
                elements.addAll(curve2.smoothPieces());
                contours.add(new GenericCirculinearRing2D((Collection<? extends CirculinearElement2D>)elements));
            }
        }
        return contours;
    }

    private Collection<CirculinearContour2D> removeIntersectingContours(Collection<CirculinearContour2D> contours, CirculinearCurve2D curve, double d) {
        ArrayList<CirculinearContour2D> contours2 = new ArrayList<CirculinearContour2D>();
        for (CirculinearContour2D contour : contours) {
            for (CirculinearContinuousCurve2D splitted : CirculinearCurves2D.splitContinuousCurve(contour)) {
                double dist = CirculinearCurves2D.getDistanceCurvePoints(curve, splitted.singularPoints());
                if (dist - d < -1.0E-12) continue;
                contours2.add(this.convertCurveToBoundary(splitted));
            }
        }
        return contours2;
    }

    private CirculinearContour2D convertCurveToBoundary(CirculinearContinuousCurve2D curve) {
        if (curve instanceof CirculinearContour2D) {
            return (CirculinearContour2D)curve;
        }
        if (curve.isClosed()) {
            return GenericCirculinearRing2D.create(curve.smoothPieces());
        }
        return BoundaryPolyCirculinearCurve2D.create(curve.smoothPieces());
    }

    private double getDistanceCurveSingularPoints(CirculinearCurve2D ref, CirculinearCurve2D curve) {
        Collection<Point2D> points = curve.singularPoints();
        if (points.isEmpty()) {
            points = new ArrayList<Point2D>();
            double t = Curves2D.choosePosition(curve.t0(), curve.t1());
            points.add(curve.point(t));
        }
        double minDist = Double.MAX_VALUE;
        for (Point2D point : points) {
            minDist = Math.min(minDist, ref.distance(point));
        }
        return minDist;
    }
}

