/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.componenttree.pixellist;

import java.util.ArrayList;
import java.util.Iterator;
import net.imglib2.Localizable;
import net.imglib2.algorithm.componenttree.Component;
import net.imglib2.algorithm.componenttree.pixellist.PixelList;
import net.imglib2.algorithm.componenttree.pixellist.PixelListPartialComponent;
import net.imglib2.type.Type;

public final class PixelListComponent<T extends Type<T>>
implements Component<T, PixelListComponent<T>> {
    private final ArrayList<PixelListComponent<T>> children = new ArrayList();
    private PixelListComponent<T> parent = null;
    private final T value;
    private final PixelList pixelList;

    PixelListComponent(PixelListPartialComponent<T> intermediate) {
        this.value = intermediate.getValue().copy();
        this.pixelList = new PixelList(intermediate.pixelList);
        if (intermediate.emittedComponent != null) {
            this.children.add(intermediate.emittedComponent);
        }
        for (PixelListPartialComponent c : intermediate.children) {
            this.children.add(c.emittedComponent);
            c.emittedComponent.parent = this;
        }
        intermediate.emittedComponent = this;
        intermediate.children.clear();
    }

    @Override
    public T value() {
        return this.value;
    }

    @Override
    public long size() {
        return this.pixelList.size();
    }

    @Override
    public Iterator<Localizable> iterator() {
        return this.pixelList.iterator();
    }

    @Override
    public ArrayList<PixelListComponent<T>> getChildren() {
        return this.children;
    }

    @Override
    public PixelListComponent<T> getParent() {
        return this.parent;
    }
}

