/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.kdtree;

import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import net.imglib2.algorithm.kdtree.HyperPlane;
import net.imglib2.algorithm.kdtree.NodeIndexIterable;
import net.imglib2.kdtree.KDTreeImpl;

class SplitHyperPlaneKDTreeImpl {
    private final KDTreeImpl tree;
    private final int n;
    private final double[] normal;
    private double m;
    private final double[] xmin;
    private final double[] xmax;
    private final TIntArrayList aboveNodes;
    private final TIntArrayList aboveSubtrees;
    private final TIntArrayList belowNodes;
    private final TIntArrayList belowSubtrees;

    public SplitHyperPlaneKDTreeImpl(KDTreeImpl tree) {
        this.tree = tree;
        this.n = tree.numDimensions();
        this.normal = new double[this.n];
        this.xmin = new double[this.n];
        this.xmax = new double[this.n];
        this.aboveNodes = new TIntArrayList();
        this.aboveSubtrees = new TIntArrayList();
        this.belowNodes = new TIntArrayList();
        this.belowSubtrees = new TIntArrayList();
    }

    public int numDimensions() {
        return this.n;
    }

    public void split(HyperPlane plane) {
        this.initNewSearch();
        System.arraycopy(plane.getNormal(), 0, this.normal, 0, this.n);
        this.m = plane.getDistance();
        this.split(this.tree.root(), 0);
    }

    public void split(double[] plane) {
        this.initNewSearch();
        System.arraycopy(plane, 0, this.normal, 0, this.n);
        this.m = plane[this.n];
        this.split(this.tree.root(), 0);
    }

    private void initNewSearch() {
        this.aboveNodes.clear();
        this.aboveSubtrees.clear();
        this.belowNodes.clear();
        this.belowSubtrees.clear();
        Arrays.fill(this.xmin, Double.NEGATIVE_INFINITY);
        Arrays.fill(this.xmax, Double.POSITIVE_INFINITY);
    }

    public NodeIndexIterable getAboveNodes() {
        return new NodeIndexIterable(this.aboveNodes, this.aboveSubtrees, this.tree);
    }

    public NodeIndexIterable getBelowNodes() {
        return new NodeIndexIterable(this.belowNodes, this.belowSubtrees, this.tree);
    }

    private boolean allAbove() {
        double dot = 0.0;
        for (int d = 0; d < this.n; ++d) {
            dot += this.normal[d] * (this.normal[d] >= 0.0 ? this.xmin[d] : this.xmax[d]);
        }
        return dot >= this.m;
    }

    private boolean allBelow() {
        double dot = 0.0;
        for (int d = 0; d < this.n; ++d) {
            dot += this.normal[d] * (this.normal[d] < 0.0 ? this.xmin[d] : this.xmax[d]);
        }
        return dot < this.m;
    }

    private void splitSubtree(int currentNodeIndex, int parentsd, boolean p, boolean q) {
        if (p && q && this.allAbove()) {
            this.aboveSubtrees.add(currentNodeIndex);
        } else if (!p && !q && this.allBelow()) {
            this.belowSubtrees.add(currentNodeIndex);
        } else {
            this.split(currentNodeIndex, (parentsd + 1) % this.n);
        }
    }

    private void split(int currentNodeIndex, int sd) {
        boolean p;
        double sc = this.tree.getDoublePosition(currentNodeIndex, sd);
        int left = this.tree.left(currentNodeIndex);
        int right = this.tree.right(currentNodeIndex);
        double dot = 0.0;
        for (int d = 0; d < this.n; ++d) {
            dot += this.tree.getDoublePosition(currentNodeIndex, d) * this.normal[d];
        }
        boolean bl = p = dot >= this.m;
        if (p) {
            this.aboveNodes.add(currentNodeIndex);
        } else {
            this.belowNodes.add(currentNodeIndex);
        }
        if (left >= 0) {
            double max = this.xmax[sd];
            this.xmax[sd] = sc;
            this.splitSubtree(left, sd, p, this.normal[sd] < 0.0);
            this.xmax[sd] = max;
        }
        if (right >= 0) {
            double min = this.xmin[sd];
            this.xmin[sd] = sc;
            this.splitSubtree(right, sd, p, this.normal[sd] >= 0.0);
            this.xmin[sd] = min;
        }
    }
}

